/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.step.BDDStepMatcher;
import com.qmetry.qaf.automation.step.JavaStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.text.BDDDefinitionHelper;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.text.StrSubstitutor;

public class BDDStepMatcherFactory {
    public static BDDStepMatcher getStepMatcher(TestStep s) {
        if (!(s instanceof JavaStep) || ((JavaStep)s).isQafStepImpl()) {
            return new DefaultBDDStepMatcher();
        }
        return new GherkinStepMatcher();
    }

    public static class DefaultBDDStepMatcher
    implements BDDStepMatcher {
        @Override
        public boolean matches(String stepDescription, String stepCall, Map<String, Object> context) {
            stepCall = BDDDefinitionHelper.quoteParams(stepCall);
            return BDDDefinitionHelper.matches(stepDescription, stepCall);
        }

        @Override
        public List<String[]> getArgsFromCall(String stepDescription, String stepCall, Map<String, Object> context) {
            stepCall = BDDDefinitionHelper.quoteParams(stepCall);
            return BDDDefinitionHelper.getArgsFromCall(stepDescription, stepCall);
        }
    }

    public static class GherkinStepMatcher
    implements BDDStepMatcher {
        @Override
        public boolean matches(String stepDescription, String stepCall, Map<String, Object> context) {
            stepCall = this.replaceParams(stepCall, context);
            Pattern p = this.getPattern(stepDescription);
            return p.matcher(stepCall).matches();
        }

        @Override
        public List<String[]> getArgsFromCall(String stepDescription, String stepCall, Map<String, Object> context) {
            ArrayList<String[]> args = new ArrayList<String[]>();
            stepCall = this.replaceParams(stepCall, context);
            Matcher matcher = this.getMatcher(stepDescription, stepCall);
            while (matcher.find()) {
                int i = 1;
                while (i <= matcher.groupCount()) {
                    String arg = matcher.group(i);
                    args.add(new String[]{arg, BDDDefinitionHelper.ParamType.getType(arg).name()});
                    ++i;
                }
            }
            return args;
        }

        private String replaceParams(String stepCall, Map<String, Object> context) {
            stepCall = StrSubstitutor.replace((Object)stepCall, context);
            stepCall = ConfigurationManager.getBundle().getSubstitutor().replace(stepCall);
            return stepCall;
        }

        private Matcher getMatcher(String stepDescription, String stepName) {
            Pattern pattern = this.getPattern(GherkinStepMatcher.opArgs(stepDescription));
            if (pattern.matcher(stepName).lookingAt()) {
                return pattern.matcher(stepName);
            }
            pattern = this.getPattern(stepDescription);
            return pattern.matcher(stepName);
        }

        private Pattern getPattern(String stepDescription) {
            if (stepDescription.endsWith(":$")) {
                String exp = "(.+)";
                stepDescription = StringUtil.replace((String)stepDescription, (String)":$", (String)(":" + exp + "$"), (int)1);
            }
            return Pattern.compile(stepDescription, 2);
        }

        private static String opArgs(String stepDescription) {
            String st = Pattern.quote("(?:");
            String end = Pattern.quote(")?");
            Pattern pattern = Pattern.compile(String.valueOf(st) + ".*" + end);
            Matcher matcher = pattern.matcher(stepDescription);
            while (matcher.find()) {
                int i = 0;
                while (i <= matcher.groupCount()) {
                    String match = matcher.group(i);
                    match = match.substring(3, match.length() - 2);
                    stepDescription = stepDescription.replaceFirst(String.valueOf(st) + ".*" + end, match);
                    ++i;
                }
            }
            return stepDescription;
        }
    }
}

