/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.step.BDDStepMatcher;
import com.qmetry.qaf.automation.step.BDDStepMatcherFactory;
import com.qmetry.qaf.automation.step.BaseTestStep;
import com.qmetry.qaf.automation.step.DryRunAnalyzer;
import com.qmetry.qaf.automation.step.StepExecutionTracker;
import com.qmetry.qaf.automation.step.StepInvocationException;
import com.qmetry.qaf.automation.step.StepNotFoundException;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.text.BDDDefinitionHelper;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class StringTestStep
extends BaseTestStep {
    private String resultParameterName;
    private Map<String, Object> context;
    private String codeSnippet;
    private TestStep step;

    public StringTestStep(String name, Object ... actualArgs) {
        this.name = name;
        this.description = name;
        this.setActualArgs(actualArgs);
        this.context = new HashMap<String, Object>();
    }

    public StringTestStep(String name, Map<String, Object> context, Object ... actualArgs) {
        this(name, actualArgs);
        this.context = context;
    }

    public void initStep() {
        if (this.step == null) {
            this.step = this.getTestStep();
            if (this.step != null) {
                this.step.setActualArgs(this.actualArgs);
                this.step.setDescription(this.description);
                this.step.getStepExecutionTracker().setContext(this.getStepExecutionTracker().getContext());
            }
        }
    }

    public TestStep deepClone() {
        this.initStep();
        TestStep s = this.step.clone();
        s.setActualArgs(this.actualArgs);
        s.getStepExecutionTracker().setContext(this.getStepExecutionTracker().getContext());
        return s.clone();
    }

    @Override
    public Object[] getActualArgs() {
        return this.step == null ? super.getActualArgs() : this.step.getActualArgs();
    }

    @Override
    public void setActualArgs(Object ... args) {
        super.setActualArgs(args);
        if (this.step != null) {
            this.step.setActualArgs(args);
        }
    }

    public StringTestStep() {
    }

    public static void addSteps(Map<String, TestStep> steps) {
        ConfigurationManager.getStepMapping().putAll(steps);
    }

    public static void addStep(String name, TestStep step) {
        ConfigurationManager.getStepMapping().put(name.toUpperCase(), step);
    }

    public void setResultParamName(String resultParamName) {
        this.resultParameterName = resultParamName;
    }

    @Override
    public Object execute() {
        if (DryRunAnalyzer.isDryRun(this)) {
            return null;
        }
        this.initStep();
        if (this.step != null) {
            Object retVal = null;
            try {
                retVal = this.step.execute();
                if (StringUtils.isNotBlank((String)this.resultParameterName)) {
                    if (this.resultParameterName.indexOf("${") == 0) {
                        ConfigurationManager.getBundle().setProperty(this.resultParameterName, retVal);
                    } else {
                        ConfigurationManager.getBundle().setProperty("${" + this.resultParameterName + "}", retVal);
                    }
                }
            }
            catch (Error ae) {
                StepInvocationException se = new StepInvocationException(this, ae);
                ae.setStackTrace(se.getStackTrace());
                throw ae;
            }
            catch (Throwable e) {
                StepInvocationException se = new StepInvocationException(this, e);
                RuntimeException re = RuntimeException.class.isAssignableFrom(e.getClass()) ? (RuntimeException)e : new RuntimeException(e);
                re.setStackTrace(se.getStackTrace());
                throw re;
            }
            return retVal;
        }
        throw new StepNotFoundException(this);
    }

    @Override
    public String getSignature() {
        return String.valueOf(this.name) + "@" + this.getFileName() + "#" + this.getLineNumber();
    }

    public static Object execute(String stepName, Object ... args) {
        StringTestStep proxy = new StringTestStep(stepName, args);
        proxy.initStep();
        return proxy.execute();
    }

    @Override
    public TestStep clone() {
        StringTestStep clone = new StringTestStep(this.name, this.actualArgs != null ? (Object[])this.actualArgs.clone() : null);
        clone.setFileName(this.fileName);
        clone.setLineNumber(this.lineNumber);
        clone.resultParameterName = this.resultParameterName;
        clone.context = this.context;
        return clone;
    }

    public TestStep getTestStep() {
        TestStep step = null;
        String prefix = BDDDefinitionHelper.BDDKeyword.getKeywordFrom(this.name);
        String nameWithoutPrefix = StringTestStep.removePrefix(prefix, this.name);
        if (ConfigurationManager.getStepMapping().containsKey(nameWithoutPrefix.toUpperCase())) {
            step = ConfigurationManager.getStepMapping().get(nameWithoutPrefix.toUpperCase()).clone();
        } else if (ConfigurationManager.getBundle().getBoolean("step.natural.lang.support", true)) {
            Collection<TestStep> set = ConfigurationManager.getStepMapping().values();
            for (TestStep stepName : set) {
                BDDStepMatcher matcher = BDDStepMatcherFactory.getStepMatcher(stepName);
                if (!matcher.matches(stepName.getDescription(), nameWithoutPrefix, this.context)) continue;
                List<String[]> parameters = matcher.getArgsFromCall(stepName.getDescription(), nameWithoutPrefix, this.context);
                Object[] params2 = new Object[parameters.size()];
                int i = 0;
                while (i < parameters.size()) {
                    params2[i] = parameters.get(i)[0];
                    ++i;
                }
                this.setActualArgs(params2);
                step = ConfigurationManager.getStepMapping().get(stepName.getName().toUpperCase()).clone();
                step.getStepExecutionTracker().setType(prefix);
                break;
            }
        }
        return step;
    }

    private static String removePrefix(String prefix, String s) {
        if (StringUtil.isBlank((String)prefix)) {
            return s;
        }
        return s.substring(prefix.length()).trim();
    }

    @Override
    protected Object doExecute() {
        return null;
    }

    @Override
    public StepExecutionTracker getStepExecutionTracker() {
        return this.step != null ? this.step.getStepExecutionTracker() : null;
    }

    public String getCodeSnippet() {
        if (StringUtil.isBlank((String)this.codeSnippet)) {
            this.generateCodeSnippet();
        }
        return this.codeSnippet;
    }

    private void generateCodeSnippet() {
        this.absractArgsAandSetDesciption();
        StringBuilder snippet = new StringBuilder("\n/**\n* Auto-generated code snippet by QMetry Automation Framework.\n*/");
        snippet.append("\n@QAFTestStep(description=\"" + this.description + "\")");
        snippet.append("\npublic void " + this.name + "(");
        int i = 0;
        while (i < this.actualArgs.length) {
            String arg = ((String)this.actualArgs[i]).trim();
            if (arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("false")) {
                snippet.append("Boolean b" + i);
            } else {
                BDDDefinitionHelper.ParamType type = BDDDefinitionHelper.ParamType.getType(arg);
                snippet.append(String.valueOf(type.getArgString()) + i);
            }
            if (i < this.actualArgs.length - 1) {
                snippet.append(',');
            }
            ++i;
        }
        snippet.append("){");
        snippet.append("\n\t//TODO: remove NotYetImplementedException and call test steps");
        snippet.append("\n\tthrow new NotYetImplementedException();\n}");
        this.codeSnippet = snippet.toString();
    }

    private void absractArgsAandSetDesciption() {
        String prefix = BDDDefinitionHelper.BDDKeyword.getKeywordFrom(this.name);
        if (this.actualArgs == null || this.actualArgs.length == 0) {
            String REGEX = BDDDefinitionHelper.ParamType.getParamValueRegx();
            ArrayList<String> arguments = new ArrayList<String>();
            this.description = StringTestStep.removePrefix(prefix, this.name);
            Pattern p = Pattern.compile(REGEX);
            Matcher m = p.matcher(this.description);
            int count = 0;
            while (m.find()) {
                String arg = this.description.substring(m.start(), m.end());
                arguments.add(arg);
                ++count;
            }
            int i = 0;
            while (i < count) {
                this.description = this.description.replaceFirst(Pattern.quote((String)arguments.get(i)), Matcher.quoteReplacement("{" + i + "}"));
                ++i;
            }
            this.actualArgs = arguments.toArray(new String[0]);
        }
        this.name = StringUtil.toCamelCaseIdentifier(this.description.length() > 0 ? this.description : this.name);
    }
}

