/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client.text;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BehaviorScanner {
    private static final Log logger = LogFactory.getLog(BehaviorScanner.class);
    private static final String LINE_BREAK = "_&";
    private static final String COMMENT_CHARS = "#!";

    public static ArrayList<Object[]> scan(String strFile) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        int lineNo = 0;
        BufferedReader br = null;
        try {
            try {
                logger.info((Object)("loading text file: " + strFile));
                File textFile = new File(strFile);
                br = new BufferedReader(new FileReader(textFile));
                String strLine = "";
                StringBuffer currLineBuffer = new StringBuffer();
                while ((strLine = br.readLine()) != null) {
                    ++lineNo;
                    if ("".equalsIgnoreCase(strLine.trim()) || COMMENT_CHARS.contains("" + strLine.trim().charAt(0))) continue;
                    currLineBuffer.append(strLine.trim());
                    if (strLine.endsWith(LINE_BREAK)) {
                        currLineBuffer.delete(currLineBuffer.length() - LINE_BREAK.length(), currLineBuffer.length());
                        continue;
                    }
                    Object[] cols = new Object[]{"", "", "", lineNo};
                    String currLine = currLineBuffer.toString();
                    if (StringUtil.indexOfIgnoreCase((String)currLine, (String)"SCENARIO") == 0 || StringUtil.indexOfIgnoreCase((String)currLine, (String)"STEP-DEF") == 0 || StringUtil.indexOfIgnoreCase((String)currLine, (String)"META") == 0) {
                        System.arraycopy(currLine.split(":", 2), 0, cols, 0, 2);
                        if (StringUtil.indexOfIgnoreCase((String)((String)cols[0]).trim(), (String)"META") == 0) {
                            Object[] row = new Object[4];
                            int prevIndex = rows.size() - 1;
                            Object[] prevRow = rows.remove(prevIndex);
                            System.arraycopy(prevRow, 0, row, 0, 2);
                            row[2] = ((String)cols[1]).trim();
                            row[3] = prevRow[3];
                            rows.add(row);
                            currLineBuffer = new StringBuffer();
                            continue;
                        }
                    } else {
                        cols[0] = currLine;
                    }
                    rows.add(cols);
                    currLineBuffer = new StringBuffer();
                }
            }
            catch (Exception e) {
                String strMsg = "Exception while reading BDD file: " + strFile + "#" + lineNo;
                logger.error((Object)(String.valueOf(strMsg) + e));
                throw new AutomationError(strMsg, e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rows;
    }
}

