/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng;

import com.qmetry.qaf.automation.testng.Priority;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.testng.IMethodInstance;
import org.testng.log4testng.Logger;

public class MethodPriorityComparator
implements Comparator<IMethodInstance> {
    String orderedGroups;
    private static final Logger log = Logger.getLogger(MethodPriorityComparator.class);

    public MethodPriorityComparator(String orderedGroup) {
        this.orderedGroups = orderedGroup;
    }

    public MethodPriorityComparator() {
    }

    @Override
    public int compare(IMethodInstance o1, IMethodInstance o2) {
        int o2Priority;
        log.debug((Object)(String.valueOf(o1.getMethod().getMethodName()) + " O2: " + o2.getMethod().getMethodName() + " Order : " + this.orderedGroups));
        String method1Name = o1.getMethod().getMethodName();
        String method2Name = o2.getMethod().getMethodName();
        HashSet<String> o1Dependency = new HashSet<String>(Arrays.asList(o1.getMethod().getMethodsDependedUpon()));
        HashSet<String> o2Dependency = new HashSet<String>(Arrays.asList(o1.getMethod().getMethodsDependedUpon()));
        if (o1Dependency.contains(method2Name)) {
            return -1;
        }
        if (o2Dependency.contains(method1Name)) {
            return 1;
        }
        HashSet<String> o1Set = new HashSet<String>(Arrays.asList(o1.getMethod().getGroups()));
        HashSet<String> o2Set = new HashSet<String>(Arrays.asList(o1.getMethod().getGroups()));
        o1Dependency = new HashSet<String>(Arrays.asList(o1.getMethod().getGroupsDependedUpon()));
        o2Dependency = new HashSet<String>(Arrays.asList(o1.getMethod().getGroupsDependedUpon()));
        HashSet<String> depends = new HashSet<String>(o1Dependency);
        depends.retainAll(o2Set);
        if (!depends.isEmpty()) {
            return -1;
        }
        depends = new HashSet<String>(o2Dependency);
        depends.retainAll(o1Set);
        if (!depends.isEmpty()) {
            return 1;
        }
        int o1Priority = this.getGroupOrder(o1);
        if (o1Priority == (o2Priority = this.getGroupOrder(o2).intValue()) && (o1Priority = this.getClassOrder(o1)) == (o2Priority = this.getClassOrder(o2))) {
            o1Priority = this.getMethodOrder(o1);
            o2Priority = this.getMethodOrder(o2);
        }
        if (o1Priority == -1) {
            o1Priority = o2Priority + 1;
        }
        if (o2Priority == -1) {
            o2Priority = o1Priority + 1;
        }
        return o1Priority - o2Priority;
    }

    private Integer getGroupOrder(IMethodInstance o) {
        String groupName;
        if (this.orderedGroups == null) {
            return 0;
        }
        String string = groupName = o.getMethod().getGroups() != null && o.getMethod().getGroups().length > 0 ? o.getMethod().getGroups()[0] : "NONE";
        if (!this.orderedGroups.contains("NONE")) {
            this.orderedGroups = String.valueOf(this.orderedGroups) + ", NONE";
        }
        if (!this.orderedGroups.contains(groupName)) {
            this.orderedGroups = String.valueOf(this.orderedGroups) + "," + groupName;
        }
        log.debug((Object)(String.valueOf(o.getMethod().getMethodName()) + " Group: " + groupName + " Order : " + this.orderedGroups));
        return this.orderedGroups.toUpperCase().indexOf(groupName.toUpperCase());
    }

    private int getClassOrder(IMethodInstance mi) {
        int result = -1;
        Class<?> cls = mi.getMethod().getConstructorOrMethod().getMethod().getDeclaringClass();
        Priority classPriority = cls.getAnnotation(Priority.class);
        if (classPriority != null) {
            result = classPriority.value();
        }
        return result;
    }

    private int getMethodOrder(IMethodInstance mi) {
        int result = -1;
        Method method = mi.getMethod().getConstructorOrMethod().getMethod();
        Priority a1 = method.getAnnotation(Priority.class);
        if (a1 != null) {
            result = a1.value();
        }
        return result;
    }
}

