/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.dataprovider;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.testng.pro.DataProviderUtil;
import com.qmetry.qaf.automation.util.CSVUtil;
import com.qmetry.qaf.automation.util.DatabaseUtil;
import com.qmetry.qaf.automation.util.ExcelUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class DataProviderFactory {
    public static final String getDataProvider(Method method) {
        Map<String, String> map = DataProviderFactory.getParameters(method);
        return DataProviderFactory.getDataProvider(map);
    }

    public static Object[][] getData(Map<String, String> param) {
        String dataproviderName = DataProviderFactory.getDataProvider(param);
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_excel.name())) {
            return ExcelUtil.getExcelDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.SHEETNAME.name()));
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_excel_table.name())) {
            return ExcelUtil.getTableDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.KEY.name()), param.get(QAFDataProvider.params.SHEETNAME.name()));
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_csv.name())) {
            return (Object[][])CSVUtil.getCSVDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name())).toArray((T[])new Object[0][]);
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_database.name())) {
            String query = param.get(QAFDataProvider.params.SQLQUERY.name());
            return DatabaseUtil.getRecordDataAsMap(query);
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_property.name())) {
            List<Object[]> mapData = DataProviderUtil.getDataSetAsMap(param.get(QAFDataProvider.params.KEY.name()));
            return (Object[][])mapData.toArray((T[])new Object[0][]);
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_json.name())) {
            if (param.containsKey((Object)QAFDataProvider.params.JSON_DATA_TABLE)) {
                return JSONUtil.getJsonArrayOfMaps(param.get(QAFDataProvider.params.JSON_DATA_TABLE.name()));
            }
            return JSONUtil.getJsonArrayOfMaps(param.get(QAFDataProvider.params.DATAFILE.name()));
        }
        throw new RuntimeException("No data provider found");
    }

    public static final String getDataProvider(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        if (map.containsKey(QAFDataProvider.params.JSON_DATA_TABLE.name())) {
            return QAFDataProvider.dataproviders.isfw_json.name();
        }
        String f = map.get(QAFDataProvider.params.DATAFILE.name());
        if (StringUtil.isNotBlank((String)f)) {
            if (f.endsWith(".xls")) {
                return StringUtil.isNotBlank((String)map.get(QAFDataProvider.params.KEY.name())) ? QAFDataProvider.dataproviders.isfw_excel_table.name() : QAFDataProvider.dataproviders.isfw_excel.name();
            }
            if (f.endsWith(".json")) {
                return QAFDataProvider.dataproviders.isfw_json.name();
            }
            return QAFDataProvider.dataproviders.isfw_csv.name();
        }
        return StringUtil.isNotBlank((String)map.get(QAFDataProvider.params.SQLQUERY.name())) ? QAFDataProvider.dataproviders.isfw_database.name() : (StringUtil.isNotBlank((String)map.get(QAFDataProvider.params.KEY.name())) ? QAFDataProvider.dataproviders.isfw_property.name() : "");
    }

    protected static Map<String, String> getParameters(Method method) {
        String key;
        PropertyUtil props = ConfigurationManager.getBundle();
        if (props.containsKey(key = String.valueOf(method.getName()) + ".testdata")) {
            return StringUtil.toMap(props.getStringArray(key), true);
        }
        if (props.containsKey("global.testdata")) {
            Map<String, String> map = StringUtil.toMap(props.getStringArray("global.testdata"), true);
            String cls = method.getDeclaringClass().getSimpleName();
            String mtd = method.getName();
            String val = props.getSubstitutor().replace(map.get(QAFDataProvider.params.DATAFILE.name()));
            map.put(QAFDataProvider.params.DATAFILE.name(), val.replace("${class}", cls).replace("${method}", mtd));
            if (StringUtil.isNotBlank((String)map.get(QAFDataProvider.params.SHEETNAME.name()))) {
                val = props.getSubstitutor().replace(map.get(QAFDataProvider.params.SHEETNAME.name()));
                map.put(QAFDataProvider.params.SHEETNAME.name(), val.replace("${class}", cls).replace("${method}", mtd));
            }
            if (StringUtil.isNotBlank((String)map.get(QAFDataProvider.params.KEY.name()))) {
                val = props.getSubstitutor().replace(map.get(QAFDataProvider.params.KEY.name()));
                map.put(QAFDataProvider.params.KEY.name(), val.replace("${class}", cls).replace("${method}", mtd));
            }
            return map;
        }
        if (props.containsKey("test." + method.getName() + ".datafile")) {
            WeakHashMap<String, String> map = new WeakHashMap<String, String>();
            String[] oldStlyVal = props.getString("test." + method.getName() + ".datafile").split(",");
            map.put(QAFDataProvider.params.DATAFILE.name(), oldStlyVal[0]);
            if (oldStlyVal.length > 1) {
                map.put(QAFDataProvider.params.SHEETNAME.name(), oldStlyVal[1]);
            }
            return map;
        }
        if (method.isAnnotationPresent(QAFDataProvider.class)) {
            WeakHashMap<String, String> map = new WeakHashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            QAFDataProvider dp = method.getAnnotation(QAFDataProvider.class);
            sb.append(String.valueOf(QAFDataProvider.params.DATAFILE.name()) + "=" + dp.dataFile());
            sb.append(";");
            sb.append(String.valueOf(QAFDataProvider.params.SHEETNAME.name()) + "=" + dp.sheetName());
            sb.append(";");
            sb.append(String.valueOf(QAFDataProvider.params.KEY.name()) + "=" + dp.key());
            sb.append(";");
            sb.append(String.valueOf(QAFDataProvider.params.HASHEADERROW.name()) + "=" + dp.hasHeaderRow());
            sb.append(";");
            sb.append(String.valueOf(QAFDataProvider.params.SQLQUERY.name()) + "=" + dp.sqlQuery());
            props.setProperty(key, sb.toString());
            map.put(QAFDataProvider.params.DATAFILE.name(), dp.dataFile());
            map.put(QAFDataProvider.params.KEY.name(), dp.key());
            map.put(QAFDataProvider.params.SQLQUERY.name(), dp.sqlQuery());
            return map;
        }
        return null;
    }
}

