/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.pro;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.TestNGScenario;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;

public class QAFMethodSelector
implements IMethodSelector {
    private static final long serialVersionUID = -681517529788899839L;

    public boolean includeMethod(IMethodSelectorContext context, ITestNGMethod method, boolean isTestMethod) {
        boolean include = this.applyMetafilter(method);
        if (!include) {
            context.setStopped(true);
        }
        return include;
    }

    private boolean applyMetafilter(ITestNGMethod imethod) {
        String includeStr = MetaDataScanner.getParameter(imethod, "include");
        String excludeStr = MetaDataScanner.getParameter(imethod, "exclude");
        if (StringUtil.isBlank((String)includeStr) && StringUtil.isBlank((String)excludeStr)) {
            return true;
        }
        Gson gson = new GsonBuilder().create();
        Map includeMeta = (Map)gson.fromJson(includeStr, Map.class);
        Map excludeMeta = (Map)gson.fromJson(excludeStr, Map.class);
        Map<Object, Object> scenarioMetadata = new HashMap();
        if (imethod instanceof TestNGScenario) {
            TestNGScenario method = (TestNGScenario)imethod;
            scenarioMetadata = method.getMetaData();
        } else if (Scenario.class.isAssignableFrom(imethod.getRealClass())) {
            Scenario method = (Scenario)imethod.getInstance();
            scenarioMetadata = method.getMetadata();
        } else {
            scenarioMetadata = MetaDataScanner.getMetadata(imethod.getConstructorOrMethod().getMethod(), false);
        }
        return QAFMethodSelector.includeMethod(scenarioMetadata, includeMeta, excludeMeta);
    }

    public static boolean includeMethod(Map<String, Object> scenarioMetadata, Map<String, Object> includeMeta, Map<String, Object> excludeMeta) {
        boolean bexclude;
        boolean binclude = includeMeta == null || includeMeta.isEmpty() || QAFMethodSelector.hasMetaValue(includeMeta, scenarioMetadata, true);
        boolean bl = bexclude = excludeMeta != null && !excludeMeta.isEmpty() && QAFMethodSelector.hasMetaValue(excludeMeta, scenarioMetadata, false);
        return binclude && !bexclude;
    }

    public void setTestMethods(List<ITestNGMethod> testMethods) {
    }

    private static boolean hasMetaValue(Map<String, Object> metaFilter, Map<String, Object> metadata, boolean isInclude) {
        Set<String> filterKeys = metaFilter.keySet();
        for (String metaKey : filterKeys) {
            Object metaVal = metadata.get(metaKey);
            Set<Object> scMetaValues = QAFMethodSelector.getMetaValues(metaVal);
            Object metaValuesObjForKey = metaFilter.get(metaKey);
            Set<Object> metaValuesForKey = QAFMethodSelector.getMetaValues(metaValuesObjForKey);
            if (metaValuesForKey.isEmpty()) continue;
            scMetaValues.retainAll(metaValuesForKey);
            if (!(isInclude ? scMetaValues.isEmpty() : !scMetaValues.isEmpty())) continue;
            return !isInclude;
        }
        return isInclude;
    }

    private static Set<Object> getMetaValues(Object metaVal) {
        if (metaVal == null) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(metaVal.getClass())) {
            return new HashSet<Object>((List)metaVal);
        }
        if (metaVal.getClass().isArray()) {
            Object[] vals = (Object[])metaVal;
            return new HashSet<Object>(Arrays.asList(vals));
        }
        return new HashSet<Object>(Arrays.asList(metaVal));
    }
}

