/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.qmetry.qaf.automation.ui.AbstractTestPage;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.api.PageLocator;
import com.qmetry.qaf.automation.ui.api.WebDriverTestPage;
import com.qmetry.qaf.automation.ui.webdriver.ComponentFactory;
import com.qmetry.qaf.automation.ui.webdriver.ElementFactory;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebComponent;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.util.ClassUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Qualifier;
import org.openqa.selenium.SearchContext;

public abstract class WebDriverBaseTestPage<P extends WebDriverTestPage>
extends AbstractTestPage<P, QAFExtendedWebDriver>
implements WebDriverTestPage {
    protected List<QAFWebElement> pageIdentifiers = this.getPageIdentifiers();

    public WebDriverBaseTestPage() {
        this(null);
    }

    public WebDriverBaseTestPage(P parent) {
        super(new WebDriverTestBase(), parent);
    }

    @Override
    public String getText() {
        return ElementFactory.$("tagName=body").getText();
    }

    public WebDriverTestBase getTestBase() {
        return (WebDriverTestBase)super.getTestBase();
    }

    @Override
    public boolean isPageActive(PageLocator loc, Object ... args) {
        for (QAFWebElement element : this.pageIdentifiers) {
            if (element.isPresent()) continue;
            return false;
        }
        return this.pageIdentifiers.size() > 0;
    }

    @Override
    public void waitForPageToLoad() {
        ((QAFExtendedWebDriver)this.driver).waitForAllElementPresent(this.pageIdentifiers.toArray(new QAFWebElement[0]));
    }

    public <T extends QAFWebComponent> List<T> findElements(String loc, Class<T> t) {
        List<QAFWebElement> eles = ((QAFExtendedWebDriver)this.driver).findElements(loc);
        ArrayList<QAFWebComponent> objs = new ArrayList<QAFWebComponent>();
        for (QAFWebElement ele : eles) {
            QAFWebComponent obj = (QAFWebComponent)ComponentFactory.getObject(t.getClass(), loc, this, (SearchContext)this.driver);
            obj.setId(((QAFExtendedWebElement)ele).getId());
            try {
                Field cacheable = obj.getClass().getDeclaredField("cacheable");
                cacheable.setAccessible(true);
                cacheable.set(obj, true);
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            objs.add(obj);
        }
        return objs;
    }

    public <T extends QAFWebComponent> T findElement(String loc, Class<T> t) {
        QAFWebComponent obj = (QAFWebComponent)ComponentFactory.getObject(t.getClass(), loc, this, (SearchContext)this.driver);
        obj.getId();
        return (T)obj;
    }

    @Override
    public void waitForAjaxToComplete() {
        this.getTestBase().getDriver().waitForAjax(new long[0]);
    }

    public void waitForTextPresent(String text) {
        ElementFactory.$("partialLinkText=text").waitForPresent(new long[0]);
    }

    private List<QAFWebElement> getPageIdentifiers() {
        Field[] flds;
        ArrayList<QAFWebElement> identifiers = new ArrayList<QAFWebElement>();
        Field[] fieldArray = flds = ClassUtil.getAllFields(this.getClass(), WebDriverBaseTestPage.class);
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            if (fld.isAnnotationPresent(Qualifier.class) && QAFWebElement.class.isAssignableFrom(fld.getType())) {
                try {
                    fld.setAccessible(true);
                    identifiers.add((QAFWebElement)fld.get(this));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return identifiers;
    }
}

