/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.util;

import com.google.common.collect.ImmutableList;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;

public class QAFWebDriverWait
extends FluentWait<QAFExtendedWebDriver> {
    public QAFWebDriverWait(QAFExtendedWebDriver driver, long timeOutInMiliSeconds) {
        this(driver, (Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeOutInMiliSeconds, QAFWebDriverWait.getDefaultInterval());
    }

    public QAFWebDriverWait(QAFExtendedWebDriver driver, long timeOutInMiliSeconds, long sleepInMillis) {
        this(driver, (Clock)new SystemClock(), Sleeper.SYSTEM_SLEEPER, timeOutInMiliSeconds, sleepInMillis);
    }

    public QAFWebDriverWait(long ... timeout) {
        this(new WebDriverTestBase().getDriver(), timeout);
    }

    public QAFWebDriverWait(QAFExtendedWebDriver driver, long ... timeout) {
        this(driver, QAFWebDriverWait.getTimeout(timeout), QAFWebDriverWait.getInterval(timeout));
    }

    protected QAFWebDriverWait(QAFExtendedWebDriver driver, Clock clock, Sleeper sleeper, long timeOutInMiliSeconds, long sleepTimeOut) {
        super((Object)driver, clock, sleeper);
        this.withTimeout(timeOutInMiliSeconds, TimeUnit.MILLISECONDS);
        this.pollingEvery(sleepTimeOut, TimeUnit.MILLISECONDS);
        this.ignoring(StaleElementReferenceException.class);
    }

    public QAFWebDriverWait ignore(Class<? extends RuntimeException> ... exceptionType) {
        return (QAFWebDriverWait)this.ignoreAll((Collection)ImmutableList.copyOf((Object[])exceptionType));
    }

    private static long getTimeout(long ... timeout) {
        if (timeout == null || timeout.length < 1 || timeout[0] <= 0L) {
            return QAFWebDriverWait.getDefaultTimeout();
        }
        return timeout[0];
    }

    private static long getInterval(long ... timeout) {
        if (timeout == null || timeout.length < 2 || timeout[1] <= 0L) {
            return QAFWebDriverWait.getDefaultInterval();
        }
        return timeout[1];
    }

    public static long getDefaultTimeout() {
        return ConfigurationManager.getBundle().getLong("selenium.explicit.wait.timeout", ApplicationProperties.SELENIUM_WAIT_TIMEOUT.getIntVal(5000));
    }

    public static long getDefaultInterval() {
        return ConfigurationManager.getBundle().getLong("selenium.explicit.wait.interval", ConfigurationManager.getBundle().getLong("selenium.wait.interval", 1000L));
    }
}

