/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.google.common.base.Function;
import com.qmetry.qaf.automation.ui.util.ExpectedCondition;
import com.qmetry.qaf.automation.ui.util.QAFWebDriverWait;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.LocatorUtil;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONException;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;

public class ElementList<T extends QAFWebElement>
extends ArrayList<T> {
    private static final long serialVersionUID = -703633828271567272L;
    private SearchContext context;
    private String description;
    private boolean cacheable = false;
    private By by;

    public ElementList(SearchContext context, String loc) {
        this.context = context;
        this.initLoc(loc);
    }

    @Override
    public T get(int index) {
        if (!this.cacheable) {
            this.clear();
        }
        if (this.isEmpty()) {
            this.waitForIndex(index);
        }
        return (T)((QAFWebElement)super.get(index));
    }

    @Override
    public boolean contains(Object o) {
        this.waitForIndex(0);
        return super.contains(o);
    }

    private void initLoc(String locator) {
        this.by = LocatorUtil.getBy(locator);
        if (JSONUtil.isValidJsonString(locator)) {
            try {
                Map<String, Object> map = JSONUtil.toMap(locator);
                this.description = map.containsKey("desc") ? (String)map.get("desc") : (map.containsKey("description") ? (String)map.get("description") : this.by.toString());
                this.cacheable = map.containsKey("cacheable") ? (Boolean)map.get("cacheable") : false;
            }
            catch (JSONException jSONException) {}
        }
    }

    public void waitForEmpty() {
        this.waitForIndex(-1);
    }

    public void waitForIndex(final int index) {
        new QAFWebDriverWait(new long[0]).withMessage(String.format("Wait timeout for list of %s with size %d", this.description, index + 1)).until((Function)new ExpectedCondition<QAFExtendedWebDriver, Boolean>(){

            public Boolean apply(QAFExtendedWebDriver driver) {
                try {
                    ElementList.this.clear();
                    ElementList.this.addAll(ElementList.this.context.findElements(ElementList.this.by));
                    if (ElementList.this.size() > index) {
                        return true;
                    }
                    return false;
                }
                catch (WebDriverException webDriverException) {
                    return false;
                }
            }
        });
    }
}

