/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;

public class StringUtil
extends StringUtils {
    public static final char NULL = '\u0000';

    public static String getTitleCase(String str) {
        return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
    }

    public static String toCamelCaseIdentifier(String formStr) {
        StringBuffer res = new StringBuffer();
        formStr = formStr.replaceAll("\\{(\\d)*(\\s)*\\}", "");
        String[] strArr = formStr.split("\\W");
        int i = 0;
        String[] stringArray = strArr;
        int n = strArr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.trim().length() > 0) {
                char[] stringArray2 = str.trim().toCharArray();
                stringArray2[0] = i == 0 ? Character.toLowerCase(stringArray2[0]) : Character.toUpperCase(stringArray2[0]);
                str = new String(stringArray2);
                res.append(str);
            }
            ++i;
            ++n2;
        }
        return res.toString().trim();
    }

    public static String toTitleCaseIdentifier(String formStr) {
        return StringUtil.getTitleCase(StringUtil.toCamelCaseIdentifier(formStr));
    }

    public static String getRandomString(String format) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < format.length()) {
            char c = format.charAt(i);
            char a = Character.isDigit(c) ? RandomStringUtils.randomNumeric((int)1).charAt(0) : (Character.isLetter(c) ? RandomStringUtils.randomAlphabetic((int)c).charAt(0) : c);
            sb.append(a);
            ++i;
        }
        return sb.toString();
    }

    public boolean containsNumbers(String str) {
        return str.matches(".*\\d.*");
    }

    public static String getFormatedDate(String dateString, String formatFrom, String formatTo) {
        Date d;
        SimpleDateFormat aformat = new SimpleDateFormat(formatFrom);
        SimpleDateFormat eformat = new SimpleDateFormat(formatTo);
        try {
            d = aformat.parse(dateString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
        return eformat.format(d);
    }

    public static String createRandomString(String prefix) {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return String.valueOf(prefix) + "_" + token;
    }

    public static String createRandomString() {
        Random r = new Random();
        String token = Long.toString(Math.abs(r.nextLong()), 36);
        return token;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isXpath(String val) {
        return !StringUtil.isNullOrEmpty(val) && (val.startsWith("//") || val.toLowerCase().startsWith("xpath"));
    }

    public static String getWellFormedXPATH(String val) {
        String fstr = val;
        if (!val.toLowerCase().startsWith("xpath")) {
            fstr = "xpath=(" + val + ")[1]";
        }
        if (!val.endsWith("]")) {
            fstr = String.valueOf(val) + "[1]";
        }
        return fstr;
    }

    public static String extractParamValueFromUrl(String urlString, String paramName) {
        String[] params2;
        String retVal = "";
        String[] stringArray = params2 = urlString.split("\\?|&");
        int n = params2.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.startsWith(String.valueOf(paramName.trim()) + "=")) {
                retVal = param.substring(paramName.trim().length() + 1);
                break;
            }
            ++n2;
        }
        return retVal;
    }

    public static boolean seleniumEquals(String expectedPattern, String actual) {
        if (expectedPattern == null || actual == null) {
            return expectedPattern == actual;
        }
        if (actual.startsWith("regexp:") || actual.startsWith("regex:") || actual.startsWith("regexpi:") || actual.startsWith("regexi:") || actual.startsWith("start:") || actual.startsWith("end:") || actual.startsWith("in:")) {
            String tmp = actual;
            actual = expectedPattern;
            expectedPattern = tmp;
        }
        if (expectedPattern.startsWith("start:")) {
            return actual.startsWith(expectedPattern.replaceFirst("start:", ""));
        }
        if (expectedPattern.startsWith("end:")) {
            return actual.endsWith(expectedPattern.replaceFirst("end:", ""));
        }
        if (expectedPattern.startsWith("in:")) {
            return actual.contains(expectedPattern.replaceFirst("in:", ""));
        }
        Boolean b = StringUtil.handleRegex("regexp:", expectedPattern, actual, 0);
        if (b != null) {
            return b;
        }
        b = StringUtil.handleRegex("regex:", expectedPattern, actual, 0);
        if (b != null) {
            return b;
        }
        b = StringUtil.handleRegex("regexpi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        b = StringUtil.handleRegex("regexi:", expectedPattern, actual, 2);
        if (b != null) {
            return b;
        }
        if (expectedPattern.startsWith("exact:")) {
            String expectedExact = expectedPattern.replaceFirst("exact:", "");
            if (!expectedExact.equals(actual)) {
                System.out.println("expected " + actual + " to match " + expectedPattern);
                return false;
            }
            return true;
        }
        String expectedGlob = expectedPattern.replaceFirst("glob:", "");
        expectedGlob = expectedGlob.replaceAll("([\\]\\[\\\\{\\}$\\(\\)\\|\\^\\+.])", "\\\\$1");
        expectedGlob = expectedGlob.replaceAll("\\*", ".*");
        if (!Pattern.compile(expectedGlob = expectedGlob.replaceAll("\\?", "."), 32).matcher(actual).matches()) {
            System.out.println("expected \"" + actual + "\" to match glob \"" + expectedPattern + "\" (had transformed the glob into regexp \"" + expectedGlob + "\"");
            return false;
        }
        return true;
    }

    public static Boolean handleRegex(String prefix, String expectedPattern, String actual, int flags) {
        if (expectedPattern.startsWith(prefix)) {
            String expectedRegEx = expectedPattern.replaceFirst(prefix, "");
            Pattern p = Pattern.compile(expectedRegEx, flags);
            if (!p.matcher(actual).matches()) {
                System.out.println("expected " + actual + " to match regexp " + expectedPattern);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return null;
    }

    public static Map<String, String> toMap(String csvKeyVal, boolean ensureKeyUppercase, char ... ch) {
        String[] params2 = StringUtil.parseCSV(csvKeyVal, ch);
        return StringUtil.toMap(params2, ensureKeyUppercase);
    }

    public static Map<String, String> toMap(String[] csvKeyVal, boolean ensureKeyUppercase) {
        WeakHashMap<String, String> map = new WeakHashMap<String, String>();
        if (csvKeyVal == null) {
            return map;
        }
        String[] stringArray = csvKeyVal;
        int n = csvKeyVal.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (StringUtil.isNotBlank((String)param)) {
                String[] kv = param.split("=");
                map.put(ensureKeyUppercase ? kv[0].toUpperCase() : kv[0], kv.length > 1 ? kv[1] : "");
            }
            ++n2;
        }
        return map;
    }

    public static String[] parseCSV(String data, char ... ch) {
        ArrayList<String> values = new ArrayList<String>();
        char seperator = ch == null || ch.length < 1 || ch[0] == '\u0000' ? (char)',' : ch[0];
        char escapeChar = ch == null || ch.length < 2 || ch[1] == '\u0000' ? (char)'\\' : ch[1];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            if (c == seperator) {
                values.add(sb.toString());
                sb = new StringBuilder();
            } else {
                if (c == escapeChar) {
                    c = data.charAt(++i);
                }
                sb.append(c);
            }
            ++i;
        }
        values.add(sb.toString());
        return values.toArray(new String[values.size()]);
    }

    public static Double[] extractNums(String s) {
        ArrayList<Double> lst = new ArrayList<Double>();
        Pattern p = Pattern.compile("-?\\d+.?\\d+");
        Matcher m = p.matcher(s);
        while (m.find()) {
            lst.add(Double.parseDouble(m.group()));
        }
        return lst.toArray(new Double[lst.size()]);
    }

    public static String commaSeparate(Collection<String> strings) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            buffer.append(string);
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public static boolean booleanValueOf(String sVal, Boolean defaultValue) {
        if (StringUtil.isBlank((String)sVal)) {
            return defaultValue == null ? false : defaultValue;
        }
        boolean val = StringUtil.isNumeric((String)(sVal = sVal.trim())) ? Integer.parseInt(sVal) != 0 : Boolean.parseBoolean(sVal) || sVal.equalsIgnoreCase("T") || sVal.equalsIgnoreCase("Y") || sVal.equalsIgnoreCase("YES") || sVal.equalsIgnoreCase("ON");
        return val;
    }

    public static boolean booleanValueOf(String sVal) {
        return StringUtil.booleanValueOf(sVal, false);
    }

    public static String toStringWithSufix(int number) {
        if (number % 100 > 10 && number % 100 < 20) {
            return String.valueOf(number) + "th";
        }
        switch (number % 10) {
            case 1: {
                return String.valueOf(number) + "st";
            }
            case 2: {
                return String.valueOf(number) + "nd";
            }
            case 3: {
                return String.valueOf(number) + "rd";
            }
        }
        return String.valueOf(number) + "th";
    }
}

