/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Graph;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodInheritance;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodHelper {
    private static final Map<ITestNGMethod[], Graph<ITestNGMethod>> GRAPH_CACHE = new ConcurrentHashMap<ITestNGMethod[], Graph<ITestNGMethod>>();
    private static final Map<Method, String> CANONICAL_NAME_CACHE = new ConcurrentHashMap<Method, String>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods) {
        List includedMethods = Lists.newArrayList();
        MethodGroupsHelper.collectMethodsByGroup((ITestNGMethod[])methods.toArray(new ITestNGMethod[methods.size()]), (boolean)forTests, (List)includedMethods, outExcludedMethods, (RunInfo)runInfo, (IAnnotationFinder)finder, (boolean)unique);
        return MethodHelper.sortMethods(forTests, includedMethods, finder).toArray(new ITestNGMethod[0]);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod m, ITestNGMethod[] methods) {
        String canonicalMethodName = MethodHelper.calculateMethodCanonicalName(m);
        List vResult = Lists.newArrayList();
        String regexp = null;
        String[] stringArray = m.getMethodsDependedUpon();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fullyQualifiedRegexp = stringArray[n2];
            boolean foundAtLeastAMethod = false;
            if (fullyQualifiedRegexp != null) {
                regexp = fullyQualifiedRegexp.replace("$", "\\$");
                boolean usePackage = regexp.indexOf(46) != -1;
                Pattern pattern = Pattern.compile(regexp);
                ITestNGMethod[] iTestNGMethodArray = methods;
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITestNGMethod method = iTestNGMethodArray[n4];
                    ConstructorOrMethod thisMethod = method.getConstructorOrMethod();
                    String thisMethodName = thisMethod.getName();
                    String methodName = usePackage ? MethodHelper.calculateMethodCanonicalName(method) : thisMethodName;
                    Pair cacheKey = Pair.create((Object)regexp, (Object)methodName);
                    Boolean match = MATCH_CACHE.get(cacheKey);
                    if (match == null) {
                        match = pattern.matcher(methodName).matches();
                        MATCH_CACHE.put((Pair<String, String>)cacheKey, match);
                    }
                    if (match.booleanValue()) {
                        vResult.add(method);
                        foundAtLeastAMethod = true;
                    }
                    ++n4;
                }
            }
            if (!(foundAtLeastAMethod || m.ignoreMissingDependencies() || m.isAlwaysRun())) {
                Method maybeReferringTo = MethodHelper.findMethodByName(m, regexp);
                if (maybeReferringTo != null) {
                    throw new TestNGException(String.valueOf(canonicalMethodName) + "() is depending on method " + maybeReferringTo + ", which is not annotated with @Test or not included.");
                }
                throw new TestNGException(String.valueOf(canonicalMethodName) + "() depends on nonexistent method " + regexp);
            }
            ++n2;
        }
        return vResult.toArray(new ITestNGMethod[vResult.size()]);
    }

    private static Method findMethodByName(ITestNGMethod testngMethod, String regExp) {
        String methodName;
        String className;
        if (regExp == null) {
            return null;
        }
        int lastDot = regExp.lastIndexOf(46);
        if (lastDot == -1) {
            className = testngMethod.getConstructorOrMethod().getDeclaringClass().getCanonicalName();
            methodName = regExp;
        } else {
            methodName = regExp.substring(lastDot + 1);
            className = regExp.substring(0, lastDot);
        }
        try {
            Class<?> c = Class.forName(className);
            Method[] methodArray = c.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (methodName.equals(m.getName())) {
                    return m;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Utils.log((String)"MethodHelper", (int)3, (String)"Caught exception while searching for methods using regex");
        }
        return null;
    }

    protected static boolean isEnabled(Class<?> objectClass, IAnnotationFinder finder) {
        ITestAnnotation testClassAnnotation = AnnotationHelper.findTest((IAnnotationFinder)finder, objectClass);
        return MethodHelper.isEnabled((ITestOrConfiguration)testClassAnnotation);
    }

    protected static boolean isEnabled(Method m, IAnnotationFinder finder) {
        ITestAnnotation annotation = AnnotationHelper.findTest((IAnnotationFinder)finder, (Method)m);
        if (annotation == null) {
            annotation = AnnotationHelper.findTest((IAnnotationFinder)finder, m.getDeclaringClass());
        }
        return MethodHelper.isEnabled((ITestOrConfiguration)annotation);
    }

    protected static boolean isEnabled(ITestOrConfiguration test) {
        return test == null || test.getEnabled();
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> methods) {
        Set resultSet = Sets.newHashSet();
        for (List<ITestNGMethod> l : methods) {
            resultSet.addAll(l);
        }
        return Lists.newArrayList((Collection)resultSet);
    }

    private static Graph<ITestNGMethod> topologicalSort(ITestNGMethod[] methods, List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList) {
        Graph result = new Graph();
        if (methods.length == 0) {
            return result;
        }
        ITestNGMethod[] iTestNGMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            ITestNGMethod m = iTestNGMethodArray[n2];
            result.addNode((Object)m);
            List predecessors = Lists.newArrayList();
            String[] methodsDependedUpon = m.getMethodsDependedUpon();
            String[] groupsDependedUpon = m.getGroupsDependedUpon();
            if (methodsDependedUpon.length > 0) {
                ITestNGMethod[] methodsNamed;
                ITestNGMethod[] iTestNGMethodArray2 = methodsNamed = MethodHelper.findDependedUponMethods(m, methods);
                int n4 = methodsNamed.length;
                n3 = 0;
                while (n3 < n4) {
                    ITestNGMethod pred = iTestNGMethodArray2[n3];
                    predecessors.add(pred);
                    ++n3;
                }
            }
            if (groupsDependedUpon.length > 0) {
                String[] stringArray = groupsDependedUpon;
                n3 = groupsDependedUpon.length;
                int n5 = 0;
                while (n5 < n3) {
                    ITestNGMethod[] methodsThatBelongToGroup;
                    String group = stringArray[n5];
                    ITestNGMethod[] iTestNGMethodArray3 = methodsThatBelongToGroup = MethodGroupsHelper.findMethodsThatBelongToGroup((ITestNGMethod)m, (ITestNGMethod[])methods, (String)group);
                    int n6 = methodsThatBelongToGroup.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        ITestNGMethod pred = iTestNGMethodArray3[n7];
                        predecessors.add(pred);
                        ++n7;
                    }
                    ++n5;
                }
            }
            for (ITestNGMethod predecessor : predecessors) {
                result.addPredecessor((Object)m, (Object)predecessor);
            }
            ++n2;
        }
        result.topologicalSort();
        sequentialList.addAll(result.getStrictlySortedNodes());
        parallelList.addAll(result.getIndependentNodes());
        return result;
    }

    protected static String calculateMethodCanonicalName(ITestNGMethod m) {
        return MethodHelper.calculateMethodCanonicalName(m.getConstructorOrMethod().getMethod());
    }

    private static String calculateMethodCanonicalName(Method m) {
        String result = CANONICAL_NAME_CACHE.get(m);
        if (result != null) {
            return result;
        }
        String packageName = String.valueOf(m.getDeclaringClass().getName()) + "." + m.getName();
        Class<?> cls = m.getDeclaringClass();
        while (cls != Object.class) {
            try {
                if (cls.getDeclaredMethod(m.getName(), m.getParameterTypes()) != null) {
                    packageName = cls.getName();
                    break;
                }
            }
            catch (Exception exception) {}
            cls = cls.getSuperclass();
        }
        result = String.valueOf(packageName) + "." + m.getName();
        CANONICAL_NAME_CACHE.put(m, result);
        return result;
    }

    private static List<ITestNGMethod> sortMethods(boolean forTests, List<ITestNGMethod> allMethods, IAnnotationFinder finder) {
        List sl = Lists.newArrayList();
        List pl = Lists.newArrayList();
        ITestNGMethod[] allMethodsArray = allMethods.toArray(new ITestNGMethod[allMethods.size()]);
        if (!forTests && allMethodsArray.length > 0) {
            ITestNGMethod m = allMethodsArray[0];
            boolean before = m.isBeforeClassConfiguration() || m.isBeforeMethodConfiguration() || m.isBeforeSuiteConfiguration() || m.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance((ITestNGMethod[])allMethodsArray, (boolean)before);
        }
        MethodHelper.topologicalSort(allMethodsArray, sl, pl);
        List result = Lists.newArrayList();
        result.addAll(sl);
        result.addAll(pl);
        return result;
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod method, ITestNGMethod[] methods) {
        Graph<ITestNGMethod> g = GRAPH_CACHE.get(methods);
        if (g == null) {
            List parallelList = Lists.newArrayList();
            List sequentialList = Lists.newArrayList();
            g = MethodHelper.topologicalSort(methods, sequentialList, parallelList);
            GRAPH_CACHE.put(methods, g);
        }
        List result = g.findPredecessors((Object)method);
        return result;
    }

    protected static String calculateMethodCanonicalName(Class<?> methodClass, String methodName) {
        Set methods = ClassHelper.getAvailableMethods(methodClass);
        Method result = null;
        for (Method m : methods) {
            if (!methodName.equals(m.getName())) continue;
            result = m;
            break;
        }
        return result != null ? MethodHelper.calculateMethodCanonicalName(result) : null;
    }

    protected static long calculateTimeOut(ITestNGMethod tm) {
        long result = tm.getTimeOut() > 0L ? tm.getTimeOut() : tm.getInvocationTimeOut();
        return result;
    }
}

