/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.data;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.data.DataBean;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.testng.RetryAnalyzer;
import com.qmetry.qaf.automation.testng.pro.DataProviderUtil;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.DatabaseUtil;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.RandomStringGenerator;
import com.qmetry.qaf.automation.util.Randomizer;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.SkipException;

public abstract class BaseDataBean
implements DataBean {
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public String toCSV() {
        Field[] flds;
        StringBuffer sb = new StringBuffer();
        Field[] fieldArray = flds = this.getClass().getDeclaredFields();
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            try {
                fld.setAccessible(true);
                if (fld.getDeclaringClass().equals(this.getClass()) && fld.get(this) != null) {
                    sb.append(fld.get(this).toString());
                }
                sb.append(",");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return sb.toString();
    }

    public void fillData(Object obj) {
        if (obj instanceof Map) {
            this.fillData((Map)obj);
            return;
        }
        if (obj instanceof String) {
            String str = String.valueOf(obj);
            if (JSONUtil.isValidJsonString(str)) {
                this.fillFromJsonString(str);
                return;
            }
            if (str.startsWith("select")) {
                this.fillDataFromDB(str);
                return;
            }
            if (!ConfigurationManager.getBundle().subset(str).isEmpty()) {
                this.fillFromConfig(str);
                return;
            }
        }
        throw new SkipException("Unable to fill data with unknown object. It must be either Map or String: valid json / property key / sql statement." + obj);
    }

    protected Field[] getFields() {
        return ClassUtil.getAllFields(this.getClass(), BaseDataBean.class);
    }

    public void fillFromJsonString(String jsonstr) {
        try {
            String[] keys;
            JSONObject jsonObject = new JSONObject(jsonstr);
            String[] stringArray = keys = JSONObject.getNames((JSONObject)jsonObject);
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.fillData(key, jsonObject.optString(key));
                ++n2;
            }
        }
        catch (JSONException e) {
            this.logger.error((Object)e);
        }
    }

    public void fillFromConfig(String datakey) {
        List<Object[]> set = DataProviderUtil.getDataSetAsMap(datakey);
        if (set.isEmpty()) {
            return;
        }
        int index = 0;
        if (set.size() > 1) {
            if (ApplicationProperties.BEAN_POPULATE_RANDOM.getBoolenVal(false)) {
                index = RandomUtils.nextInt((int)set.size());
            } else {
                int cindex = ConfigurationManager.getBundle().getInt(RetryAnalyzer.RETRY_INVOCATION_COUNT, 0);
                index = cindex % set.size();
            }
        }
        this.fillData(set.get(index)[0]);
    }

    public String toString() {
        Field[] flds;
        StringBuilder sb = new StringBuilder("[");
        Field[] fieldArray = flds = this.getFields();
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            try {
                fld.setAccessible(true);
                if (fld.get(this) != null) {
                    sb.append(String.valueOf(fld.getName()) + " : " + fld.get(this).toString());
                    sb.append(",");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        if (sb.length() > 0) {
            sb.append("]");
        }
        return sb.toString();
    }

    public String toCSV(String csvNames) {
        if (csvNames == null || csvNames.equalsIgnoreCase("all") || csvNames.equalsIgnoreCase("*")) {
            return this.toCSV();
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer fldNames = new StringTokenizer(csvNames, ",");
        while (fldNames.hasMoreTokens()) {
            try {
                Field fld = this.getClass().getDeclaredField(fldNames.nextToken());
                fld.setAccessible(true);
                if (fld.get(this) != null) {
                    sb.append(fld.get(this).toString());
                }
                sb.append(",");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public String getCSVLabel() {
        Field[] flds;
        StringBuffer sb = new StringBuffer();
        Field[] fieldArray = flds = this.getClass().getDeclaredFields();
        int n = flds.length;
        int n2 = 0;
        while (n2 < n) {
            Field fld = fieldArray[n2];
            try {
                if (fld.getDeclaringClass().equals(this.getClass())) {
                    sb.append(fld.getName());
                    sb.append(",");
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public void fillData(Map<String, String> map) {
        for (String key : map.keySet()) {
            this.fillData(key, String.valueOf(map.get(key)));
        }
    }

    public void fillDataFromDB(String query) {
        this.fillData((Map)DatabaseUtil.getRecordDataAsMap(query)[0][0]);
    }

    public void fillData(String fieldName, String value) {
        Field[] fields;
        Field[] fieldArray = fields = this.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field2 = fieldArray[n2];
            Field field = field2;
            if (field.getName().equalsIgnoreCase(fieldName)) {
                if (!Modifier.isFinal(field.getModifiers())) {
                    this.setField(field, value);
                }
                return;
            }
            ++n2;
        }
    }

    @Override
    public void fillRandomData() {
        Field[] fields;
        Field[] fieldArray = fields = this.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            this.logger.debug((Object)("NAME :: " + field.getName()));
            if (!Modifier.isFinal(field.getModifiers())) {
                RandomStringGenerator.RandomizerTypes type = RandomStringGenerator.RandomizerTypes.MIXED;
                int len = 10;
                long min = 0L;
                long max = 0L;
                String prefix = "";
                String suffix = "";
                String format = "";
                String[] list = new String[]{};
                Randomizer randomizer = field.getAnnotation(Randomizer.class);
                if (randomizer != null && !randomizer.skip()) {
                    type = field.getType() == Date.class ? RandomStringGenerator.RandomizerTypes.DIGITS_ONLY : randomizer.type();
                    len = randomizer.length();
                    prefix = randomizer.prefix();
                    suffix = randomizer.suffix();
                    min = randomizer.minval();
                    max = min > randomizer.maxval() ? min : randomizer.maxval();
                    format = randomizer.format();
                    list = randomizer.dataset();
                    String str = "";
                    str = list == null || list.length == 0 ? (StringUtil.isBlank((String)format) ? RandomStringUtils.random((int)len, (!type.equals((Object)RandomStringGenerator.RandomizerTypes.DIGITS_ONLY) ? 1 : 0) != 0, (!type.equals((Object)RandomStringGenerator.RandomizerTypes.LETTERS_ONLY) ? 1 : 0) != 0) : StringUtil.getRandomString(format)) : BaseDataBean.getRandomValue(list);
                    try {
                        String rStr;
                        field.setAccessible(true);
                        Method setter = null;
                        try {
                            setter = this.getClass().getMethod("set" + StringUtil.getTitleCase(field.getName()), String.class);
                        }
                        catch (Exception exception) {}
                        if (field.getType() == String.class || setter != null) {
                            if (list == null || list.length == 0) {
                                str = min == max && min == 0L ? (StringUtil.isBlank((String)format) ? RandomStringUtils.random((int)len, (!type.equals((Object)RandomStringGenerator.RandomizerTypes.DIGITS_ONLY) ? 1 : 0) != 0, (!type.equals((Object)RandomStringGenerator.RandomizerTypes.LETTERS_ONLY) ? 1 : 0) != 0) : StringUtil.getRandomString(format)) : String.valueOf((long)((int)(Math.random() * (double)(max - min + 1L))) + min);
                            }
                            rStr = String.valueOf(prefix) + str + suffix;
                            if (setter != null) {
                                setter.setAccessible(true);
                                setter.invoke((Object)this, rStr);
                            } else {
                                field.set(this, rStr);
                            }
                        } else {
                            rStr = "";
                            rStr = min == max && min == 0L ? RandomStringUtils.random((int)len, (boolean)false, (boolean)true) : String.valueOf((long)((int)(Math.random() * (double)(max - min + 1L))) + min);
                            if (field.getType() == Integer.TYPE) {
                                field.setInt(this, Integer.parseInt(rStr));
                            } else if (field.getType() == Float.TYPE) {
                                field.setFloat(this, Float.parseFloat(rStr));
                            } else if (field.getType() == Double.TYPE) {
                                field.setDouble(this, Double.parseDouble(rStr));
                            } else if (field.getType() == Long.TYPE) {
                                field.setLong(this, Long.parseLong(rStr));
                            } else if (field.getType() == Short.TYPE) {
                                field.setShort(this, Short.parseShort(rStr));
                            } else if (field.getType() == Date.class) {
                                this.logger.info((Object)("filling date " + rStr));
                                int days = Integer.parseInt(rStr);
                                field.set(this, DateUtil.getDate(days));
                            } else if (field.getType() == Boolean.TYPE) {
                                field.setBoolean(this, RandomUtils.nextBoolean());
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error((Object)("Unable to fill random data in field " + field.getName()), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        this.logger.error((Object)("Unable to Access " + field.getName()), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        this.logger.error((Object)("Unable to Access setter for " + field.getName()), (Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }

    protected void setField(Field field, String val) {
        block16: {
            try {
                field.setAccessible(true);
                if (field.getType() == String.class) {
                    field.set(this, val);
                    break block16;
                }
                Method setter = null;
                try {
                    setter = this.getClass().getMethod("set" + StringUtil.getTitleCase(field.getName()), String.class);
                }
                catch (Exception exception) {}
                if (setter != null) {
                    setter.setAccessible(true);
                    setter.invoke((Object)this, val);
                    break block16;
                }
                if (field.getType() == Integer.TYPE) {
                    field.setInt(this, Integer.parseInt(val));
                    break block16;
                }
                if (field.getType() == Float.TYPE) {
                    field.setFloat(this, Float.parseFloat(val));
                    break block16;
                }
                if (field.getType() == Double.TYPE) {
                    field.setDouble(this, Double.parseDouble(val));
                    break block16;
                }
                if (field.getType() == Long.TYPE) {
                    field.setLong(this, Long.parseLong(val));
                    break block16;
                }
                if (field.getType() == Boolean.TYPE) {
                    Boolean bval = StringUtils.isBlank((String)val) ? null : Boolean.valueOf(NumberUtils.isNumber((String)val) ? Integer.parseInt(val) != 0 : Boolean.parseBoolean(val) || val.equalsIgnoreCase("T") || val.equalsIgnoreCase("Y") || val.equalsIgnoreCase("YES"));
                    field.setBoolean(this, bval);
                    break block16;
                }
                if (field.getType() == Short.TYPE) {
                    field.setShort(this, Short.parseShort(val));
                    break block16;
                }
                if (field.getType() != Date.class) break block16;
                Date dVal = null;
                try {
                    dVal = StringUtils.isBlank((String)val) ? null : (NumberUtils.isNumber((String)val) ? DateUtil.getDate(Integer.parseInt(val)) : DateUtil.parseDate(val, "MM/dd/yyyy"));
                }
                catch (ParseException e) {
                    this.logger.error((Object)"Expected date in MM/dd/yyyy format.", (Throwable)e);
                }
                field.set(this, dVal);
            }
            catch (IllegalArgumentException e) {
                this.logger.error((Object)("Unable to fill random data in field " + field.getName()), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)("Unable to Access " + field.getName()), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.logger.error((Object)("Unable to invoke setter for " + field.getName()), (Throwable)e);
            }
        }
    }

    public static String getRandomValue(String ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        if (values.length == 1 && ConfigurationManager.getBundle().containsKey(values[0])) {
            values = ConfigurationManager.getBundle().getStringArray(values[0], values[0]);
        }
        Random rand = new Random();
        int r = rand.nextInt(values.length);
        return values[r];
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends BaseDataBean> T deepClone() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(this);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bis);
            BaseDataBean copied = (BaseDataBean)in.readObject();
            return (T)copied;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

