/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.step.StringTestStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.testng.pro.DataProviderUtil;
import com.qmetry.qaf.automation.util.CSVUtil;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.DatabaseUtil;
import com.qmetry.qaf.automation.util.ExcelUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.internal.ClassHelper;
import org.testng.internal.Configuration;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.ArrayIterator;

public class DataDrivenScenario
extends Scenario {
    private String dataProviderDesc;

    public DataDrivenScenario(String testName, Collection<TestStep> steps, String dataProviderDesc) {
        super(testName, steps);
        this.dataProviderDesc = dataProviderDesc;
    }

    public DataDrivenScenario(String testName, Collection<TestStep> steps, String dataProviderDesc, Map<String, Object> metadata) {
        super(testName, steps, metadata);
        this.dataProviderDesc = dataProviderDesc;
    }

    @Override
    @Test(enabled=false)
    public void scenario() {
    }

    @Test(dataProvider="scenariodp", groups={"scenario"})
    public void scenario(Map<String, String> testData) {
        this.beforeScanario();
        this.logger.info((Object)("Test Data" + String.format("%s", testData)));
        HashMap<String, Object> context = new HashMap<String, Object>(testData);
        context.put("${args[0]}", testData);
        context.put("args[0]", testData);
        this.execute(this.getStepsToExecute(context), context);
    }

    @Override
    protected String comuteSign() {
        return String.valueOf(this.getPackage()) + "." + this.scenarioName + "( " + Map.class.getName() + ")";
    }

    @DataProvider(name="scenariodp", parallel=true)
    public Iterator<Object[]> dp(ITestNGMethod tm, ITestContext c) {
        this.dataProviderDesc = ConfigurationManager.getBundle().getSubstitutor().replace(this.dataProviderDesc);
        Map<String, String> param = StringUtil.toMap(StringUtil.parseCSV(this.dataProviderDesc, ConfigurationManager.getBundle().getListDelimiter()), true);
        if (param.containsKey(QAFDataProvider.params.DATAPROVIDER.name())) {
            return this.invokeCustomDataProvider(tm, c, param.get(QAFDataProvider.params.DATAPROVIDER.name()), param.get(QAFDataProvider.params.DATAPROVIDERCLASS.name()));
        }
        String dataproviderName = DataProviderUtil.getDataProvider(param);
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_excel.name())) {
            return new ArrayIterator(ExcelUtil.getExcelDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.SHEETNAME.name())));
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_excel_table.name())) {
            return new ArrayIterator(ExcelUtil.getTableDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.KEY.name()), param.get(QAFDataProvider.params.SHEETNAME.name())));
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_csv.name())) {
            return CSVUtil.getCSVDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name())).iterator();
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_database.name())) {
            String query = param.get(QAFDataProvider.params.SQLQUERY.name());
            return new ArrayIterator(DatabaseUtil.getRecordDataAsMap(query));
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_property.name())) {
            List<Object[]> mapData = DataProviderUtil.getDataSetAsMap(param.get(QAFDataProvider.params.KEY.name()));
            return mapData.iterator();
        }
        if (dataproviderName.equalsIgnoreCase(QAFDataProvider.dataproviders.isfw_json.name())) {
            if (param.containsKey(QAFDataProvider.params.JSON_DATA_TABLE.name())) {
                return new ArrayIterator(JSONUtil.getJsonArrayOfMaps((String)this.getMetadata().get(QAFDataProvider.params.JSON_DATA_TABLE.name())));
            }
            return new ArrayIterator(JSONUtil.getJsonArrayOfMaps(param.get(QAFDataProvider.params.DATAFILE.name())));
        }
        throw new RuntimeException("No data provider found");
    }

    private Iterator<Object[]> invokeCustomDataProvider(ITestNGMethod tm, ITestContext c, String dp, String dpc) {
        if (StringUtil.isBlank((String)dpc)) {
            dpc = ConfigurationManager.getBundle().getString("global.dataproviderclass", ConfigurationManager.getBundle().getString("dataproviderclass"));
        }
        if (StringUtil.isNotBlank((String)dpc)) {
            Method m = this.getDataProviderMethod(dp, dpc);
            Object instanceToUse = ClassHelper.newInstanceOrNull(m.getDeclaringClass());
            return InvocatoinHelper.invokeDataProvider(instanceToUse, m, tm, c, null, new Configuration().getAnnotationFinder());
        }
        throw new AutomationError("Data-provider class not found. Please provide fully qualified class name as dataProviderClass");
    }

    private Method getDataProviderMethod(String dp, String dpc) {
        try {
            Class<?> dpClass = Class.forName(dpc);
            Set<Method> dpMethods = ClassUtil.getAllMethodsWithAnnotation(dpClass, DataProvider.class);
            for (Method m : dpMethods) {
                DataProvider dpObj = ClassUtil.getAnnotation(m, DataProvider.class);
                if (!dp.equalsIgnoreCase(dpObj.name())) continue;
                return m;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AutomationError("Data-provider class " + dpc + " not found. Please provide fully qualified class name as dataProviderClass");
        }
        throw new AutomationError("Data-provider: '" + dp + "' not found in class: '" + dpc + "'. Please provide valid data provider name as dataProvider");
    }

    private TestStep[] getStepsToExecute(Map<String, Object> context) {
        TestStep[] proxySteps = new TestStep[this.steps.size()];
        int stepIndex = 0;
        for (TestStep testStep : this.steps) {
            StringTestStep proxy = new StringTestStep(testStep.getName(), context, testStep.getActualArgs());
            proxy.setLineNumber(testStep.getLineNumber());
            proxy.setFileName(testStep.getFileName());
            proxySteps[stepIndex++] = proxy;
        }
        return proxySteps;
    }

    private static class InvocatoinHelper
    extends MethodInvocationHelper {
        private InvocatoinHelper() {
        }

        protected static Iterator<Object[]> invokeDataProvider(Object instance, Method dataProvider, ITestNGMethod method, ITestContext testContext, Object fedInstance, IAnnotationFinder annotationFinder) {
            return MethodInvocationHelper.invokeDataProvider((Object)instance, (Method)dataProvider, (ITestNGMethod)method, (ITestContext)testContext, (Object)fedInstance, (IAnnotationFinder)annotationFinder);
        }
    }
}

