/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client.gherkin;

import com.google.gson.Gson;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.step.client.AbstractScenarioFileParser;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.text.BehaviorScanner;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GherkinFileParser
extends AbstractScenarioFileParser {
    private static final Log logger = LogFactory.getLog(BehaviorScanner.class);
    private static final String TAG = "@";
    private static final String COMMENT_CHARS = "#!|";
    public static final String SCENARIO_OUTELINE = "Scenario Outline";
    public static final String EXAMPLES = "EXAMPLES";
    public static final String FEATURE = "Feature";
    public static final String BACKGROUND = "Background";

    @Override
    protected void processStatements(Object[][] statements, String referece, List<Scenario> scenarios) {
        int statementIndex = 0;
        while (statementIndex < statements.length) {
            String type = ((String)statements[statementIndex][0]).trim();
            if (StringUtil.isBlank((String)type) || !type.equalsIgnoreCase(FEATURE) && !type.equalsIgnoreCase("SCENARIO") && !type.equalsIgnoreCase(EXAMPLES)) {
                String nextSteptype = "";
                while (!((nextSteptype = statements.length > ++statementIndex + 2 ? ((String)statements[statementIndex][0]).trim() : "END").equalsIgnoreCase(EXAMPLES) || nextSteptype.equalsIgnoreCase("SCENARIO") || nextSteptype.equalsIgnoreCase("END"))) {
                }
            }
            if (type.equalsIgnoreCase("STEP-DEF")) {
                statementIndex = this.parseStepDef(statements, statementIndex, referece);
            } else if (type.equalsIgnoreCase("SCENARIO")) {
                statementIndex = this.parseScenario(statements, statementIndex, referece, scenarios);
            }
            ++statementIndex;
        }
    }

    @Override
    protected Collection<Object[]> parseFile(String strFile) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ArrayList<Object[]> background = new ArrayList<Object[]>();
        int lineNo = 0;
        boolean bglobalTags = true;
        boolean outline = false;
        boolean isBackground = false;
        ArrayList<String> globalTags = new ArrayList<String>();
        ArrayList<String> scenarioTags = new ArrayList<String>();
        ArrayList<List<Object>> examplesTable = new ArrayList<List<Object>>();
        BufferedReader br = null;
        try {
            try {
                logger.info((Object)("loading feature file: " + strFile));
                File textFile = new File(strFile);
                br = new BufferedReader(new FileReader(textFile));
                String strLine = "";
                int lastScenarioIndex = 0;
                StringBuffer currLineBuffer = new StringBuffer();
                while ((strLine = br.readLine()) != null) {
                    ++lineNo;
                    if (!"".equalsIgnoreCase(strLine.trim()) && !COMMENT_CHARS.contains("" + strLine.trim().charAt(0))) {
                        currLineBuffer.append(strLine.trim());
                        Object[] cols = new Object[]{"", "", "", lineNo};
                        String currLine = currLineBuffer.toString();
                        String type = this.getType(currLine);
                        if (type == "") {
                            cols[0] = outline ? this.convertParam(currLine) : currLine;
                        } else {
                            isBackground = false;
                            if (type.equalsIgnoreCase(TAG)) {
                                String[] tags = currLine.split(" ");
                                if (bglobalTags) {
                                    globalTags.addAll(Arrays.asList(tags));
                                } else {
                                    scenarioTags.addAll(Arrays.asList(tags));
                                }
                                currLineBuffer = new StringBuffer();
                                continue;
                            }
                            if (type.equalsIgnoreCase(BACKGROUND)) {
                                isBackground = true;
                                currLineBuffer = new StringBuffer();
                                continue;
                            }
                            System.arraycopy(currLine.split(":", 2), 0, cols, 0, 2);
                            if (type.equalsIgnoreCase(EXAMPLES)) {
                                Object[] scenario = rows.get(lastScenarioIndex);
                                scenario[0] = "SCENARIO";
                                Map metadata = (Map)new Gson().fromJson((String)scenario[2], Map.class);
                                String exampleMetadata = (String)cols[1];
                                if (StringUtil.isNotBlank((String)exampleMetadata) && exampleMetadata.trim().startsWith("{")) {
                                    metadata.putAll((Map)new Gson().fromJson(exampleMetadata, Map.class));
                                    scenario[2] = new Gson().toJson((Object)metadata);
                                    currLineBuffer = new StringBuffer();
                                    continue;
                                }
                            } else {
                                scenarioTags.addAll(globalTags);
                                String metadata = String.format("{\"groups\":%s}", new Gson().toJson(scenarioTags));
                                cols[2] = metadata;
                                scenarioTags.clear();
                                if (type.equalsIgnoreCase(FEATURE)) {
                                    bglobalTags = false;
                                    outline = false;
                                } else {
                                    outline = type.equalsIgnoreCase(SCENARIO_OUTELINE);
                                }
                            }
                        }
                        if (!examplesTable.isEmpty()) {
                            String lastStamtent = (String)rows.get(rows.size() - 1)[0];
                            int lastStatementIndex = lastStamtent.equalsIgnoreCase(EXAMPLES) ? lastScenarioIndex : rows.size() - 1;
                            this.setExamples(rows.get(lastStatementIndex), examplesTable);
                            examplesTable.clear();
                            if (lastStamtent.equalsIgnoreCase(EXAMPLES)) {
                                rows.remove(rows.size() - 1);
                            }
                        }
                        if (isBackground) {
                            background.add(cols);
                        } else {
                            boolean scenarioStarted;
                            rows.add(cols);
                            boolean bl = scenarioStarted = StringUtil.indexOfIgnoreCase((String)type, (String)"SCENARIO") == 0;
                            if (scenarioStarted) {
                                lastScenarioIndex = rows.size() - 1;
                                rows.addAll(background);
                            }
                        }
                        currLineBuffer = new StringBuffer();
                        continue;
                    }
                    if (!StringUtil.isNotBlank((String)strLine) || strLine.trim().charAt(0) != '|') continue;
                    this.addExample(strLine.trim(), examplesTable);
                }
                int lastStatementIndex = rows.size() - 1;
                String lastStamtent = (String)((Object[])rows.get(lastStatementIndex))[0];
                if (lastStamtent.equalsIgnoreCase(EXAMPLES)) {
                    rows.remove(lastStatementIndex);
                    lastStatementIndex = lastScenarioIndex;
                }
                if (!examplesTable.isEmpty()) {
                    this.setExamples((Object[])rows.get(lastStatementIndex), examplesTable);
                    examplesTable.clear();
                }
            }
            catch (Exception e) {
                String strMsg = "Exception while reading BDD file: " + strFile + "#" + lineNo;
                logger.error((Object)(String.valueOf(strMsg) + e));
                throw new AutomationError(strMsg, e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        rows.add(new Object[]{"END", "", "", lineNo + 1});
        return rows;
    }

    private void setExamples(Object[] cols, ArrayList<List<Object>> examplesTable) {
        boolean isMap = examplesTable.get(0).size() > 1;
        boolean isScenario = ((String)cols[0]).trim().equalsIgnoreCase("SCENARIO");
        ArrayList<Object> data = null;
        if (isMap || isScenario) {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList dataMapList = new ArrayList();
            for (Object entry : examplesTable.get(0)) {
                keys.add((String)entry);
            }
            int i = 1;
            while (i < examplesTable.size()) {
                HashMap<String, String> map = new HashMap<String, String>();
                int k = 0;
                while (k < keys.size()) {
                    map.put((String)keys.get(k), examplesTable.get(i).get(k).toString().trim());
                    ++k;
                }
                dataMapList.add(map);
                ++i;
            }
            data = dataMapList;
        } else {
            ArrayList<Object> res = new ArrayList<Object>();
            for (List<Object> entry : examplesTable) {
                Object o = entry.get(0);
                res.add(o);
            }
            data = res;
        }
        if (isScenario) {
            Map metadata = (Map)new Gson().fromJson((String)cols[2], Map.class);
            metadata.put(QAFDataProvider.params.JSON_DATA_TABLE.name(), new Gson().toJson(data));
            cols[2] = new Gson().toJson((Object)metadata);
        } else {
            cols[0] = cols[0] + new Gson().toJson(data);
        }
    }

    private void addExample(String line, ArrayList<List<Object>> examplesTable) {
        String[] rawData = StringUtil.parseCSV(line, '|');
        ArrayList<String> cols = new ArrayList<String>();
        int i = 1;
        while (i < rawData.length - 1) {
            cols.add(rawData[i].trim());
            ++i;
        }
        examplesTable.add(cols);
    }

    private String convertParam(String currLine) {
        return StringUtil.replace((String)StringUtil.replace((String)currLine, (String)">", (String)"}", (int)-1), (String)"<", (String)"${", (int)-1);
    }

    private String getType(String line) {
        if (StringUtil.indexOfIgnoreCase((String)line, (String)TAG) == 0) {
            return TAG;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)SCENARIO_OUTELINE) == 0) {
            return SCENARIO_OUTELINE;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)"SCENARIO") == 0) {
            return "SCENARIO";
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)EXAMPLES) == 0) {
            return EXAMPLES;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)FEATURE) == 0) {
            return FEATURE;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)BACKGROUND) == 0) {
            return BACKGROUND;
        }
        return "";
    }
}

