/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.pro;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.testng.DataProviderException;
import com.qmetry.qaf.automation.testng.dataprovider.DataProviderFactory;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.util.CSVUtil;
import com.qmetry.qaf.automation.util.DatabaseUtil;
import com.qmetry.qaf.automation.util.ExcelUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.annotations.DataProvider;

public class DataProviderUtil
extends DataProviderFactory {
    private static final Log logger = LogFactoryImpl.getLog(DataProviderUtil.class);

    @DataProvider(name="isfw_database")
    public static Object[][] getDataFromDB(Method m) {
        String query = DataProviderUtil.getParameters(m).get(QAFDataProvider.params.SQLQUERY.name());
        Class<?>[] types = m.getParameterTypes();
        if (types.length == 1 && Map.class.isAssignableFrom(types[0])) {
            return DatabaseUtil.getRecordDataAsMap(query);
        }
        return DatabaseUtil.getData(query);
    }

    @DataProvider(name="isfw_excel")
    public static Object[][] getExcelData(Method m) {
        Map<String, String> param = DataProviderUtil.getParameters(m);
        Class<?>[] types = m.getParameterTypes();
        if (types.length == 1 && Map.class.isAssignableFrom(types[0])) {
            return ExcelUtil.getExcelDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.SHEETNAME.name()));
        }
        return ExcelUtil.getExcelData(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.HASHEADERROW.name()) != null && Boolean.valueOf(param.get(QAFDataProvider.params.HASHEADERROW.name())) != false, param.get(QAFDataProvider.params.SHEETNAME.name()));
    }

    @DataProvider(name="isfw_excel_table")
    public static Object[][] getExcelTableData(Method m) {
        Map<String, String> param = DataProviderUtil.getParameters(m);
        Class<?>[] types = m.getParameterTypes();
        if (types.length == 1 && Map.class.isAssignableFrom(types[0])) {
            return ExcelUtil.getTableDataAsMap(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.KEY.name()), param.get(QAFDataProvider.params.SHEETNAME.name()));
        }
        return ExcelUtil.getTableData(param.get(QAFDataProvider.params.DATAFILE.name()), param.get(QAFDataProvider.params.KEY.name()), param.get(QAFDataProvider.params.SHEETNAME.name()));
    }

    @DataProvider(name="isfw_csv")
    public static final Object[][] getCSVData(Method method) {
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 1 && Map.class.isAssignableFrom(types[0])) {
            return (Object[][])CSVUtil.getCSVDataAsMap(DataProviderUtil.getParameters(method).get(QAFDataProvider.params.DATAFILE.name())).toArray((T[])new Object[0][]);
        }
        return (Object[][])CSVUtil.getCSVData(DataProviderUtil.getParameters(method).get(QAFDataProvider.params.DATAFILE.name())).toArray((T[])new Object[0][]);
    }

    @DataProvider(name="csvDataProvider")
    public static final Object[][] getCSVData1(Method method) {
        return DataProviderUtil.getCSVData(method);
    }

    @DataProvider(name="isfw_json")
    public static final Object[][] getJsonData(Method method) {
        Map<String, String> methodParams = DataProviderUtil.getParameters(method);
        if (methodParams.containsKey(QAFDataProvider.params.JSON_DATA_TABLE.name())) {
            return JSONUtil.getJsonArrayOfMaps(methodParams.get(QAFDataProvider.params.JSON_DATA_TABLE.name()));
        }
        return JSONUtil.getJsonArrayOfMaps(methodParams.get(QAFDataProvider.params.DATAFILE.name()));
    }

    @DataProvider(name="isfw_property")
    public static final Object[][] getDataFromProp(Method method) {
        List<Object[]> mapData = DataProviderUtil.getDataSetAsMap(DataProviderUtil.getParameters(method).get(QAFDataProvider.params.KEY.name()));
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 1 && Map.class.isAssignableFrom(types[0])) {
            return (Object[][])mapData.toArray((T[])new Object[0][]);
        }
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        Iterator<Object[]> mapDataIter = mapData.iterator();
        while (mapDataIter.hasNext()) {
            Map map = (Map)mapDataIter.next()[0];
            data.add(map.values().toArray());
        }
        return (Object[][])data.toArray((T[])new Object[0][]);
    }

    public static List<Object[]> getDataSetAsMap(String key) {
        Configuration config = ConfigurationManager.getBundle().subset(key);
        ArrayList<Object[]> dataset = new ArrayList<Object[]>();
        if (config.isEmpty()) {
            logger.error((Object)("Missing data with key [" + key + "]. "));
            throw new DataProviderException("Not test data found with key:" + key);
        }
        int size = config.getList(config.getKeys().next().toString()).size();
        int i = 0;
        while (i < size) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            Iterator iter = config.getKeys();
            while (iter.hasNext()) {
                String dataKey = String.valueOf(iter.next());
                try {
                    map.put(dataKey, config.getStringArray(dataKey)[i]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    logger.error((Object)("Missing entry for property " + dataKey + ". Provide value for each property (or blank) in each data set in data file."), (Throwable)e);
                    throw e;
                }
            }
            dataset.add(new Object[]{map});
            ++i;
        }
        return dataset;
    }
}

