/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.pro;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.integration.ResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.client.TestNGScenario;
import com.qmetry.qaf.automation.testng.RetryAnalyzer;
import com.qmetry.qaf.automation.testng.dataprovider.DataProviderFactory;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.testng.pro.DataProviderUtil;
import com.qmetry.qaf.automation.testng.pro.QAFTestNGListener;
import com.qmetry.qaf.automation.testng.report.ReporterUtil;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.IInvokedMethod;
import org.testng.IRetryAnalyzer;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.Test;
import org.testng.internal.ConstructorOrMethod;

public class QAFTestNGListener2
extends QAFTestNGListener {
    private final Log logger = LogFactoryImpl.getLog(this.getClass());

    public QAFTestNGListener2() {
        this.logger.debug((Object)"QAFTestNGListener registered!...");
    }

    @Override
    public void onStart(ISuite suite) {
        if (this.skipReporting()) {
            return;
        }
        super.onStart(suite);
        ReporterUtil.createMetaInfo(suite);
    }

    @Override
    public void onFinish(ISuite suite) {
        if (this.skipReporting()) {
            return;
        }
        super.onFinish(suite);
        this.logger.debug((Object)"onFinish: start");
        ReporterUtil.createMetaInfo(suite);
        this.logger.debug((Object)"onFinish: done");
    }

    @Override
    public void onFinish(ITestContext testContext) {
        if (this.skipReporting()) {
            return;
        }
        super.onFinish(testContext);
        ReporterUtil.updateOverview(testContext, null);
    }

    public void transform(ITestAnnotation testAnnotation, Class clazz, Constructor arg2, Method method) {
        try {
            String dp;
            if (method.getAnnotation(QAFDataProvider.class) != null && method.getParameterTypes() != null && method != null && method.getParameterTypes().length > 0 && StringUtil.isNotBlank((String)(dp = DataProviderFactory.getDataProvider(method)))) {
                testAnnotation.setDataProvider(dp);
                testAnnotation.setDataProviderClass(DataProviderUtil.class);
            }
            if (method != null) {
                String tmtURL = ConfigurationManager.getBundle().getString(String.valueOf(method.getName()) + ".testspec.url");
                if (StringUtil.isNotBlank((String)tmtURL)) {
                    String desc = String.format("%s<br/><a href=\"%s\">[test-spec]</a>", testAnnotation.getDescription(), tmtURL);
                    testAnnotation.setDescription(desc);
                }
                if (ConfigurationManager.getBundle().getBoolean("report.javadoc.link", false)) {
                    String linkRelPath = String.format("%s%s.html#%s", ConfigurationManager.getBundle().getString("javadoc.folderpath", "../../../docs/tests/"), method.getDeclaringClass().getCanonicalName().replaceAll("\\.", "/"), ClassUtil.getMethodSignture(method, false));
                    String desc = String.format("%s " + ConfigurationManager.getBundle().getString("report.javadoc.link.format", "<a href=\"%s\" target=\"_blank\">[View-doc]</a>"), testAnnotation.getDescription(), linkRelPath);
                    testAnnotation.setDescription(desc);
                }
                testAnnotation.setDescription(ConfigurationManager.getBundle().getSubstitutor().replace(testAnnotation.getDescription()));
                testAnnotation.setRetryAnalyzer(Class.forName(ApplicationProperties.RETRY_ANALYZER.getStringVal(RetryAnalyzer.class.getName())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult tr, ITestContext context) {
        super.afterInvocation(method, tr, context);
        if (method.isTestMethod() && !this.shouldRetry(tr)) {
            this.deployResult(tr, context);
        }
    }

    private boolean shouldRetry(ITestResult tr) {
        IRetryAnalyzer retryAnalyzer = tr.getMethod().getRetryAnalyzer();
        boolean shouldRetry = false;
        if (retryAnalyzer != null && retryAnalyzer instanceof RetryAnalyzer) {
            shouldRetry = ((RetryAnalyzer)retryAnalyzer).shouldRetry(tr);
        }
        return shouldRetry;
    }

    @Override
    protected void report(ITestResult tr) {
        super.report(tr);
        if (this.skipReporting()) {
            return;
        }
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        ArrayList<CheckpointResultBean> checkpoints = new ArrayList<CheckpointResultBean>(stb.getCheckPointResults());
        ArrayList<LoggingBean> logs = new ArrayList<LoggingBean>(stb.getLog());
        ITestContext testContext = (ITestContext)tr.getAttribute("context");
        ReporterUtil.createMethodResult(testContext, tr, logs, checkpoints);
        if (tr.getStatus() != 3) {
            ConfigurationManager.getBundle().clearProperty(RetryAnalyzer.RETRY_INVOCATION_COUNT);
        }
    }

    private void deployResult(ITestResult tr, ITestContext context) {
        QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
        try {
            if (tr.getMethod() instanceof TestNGScenario && (tr.getStatus() == 2 || tr.getStatus() == 1 || tr.getStatus() == 3)) {
                ConstructorOrMethod testCase = tr.getMethod().getConstructorOrMethod();
                testCase.getMethod().getAnnotation(Test.class);
                TestCaseRunResult result = tr.getStatus() == 1 ? TestCaseRunResult.PASS : (tr.getStatus() == 2 ? TestCaseRunResult.FAIL : TestCaseRunResult.SKIPPED);
                String updator = ConfigurationManager.getBundle().getString("result.updator");
                if (StringUtil.isNotBlank((String)updator)) {
                    Class<?> updatorCls = Class.forName(updator);
                    TestCaseResultUpdator updatorObj = (TestCaseResultUpdator)updatorCls.newInstance();
                    TestNGScenario scenario = (TestNGScenario)tr.getMethod();
                    HashMap<String, Object> params2 = new HashMap<String, Object>(scenario.getMetaData());
                    params2.put("duration", tr.getEndMillis() - tr.getStartMillis());
                    ResultUpdator.updateResult(result, String.valueOf(stb.getHTMLFormattedLog()) + stb.getAssertionsLog(), updatorObj, params2);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to deploy result", (Throwable)e);
        }
    }

    private boolean skipReporting() {
        return ConfigurationManager.getBundle().getBoolean("disable.qaf.testng.reporter", false) || ConfigurationManager.getBundle().getBoolean("cucumber.run.mode", false);
    }
}

