/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.data.Base64PasswordDecryptor;
import com.qmetry.qaf.automation.data.PasswordDecryptor;
import com.qmetry.qaf.automation.http.UriProxySelector;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class PropertyUtil
extends XMLConfiguration {
    private static final long serialVersionUID = -8633909707831110230L;
    Log logger = LogFactoryImpl.getLog(PropertyUtil.class);

    public PropertyUtil() {
        this.setLogger(this.logger);
        this.setDelimiterParsingDisabled(true);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object[] vals;
            Object[] objectArray;
            String skey = String.valueOf(entry.getKey());
            String sval = String.valueOf(entry.getValue());
            if (StringMatcher.like("^(sun\\.|java\\.).*").match(skey)) continue;
            if (sval != null && sval.indexOf(this.getListDelimiter()) >= 0) {
                objectArray = sval.split(String.valueOf(this.getListDelimiter()));
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = sval;
            }
            Object[] objectArray3 = vals = objectArray;
            int n = vals.length;
            int n2 = 0;
            while (n2 < n) {
                Object val = objectArray3[n2];
                super.addPropertyDirect(skey, val);
                ++n2;
            }
        }
    }

    protected void addPropertyDirect(String key, Object value) {
        if (!System.getProperties().containsKey(key)) {
            if (key.toLowerCase().startsWith("system.")) {
                super.addPropertyDirect(key, value);
                key = key.substring(key.indexOf(".") + 1);
                System.setProperty(key, (String)value);
            }
            super.addPropertyDirect(key, value);
        } else {
            String sysVal = System.getProperty(key);
            if (!sysVal.equalsIgnoreCase(value.toString())) {
                this.logger.debug((Object)("property [" + key + "] value [" + value + "] ignored! It is overriden with System provided value: [" + sysVal + "]"));
            }
        }
        if (key.toLowerCase().startsWith(ApplicationProperties.ENCRYPTED_PASSWORD_KEY_PREFIX.key)) {
            String decryptedValueKey = key.substring(ApplicationProperties.ENCRYPTED_PASSWORD_KEY_PREFIX.key.length());
            PasswordDecryptor passwordDecryptor = this.getPasswordDecryptor();
            String decryptedValue = passwordDecryptor.getDecryptedPassword((String)value);
            this.addPropertyDirect(decryptedValueKey, decryptedValue);
            this.logger.info((Object)("Added property [" + decryptedValueKey + "] with decrypted value using " + passwordDecryptor.getClass().getSimpleName()));
        } else if (ApplicationProperties.PASSWORD_DECRYPTOR_IMPL.key.equalsIgnoreCase(key)) {
            String prefix = ApplicationProperties.ENCRYPTED_PASSWORD_KEY_PREFIX.key.replace(".", "");
            Iterator encryptedValueKeys = this.getKeys(prefix);
            while (encryptedValueKeys.hasNext()) {
                PasswordDecryptor passwordDecryptor = this.getPasswordDecryptor();
                String encryptedValueKey = (String)encryptedValueKeys.next();
                String decryptedValueKey = encryptedValueKey.substring(ApplicationProperties.ENCRYPTED_PASSWORD_KEY_PREFIX.key.length());
                String decryptedValue = passwordDecryptor.getDecryptedPassword(this.getString(encryptedValueKey));
                this.addPropertyDirect(decryptedValueKey, decryptedValue);
                this.logger.info((Object)("Updated property [" + decryptedValueKey + "] with decrypted value using " + passwordDecryptor.getClass().getSimpleName()));
            }
        } else if (ApplicationProperties.HTTPS_ACCEPT_ALL_CERT.key.equalsIgnoreCase(key) && this.getBoolean(key)) {
            try {
                this.logger.info((Object)"Seeting behavior to accept all certitificate and host name");
                PropertyUtil.ignoreSSLCetrificatesAndHostVerification();
            }
            catch (KeyManagementException e) {
                this.logger.error((Object)"Unable to set behavior to ignore certificate and host name verification", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                this.logger.error((Object)"Unable to find Algorithm while setting ignore certificate and host name verification", (Throwable)e);
            }
        } else if (ApplicationProperties.PROXY_SERVER_KEY.key.equalsIgnoreCase(key) && StringUtil.isNotBlank((String)value.toString())) {
            ProxySelector.setDefault(UriProxySelector.getInstance());
        }
    }

    public PropertyUtil(PropertyUtil prop) {
        this();
        this.append((Configuration)prop);
    }

    public PropertyUtil(String ... file) {
        this();
        this.load(file);
    }

    public void addAll(Map<String, ?> props) {
        boolean b = props.keySet().removeAll(System.getProperties().keySet());
        if (b) {
            this.logger.debug((Object)"Found one or more system properties which will not modified");
        }
        this.copy((Configuration)new MapConfiguration(props));
    }

    public PropertyUtil(File ... file) {
        this();
        this.load(file);
    }

    public boolean load(String ... files) {
        boolean r = true;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            file = this.getSubstitutor().replace(file);
            this.loadFile(new File(file));
            ++n2;
        }
        return r;
    }

    public boolean load(File ... files) {
        boolean r = true;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            this.loadFile(file);
            ++n2;
        }
        return r;
    }

    private boolean loadFile(File file) {
        try {
            if (file.getName().endsWith("xml") || file.getName().contains(".xml.")) {
                this.load(new FileInputStream(file));
            } else {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
                propertiesConfiguration.setEncoding(this.getString(ApplicationProperties.LOCALE_CHAR_ENCODING.key, "UTF-8"));
                propertiesConfiguration.load((InputStream)new FileInputStream(file));
                this.copy((Configuration)propertiesConfiguration);
                propertiesConfiguration.clear();
            }
            return true;
        }
        catch (ConfigurationException e) {
            this.logger.error((Object)e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)e.getMessage());
        }
        return false;
    }

    public boolean load(Class<?> cls, String propertyFile) {
        boolean success;
        block14: {
            success = false;
            InputStream in = null;
            try {
                try {
                    in = cls.getResourceAsStream(propertyFile);
                    this.load(in);
                    success = true;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Unable to load properties from file:" + propertyFile), (Throwable)e);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public String[] getStringArray(String key, String ... defaultValue) {
        String[] retVal = super.getStringArray(key);
        return retVal != null && retVal.length > 0 ? retVal : (defaultValue == null ? new String[]{} : defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        try {
            String sVal = this.getString(key, "").trim();
            boolean val = StringUtil.booleanValueOf(sVal, defaultValue);
            return val;
        }
        catch (Exception exception) {
            return super.getBoolean(key, defaultValue);
        }
    }

    public Object getObject(String key) {
        return super.getProperty(key);
    }

    public String getPropertyValue(String sPropertyName) {
        return this.getString(sPropertyName, sPropertyName);
    }

    public String getPropertyValueOrNull(String sPropertyName) {
        return this.getString(sPropertyName);
    }

    public void storePropertyFile(File f) {
        try {
            this.save(f);
        }
        catch (ConfigurationException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    public void addProperty(String key, Object value) {
        this.clearProperty(key);
        super.addProperty(key, value);
    }

    public void setProperty(String key, Object value) {
        if (value != null && value instanceof String && value.toString().indexOf(this.getListDelimiter()) > 0) {
            value = PropertyConverter.split((String)value.toString(), (char)this.getListDelimiter());
        }
        super.setProperty(key, value);
    }

    public void editProperty(String key, Object value) {
        super.addProperty(key, value);
    }

    public void clearProperty(String key) {
        if (!System.getProperties().containsKey(key)) {
            super.clearProperty(key);
        } else {
            this.logger.debug((Object)("clear system property ignored:" + key));
        }
    }

    public PasswordDecryptor getPasswordDecryptor() {
        String implName = this.getString(ApplicationProperties.PASSWORD_DECRYPTOR_IMPL.key);
        if (StringUtil.isBlank((String)implName)) {
            return new Base64PasswordDecryptor();
        }
        try {
            return (PasswordDecryptor)Class.forName(implName).newInstance();
        }
        catch (Exception e) {
            throw new AutomationError("Unable to get instance of PasswordDecryptor implementation", e);
        }
    }

    private static void ignoreSSLCetrificatesAndHostVerification() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                System.out.println("======== AcceptedIssuers =============");
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
                System.out.println("========= ClientTrusted =============");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
                System.out.println("======== ServerTrusted =============");
            }
        }}, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }
}

