/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.StepNotFoundException;
import com.qmetry.qaf.automation.step.StringTestStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.CustomStep;
import com.qmetry.qaf.automation.util.Reporter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DryRunAnalyzer {
    private final List<StepCallLog> callLog = new ArrayList<StepCallLog>();

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    List steps = DryRunAnalyzer.getInstance().callLog;
                    if (!steps.isEmpty()) {
                        System.out.println("Steps executed: " + steps);
                        System.out.println("Step Name| Found | References | Calls\n");
                        for (StepCallLog log : steps) {
                            System.out.println(log);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
    }

    private DryRunAnalyzer() {
    }

    public synchronized void addStep(String step, String calledAs, String reference, String codeSninppet) {
        StepCallLog dstep = this.getStepCallLog(step);
        dstep.getReferences().add(reference);
        dstep.getCalls().add(calledAs);
        dstep.setCodeSninppet(codeSninppet);
    }

    private StepCallLog getStepCallLog(String step) {
        StepCallLog dstep = new StepCallLog(step);
        int i = this.callLog.indexOf(dstep);
        if (i >= 0) {
            dstep = this.callLog.get(i);
        } else {
            this.callLog.add(dstep);
        }
        return dstep;
    }

    public static boolean isDryRun(StringTestStep step) {
        if (ApplicationProperties.DRY_RUN_MODE.getBoolenVal(false)) {
            TestStep actualStep = step.getTestStep();
            if (actualStep == null) {
                String name = step.getDescription();
                String codeSnippet = step.getCodeSnippet();
                DryRunAnalyzer.getInstance().addStep(step.getDescription(), name, step.getSignature(), codeSnippet);
                ((QAFTestBase)TestBaseProvider.instance().get()).addVerificationError((Throwable)((Object)new StepNotFoundException(step)));
                return true;
            }
            DryRunAnalyzer.getInstance().addStep(actualStep.getDescription(), step.getDescription(), step.getSignature(), "");
            if (!(actualStep instanceof CustomStep)) {
                Reporter.log(step.getDescription(), MessageTypes.TestStepPass);
                return true;
            }
        }
        return false;
    }

    public static DryRunAnalyzer getInstance() {
        return LazyHolder.INSTANCE;
    }

    /* synthetic */ DryRunAnalyzer(DryRunAnalyzer dryRunAnalyzer) {
        this();
    }

    private static class LazyHolder {
        private static final DryRunAnalyzer INSTANCE = new DryRunAnalyzer(null);

        private LazyHolder() {
        }
    }

    public static class StepCallLog {
        private String name;
        private Set<String> references = new HashSet<String>();
        private Set<String> calls = new HashSet<String>();
        private String codeSninppet = "";

        public StepCallLog(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Set<String> getReferences() {
            return this.references;
        }

        public void setReferences(Set<String> references) {
            this.references = references;
        }

        public String getCodeSninppet() {
            return this.codeSninppet;
        }

        public void setCodeSninppet(String codeSninppet) {
            this.codeSninppet = codeSninppet;
        }

        public Set<String> getCalls() {
            return this.calls;
        }

        public void setCalls(Set<String> calls) {
            this.calls = calls;
        }

        public String toString() {
            return String.valueOf(this.name) + " | " + (this.codeSninppet.trim().length() == 0) + " | " + this.references.size() + " | " + this.calls.size();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.toString().equalsIgnoreCase(this.name)) {
                return true;
            }
            if (obj instanceof StepCallLog) {
                return this.name.equalsIgnoreCase(((StepCallLog)obj).name);
            }
            return super.equals(obj);
        }
    }
}

