/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.integration.ResultUpdator;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.Validator;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.ITestContext;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;

public abstract class TestNGTestCase
extends Validator {
    protected final Log logger = LogFactoryImpl.getLog(this.getClass());
    protected ITestContext context;

    @BeforeGroups(alwaysRun=true)
    @BeforeClass(alwaysRun=true)
    public final void setup(ITestContext context) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        this.context = context;
    }

    @BeforeSuite(alwaysRun=true)
    public final void setupSuit(ITestContext context) {
        this.context = context;
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        LinkedHashMap params2 = new LinkedHashMap(context.getSuite().getXmlSuite().getParameters());
        ConfigurationManager.addAll(params2);
    }

    @BeforeTest(alwaysRun=true)
    public final void setupTest(ITestContext context) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        LinkedHashMap params2 = new LinkedHashMap(context.getCurrentXmlTest().getAllParameters());
        ConfigurationManager.addAll(params2);
        this.context = context;
    }

    @BeforeMethod(alwaysRun=true)
    public final void setupMethod(Method m, ITestContext context) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_CONTEXT.key, context);
        this.context = context;
    }

    @AfterSuite
    public final void afterSuit(ITestContext testContext) {
        TestBaseProvider.instance().stopAll();
        ResultUpdator.awaitTermination();
    }

    public PropertyUtil getProps() {
        return ConfigurationManager.getBundle();
    }
}

