/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.report;

import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.client.TestNGScenario;
import com.qmetry.qaf.automation.testng.RetryAnalyzer;
import com.qmetry.qaf.automation.testng.report.ClassInfo;
import com.qmetry.qaf.automation.testng.report.MetaInfo;
import com.qmetry.qaf.automation.testng.report.MethodInfo;
import com.qmetry.qaf.automation.testng.report.MethodResult;
import com.qmetry.qaf.automation.testng.report.Report;
import com.qmetry.qaf.automation.testng.report.ReportEntry;
import com.qmetry.qaf.automation.testng.report.TestOverview;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.Test;
import org.testng.xml.XmlTest;

public class ReporterUtil {
    private static final Log logger = LogFactoryImpl.getLog(ReporterUtil.class);
    private static final String QAF_TEST_IDENTIFIER = "qaf_test_identifier";

    public static void updateMetaInfo(ISuite suite) {
        ReporterUtil.createMetaInfo(suite, false);
    }

    public static void createMetaInfo(ISuite suite) {
        ReporterUtil.createMetaInfo(suite, true);
    }

    private static void createMetaInfo(ISuite suite, boolean listEntry) {
        List tests = suite.getXmlSuite().getTests();
        ArrayList<String> testNames = new ArrayList<String>();
        for (XmlTest test : tests) {
            testNames.add(ReporterUtil.getTestName(test.getName()));
        }
        String dir = ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[0]);
        Report report = new Report();
        if (!ConfigurationManager.getBundle().containsKey("suit.start.ts")) {
            dir = ApplicationProperties.JSON_REPORT_DIR.getStringVal(String.valueOf(ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal("test-results")) + "/" + DateUtil.getDate(0, "EdMMMyy_hhmma"));
            ConfigurationManager.getBundle().setProperty(ApplicationProperties.JSON_REPORT_DIR.key, dir);
            FileUtil.checkCreateDir(ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal("test-results"));
            FileUtil.checkCreateDir(dir);
            ConfigurationManager.getBundle().setProperty("suit.start.ts", System.currentTimeMillis());
        } else {
            report.setEndTime(System.currentTimeMillis());
        }
        report.setName(suite.getName());
        report.setTests(testNames);
        report.setDir(dir);
        int pass = 0;
        int fail = 0;
        int skip = 0;
        int total = 0;
        Iterator iter = suite.getResults().values().iterator();
        while (iter.hasNext()) {
            ITestContext context = ((ISuiteResult)iter.next()).getTestContext();
            pass += ReporterUtil.getPassCnt(context);
            skip += ReporterUtil.getSkipCnt(context);
            fail += ReporterUtil.getFailCnt(context) + ReporterUtil.getFailWithPassPerCnt(context);
            total += ReporterUtil.getTotal(context);
        }
        report.setPass(pass);
        report.setFail(fail);
        report.setSkip(skip);
        report.setTotal(pass + fail + skip > total ? pass + fail + skip : total);
        report.setStatus(fail > 0 ? "fail" : (pass > 0 ? "pass" : "unstable"));
        report.setStartTime(ConfigurationManager.getBundle().getLong("suit.start.ts", 0L));
        ReporterUtil.appendReportInfo(report);
        if (listEntry) {
            ReportEntry reportEntry = new ReportEntry();
            reportEntry.setName(suite.getName());
            reportEntry.setStartTime(ConfigurationManager.getBundle().getLong("suit.start.ts", 0L));
            reportEntry.setDir(dir);
            ReporterUtil.appendMetaInfo(reportEntry);
        }
    }

    public static synchronized void updateOverview(ITestContext context, ITestResult result) {
        try {
            String file = String.valueOf(ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[0])) + "/" + ReporterUtil.getTestName(context) + "/overview.json";
            TestOverview overview = JSONUtil.getJsonObjectFromFile(file, TestOverview.class);
            if (result == null) {
                HashMap<String, String> runPrams = new HashMap<String, String>(context.getCurrentXmlTest().getAllParameters());
                Configuration env = ConfigurationManager.getBundle().subset("env");
                Iterator iter = env.getKeys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    runPrams.put(key, env.getString(key));
                }
                HashMap<String, Object> envInfo = new HashMap<String, Object>();
                envInfo.put("isfw-build-info", ConfigurationManager.getBundle().getObject("isfw.build.info"));
                envInfo.put("run-parameters", runPrams);
                envInfo.put("browser-desired-capabilities", ConfigurationManager.getBundle().getObject("driver.desiredCapabilities"));
                envInfo.put("browser-actual-capabilities", ReporterUtil.getActualCapabilities());
                overview.setEnvInfo(envInfo);
                HashMap<String, String> executionEnvInfo = new HashMap<String, String>();
                executionEnvInfo.put("os.name", System.getProperty("os.name"));
                executionEnvInfo.put("os.version", System.getProperty("os.version"));
                executionEnvInfo.put("os.arch", System.getProperty("os.arch"));
                executionEnvInfo.put("java.version", System.getProperty("java.version"));
                executionEnvInfo.put("java.vendor", System.getProperty("java.vendor"));
                executionEnvInfo.put("java.arch", System.getProperty("sun.arch.data.model"));
                executionEnvInfo.put("user.name", System.getProperty("user.name"));
                try {
                    executionEnvInfo.put("host", InetAddress.getLocalHost().getHostName());
                }
                catch (Exception exception) {
                    String hostname = ReporterUtil.execHostName("hostname");
                    executionEnvInfo.put("host", hostname);
                }
                envInfo.put("execution-env-info", executionEnvInfo);
            }
            int pass = ReporterUtil.getPassCnt(context);
            int fail = ReporterUtil.getFailCnt(context) + ReporterUtil.getFailWithPassPerCnt(context);
            int skip = ReporterUtil.getSkipCnt(context);
            int total = ReporterUtil.getTotal(context);
            overview.setTotal(total > pass + fail + skip ? total : pass + fail + skip);
            overview.setPass(pass);
            overview.setSkip(skip);
            overview.setFail(fail);
            if (result != null) {
                overview.getClasses().add(result.getTestClass().getName());
            }
            if (overview.getStartTime() > 0L) {
                overview.setEndTime(System.currentTimeMillis());
            } else {
                overview.setStartTime(System.currentTimeMillis());
            }
            JSONUtil.writeJsonObjectToFile(file, overview);
            ReporterUtil.updateMetaInfo(context.getSuite());
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
    }

    private static Map<String, String> getActualCapabilities() {
        Map map = (Map)ConfigurationManager.getBundle().getObject("driver.actualCapabilities");
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (map != null) {
            for (String key : map.keySet()) {
                try {
                    newMap.put(key, String.valueOf(map.get(key)));
                }
                catch (Exception exception) {}
            }
        }
        return newMap;
    }

    public static void createMethodResult(ITestContext context, ITestResult result, List<LoggingBean> logs, List<CheckpointResultBean> checkpoints) {
        try {
            String dir = ReporterUtil.getClassDir(context, result);
            MethodResult methodResult = new MethodResult();
            methodResult.setSeleniumLog(logs);
            methodResult.setCheckPoints(checkpoints);
            methodResult.setThrowable(result.getThrowable());
            ReporterUtil.updateOverview(context, result);
            String fileName = ReporterUtil.getMethodIdentifier(result);
            String methodResultFile = String.valueOf(dir) + "/" + fileName;
            File f = new File(String.valueOf(methodResultFile) + ".json");
            if (f.exists()) {
                fileName = String.valueOf(fileName) + StringUtil.getRandomString("aaaaaaaaaa");
                methodResultFile = String.valueOf(dir) + "/" + fileName;
                result.setAttribute(QAF_TEST_IDENTIFIER, (Object)fileName);
                ReporterUtil.updateClassMetaInfo(context, result, fileName);
            } else {
                ReporterUtil.updateClassMetaInfo(context, result, fileName);
            }
            JSONUtil.writeJsonObjectToFile(String.valueOf(methodResultFile) + ".json", methodResult);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static synchronized void updateClassMetaInfo(ITestContext context, ITestResult result, String methodfname) {
        Map<Object, Object> metadata;
        String dir = ReporterUtil.getClassDir(context, result);
        String file = String.valueOf(dir) + "/meta-info.json";
        FileUtil.checkCreateDir(dir);
        ClassInfo classInfo = JSONUtil.getJsonObjectFromFile(file, ClassInfo.class);
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setStartTime(result.getStartMillis());
        methodInfo.setDuration(result.getEndMillis() - result.getStartMillis());
        result.getStatus();
        if (result.getMethod().isTest()) {
            methodInfo.setIndex(result.getMethod().getCurrentInvocationCount());
            int retryCount = ConfigurationManager.getBundle().getInt(RetryAnalyzer.RETRY_INVOCATION_COUNT, 0);
            if (retryCount > 0) {
                methodInfo.setRetryCount(retryCount);
            }
            methodInfo.setArgs(result.getParameters());
            if (result.getMethod() instanceof TestNGScenario) {
                TestNGScenario scenario = (TestNGScenario)result.getMethod();
                metadata = scenario.getMetaData();
                metadata.put("description", scenario.getDescription());
                metadata.put("groups", scenario.getGroups());
            } else {
                String desc = ApplicationProperties.CURRENT_TEST_DESCRIPTION.getStringVal(result.getMethod().getDescription());
                metadata = new HashMap();
                metadata.put("groups", result.getMethod().getGroups());
                metadata.put("description", desc);
            }
            metadata.put("name", ReporterUtil.getMethodName(result));
            methodInfo.setMetaData(metadata);
            ConfigurationManager.getBundle().clearProperty(ApplicationProperties.CURRENT_TEST_DESCRIPTION.key);
            Test test = result.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class);
            if (test.dependsOnMethods() != null && test.dependsOnMethods().length > 0 || test.dependsOnGroups() != null && test.dependsOnGroups().length > 0) {
                String[] depends = new String[]{"Methods: " + Arrays.toString(test.dependsOnMethods()), "Groups: " + Arrays.toString(test.dependsOnGroups())};
                methodInfo.setDependsOn(depends);
            }
            methodInfo.setType("test");
        } else {
            String name = ReporterUtil.getMethodName(result);
            logger.debug((Object)("config method:  " + name));
            metadata = new HashMap<String, Object>();
            metadata.put("groups", result.getMethod().getGroups());
            metadata.put("description", result.getMethod().getDescription());
            metadata.put("name", name);
            methodInfo.setMetaData(metadata);
            methodInfo.setType("config");
        }
        methodInfo.setResult(ReporterUtil.getResult(result.getStatus()));
        if (StringUtil.isNotBlank((String)methodfname)) {
            metadata.put("resultFileName", methodfname);
        }
        if (!classInfo.getMethods().contains(methodInfo)) {
            logger.debug((Object)("method:  result: " + methodInfo.getResult() + " groups: " + methodInfo.getMetaData()));
            classInfo.getMethods().add(methodInfo);
            JSONUtil.writeJsonObjectToFile(file, classInfo);
        } else {
            logger.warn((Object)("methodInfo already wrritten for " + methodInfo.getName()));
        }
    }

    private static String getMethodName(ITestResult result) {
        return result.getName();
    }

    private static String getMethodIdentifier(ITestResult result) {
        if (result.getAttribute(QAF_TEST_IDENTIFIER) != null) {
            return (String)result.getAttribute(QAF_TEST_IDENTIFIER);
        }
        String id = ReporterUtil.getMethodName(result);
        String identifierKey = ApplicationProperties.TESTCASE_IDENTIFIER_KEY.getStringVal("testCaseId");
        TreeMap<String, Object> metadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (result.getMethod() instanceof TestNGScenario) {
            TestNGScenario scenario = (TestNGScenario)result.getMethod();
            metadata.putAll(scenario.getMetaData());
        }
        if (result.getParameters() != null && result.getParameters().length > 0 && result.getParameters()[0] instanceof Map) {
            metadata.putAll((Map)result.getParameters()[0]);
        }
        if (metadata.containsKey(identifierKey)) {
            id = metadata.get(identifierKey).toString();
        }
        if ((id = StringUtil.toTitleCaseIdentifier(id)).length() > 50) {
            id = id.substring(0, 50);
        }
        result.setAttribute(QAF_TEST_IDENTIFIER, (Object)id);
        return (String)result.getAttribute(QAF_TEST_IDENTIFIER);
    }

    private static String getClassDir(ITestContext context, ITestResult result) {
        String testName = ReporterUtil.getTestName(context);
        return String.valueOf(ApplicationProperties.JSON_REPORT_DIR.getStringVal(new String[0])) + "/" + testName + "/" + result.getTestClass().getName();
    }

    private static void appendReportInfo(Report report) {
        String file = String.valueOf(report.getDir()) + "/meta-info.json";
        JSONUtil.writeJsonObjectToFile(file, report);
    }

    private static void appendMetaInfo(ReportEntry report) {
        String file = String.valueOf(ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal("test-results")) + "/meta-info.json";
        MetaInfo metaInfo = JSONUtil.getJsonObjectFromFile(file, MetaInfo.class);
        metaInfo.getReports().remove(report);
        metaInfo.getReports().add(report);
        JSONUtil.writeJsonObjectToFile(file, metaInfo);
    }

    private static String getResult(int res) {
        switch (res) {
            case 1: {
                return "pass";
            }
            case 2: {
                return "fail";
            }
            case 3: {
                return "skip";
            }
            case 4: {
                return "pass";
            }
        }
        return "";
    }

    private static String getTestName(ITestContext context) {
        if (context == null) {
            context = (ITestContext)ConfigurationManager.getBundle().getObject(ApplicationProperties.CURRENT_TEST_CONTEXT.key);
        }
        return ReporterUtil.getTestName(context.getName());
    }

    private static int getPassCnt(ITestContext context) {
        if (context != null && context.getPassedTests() != null) {
            if (context.getPassedTests().getAllResults() != null) {
                return context.getPassedTests().getAllResults().size();
            }
            return context.getPassedTests().size();
        }
        return 0;
    }

    private static int getFailCnt(ITestContext context) {
        if (context != null && context.getFailedTests() != null) {
            if (context.getFailedTests().getAllResults() != null) {
                return context.getFailedTests().getAllResults().size();
            }
            return context.getFailedTests().size();
        }
        return 0;
    }

    private static int getFailWithPassPerCnt(ITestContext context) {
        if (context != null && context.getFailedButWithinSuccessPercentageTests() != null) {
            if (context.getFailedButWithinSuccessPercentageTests().getAllResults() != null) {
                return context.getFailedButWithinSuccessPercentageTests().getAllResults().size();
            }
            return context.getFailedButWithinSuccessPercentageTests().size();
        }
        return 0;
    }

    private static int getSkipCnt(ITestContext context) {
        if (context != null && context.getSkippedTests() != null) {
            if (context.getSkippedTests().getAllResults() != null) {
                Collection skippedTest = context.getSkippedTests().getAllMethods();
                HashSet set = new HashSet(skippedTest);
                if (ApplicationProperties.RETRY_CNT.getIntVal(0) > 0) {
                    set.removeAll(context.getPassedTests().getAllMethods());
                    set.removeAll(context.getFailedTests().getAllMethods());
                    return set.size();
                }
                return context.getSkippedTests().getAllResults().size();
            }
            return context.getSkippedTests().size();
        }
        return 0;
    }

    private static int getTotal(ITestContext context) {
        return context == null || context.getAllTestMethods() == null ? 0 : context.getAllTestMethods().length;
    }

    private static String getTestName(String testname) {
        return StringUtil.isBlank((String)testname) ? "" : testname.replaceAll("[^a-zA-Z0-9_]+", "");
    }

    public static String execHostName(String execCommand) {
        try {
            Process proc = Runtime.getRuntime().exec(execCommand);
            InputStream stream = proc.getInputStream();
            if (stream != null) {
                Scanner s = new Scanner(stream);
                s.useDelimiter("\\A");
                String val = s.hasNext() ? s.next() : "";
                stream.close();
                s.close();
                return val;
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        return "";
    }
}

