/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.chrome.ChromeDriverService;

public class ChromeDriverHelper {
    private ChromeDriverService service;
    private final Log logger = LogFactory.getLog(this.getClass());

    private synchronized void createAndStartService() {
        if (this.service != null && this.service.isRunning()) {
            return;
        }
        File driverFile = new File(ApplicationProperties.CHROME_DRIVER_PATH.getStringVal("./chromedriver.exe"));
        if (!driverFile.exists()) {
            this.logger.error((Object)"Please set webdriver.chrome.driver property properly.");
            throw new AutomationError("Driver file not exist.");
        }
        try {
            System.setProperty("webdriver.chrome.driver", driverFile.getCanonicalPath());
            this.service = ChromeDriverService.createDefaultService();
            this.service.start();
        }
        catch (IOException e) {
            this.logger.error((Object)"Unable to start Chrome driver", (Throwable)e);
            throw new AutomationError("Unable to start Chrome Driver Service ", e);
        }
    }

    private void stopService() {
        if (this.service != null && this.service.isRunning()) {
            this.logger.info((Object)"Stopping chrome driver service.");
            this.service.stop();
        }
    }

    private ChromeDriverHelper() {
    }

    public static ChromeDriverService getService() {
        SingletonHolder.INSTANCE.createAndStartService();
        return SingletonHolder.INSTANCE.service;
    }

    public static void teardownService() {
        SingletonHolder.INSTANCE.stopService();
    }

    /* synthetic */ ChromeDriverHelper(ChromeDriverHelper chromeDriverHelper) {
        this();
    }

    private static class SingletonHolder {
        public static final ChromeDriverHelper INSTANCE = new ChromeDriverHelper(null);

        private SingletonHolder() {
        }
    }
}

