/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.json.CDL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONUtil {
    private static final Log logger = LogFactoryImpl.getLog(JSONUtil.class);

    public static Map<String, Object> toMap(String json) throws JSONException {
        Map map = (Map)new Gson().fromJson(json, Map.class);
        return map;
    }

    public static boolean isValidJsonString(String str) {
        try {
            new JSONObject(str);
            return true;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }

    public static JSONArray getJsonArrayOrNull(String str) {
        try {
            return new JSONArray(str);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONArray getJsonArrayFromCsvOrNull(String csv) {
        try {
            return CDL.rowToJSONArray((JSONTokener)new JSONTokener(csv));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isValidGsonString(String str) {
        try {
            new JsonParser().parse(str);
            return true;
        }
        catch (JsonParseException jsonParseException) {
            return false;
        }
    }

    static Map<String, Object> toMap(JSONObject obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj != null) {
            Iterator iter = obj.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    map.put(key, obj.get(key));
                }
                catch (JSONException jSONException) {}
            }
        }
        return map;
    }

    public static JsonElement getGsonElement(String str) {
        try {
            return new JsonParser().parse(str);
        }
        catch (JsonParseException jsonParseException) {
            return null;
        }
    }

    public static <T> void writeJsonObjectToFile(String file, T obj) {
        File f = new File(file);
        try {
            Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
            String jsonStr = gson.toJson(obj, obj.getClass());
            FileUtil.writeStringToFile((File)f, (String)jsonStr, (String)"UTF-8");
        }
        catch (Throwable e) {
            System.err.println("Unable to write : " + obj.getClass().getCanonicalName() + " in file: " + file + " :" + e.getMessage());
            logger.error((Object)("Unable to write : " + obj.getClass().getCanonicalName() + " in file: " + file + " :" + e.getMessage()));
        }
    }

    public static Object[][] getJsonArrayOfMaps(String file) {
        try {
            List mapData;
            Gson gson = new Gson();
            Type DATASET_TYPE = new TypeToken<List<Map<String, Object>>>(){
                private static final long serialVersionUID = 4426388930719377223L;
            }.getType();
            if (file.startsWith("[")) {
                mapData = (List)gson.fromJson(file, DATASET_TYPE);
            } else {
                String jsonStr = FileUtil.readFileToString((File)new File(file), (String)ApplicationProperties.LOCALE_CHAR_ENCODING.getStringVal("UTF-8"));
                mapData = (List)gson.fromJson(jsonStr, DATASET_TYPE);
            }
            Object[][] objecttoreturn = new Object[mapData.size()][1];
            int i = 0;
            while (i < mapData.size()) {
                objecttoreturn[i][0] = mapData.get(i);
                ++i;
            }
            return objecttoreturn;
        }
        catch (Throwable e) {
            throw new AutomationError(e);
        }
    }

    public static <T> T getJsonObjectFromFile(String file, Class<T> cls) {
        String json;
        File f = new File(file);
        String defVal = List.class.isAssignableFrom(cls) || cls.isArray() ? "[]" : (ClassUtil.isPrimitiveOrWrapperType(cls) ? "" : "{}");
        try {
            json = FileUtil.readFileToString((File)f, (String)"UTF-8");
        }
        catch (IOException iOException) {
            json = defVal;
        }
        catch (Throwable e) {
            logger.error((Object)("unable to load [" + cls.getName() + "] from file[ " + file + "] - " + e.getMessage()));
            json = defVal;
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return (T)gson.fromJson(json, cls);
    }
}

