/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.testng.ClassMethodMap;
import org.testng.DependencyMap;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IConfigurationListener2;
import org.testng.IExecutionListener;
import org.testng.IHookable;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IMethodSelector;
import org.testng.IModuleFactory;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.InstanceOrderingMethodInterceptor;
import org.testng.PreserveOrderMethodInterceptor;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.annotations.Guice;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.Attributes;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassImpl;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.Constants;
import org.testng.internal.DynamicGraph;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.graph.GraphThreadPoolExecutor;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestRunner
implements ITestContext,
ITestResultNotifier,
IThreadWorkerFactory<ITestNGMethod> {
    private static final long serialVersionUID = 4247820024988306670L;
    private ISuite m_suite;
    private XmlTest m_xmlTest;
    private String m_testName;
    private transient List<XmlClass> m_testClassesFromXml = null;
    private transient List<XmlPackage> m_packageNamesFromXml = null;
    private transient IInvoker m_invoker = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<ITestListener> m_testListeners = Lists.newArrayList();
    private transient Set<IConfigurationListener> m_configurationListeners = Sets.newHashSet();
    private transient IConfigurationListener m_confListener = new ConfigurationListener();
    private transient boolean m_skipFailedInvocationCounts;
    private transient Collection<IInvokedMethodListener> m_invokedMethodListeners = Lists.newArrayList();
    private final transient Map<Class<? extends IClassListener>, IClassListener> m_classListeners = Maps.newHashMap();
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = null;
    private Date m_endDate = null;
    private transient Map<Class<?>, ITestClass> m_classMap = Maps.newLinkedHashMap();
    private String m_outputDirectory = Constants.getDefaultValueFor((String)"testng.outputDir");
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private List<ITestNGMethod> m_excludedMethods = Lists.newArrayList();
    private ConfigurationGroupMethods m_groupMethods = null;
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private IResultMap m_passedTests = new ResultMap();
    private IResultMap m_failedTests = new ResultMap();
    private IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private IResultMap m_skippedTests = new ResultMap();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private transient List<IMethodInterceptor> m_methodInterceptors;
    private transient ClassMethodMap m_classMethodMap;
    private transient TestNGClassFinder m_testClassFinder;
    private transient IConfiguration m_configuration;
    private IMethodInterceptor builtinInterceptor;
    private final List<InvokedMethod> m_invokedMethods = Lists.newArrayList();
    private IResultMap m_passedConfigurations = new ResultMap();
    private IResultMap m_skippedConfigurations = new ResultMap();
    private IResultMap m_failedConfigurations = new ResultMap();
    private IAttributes m_attributes = new Attributes();
    private ListMultiMap<Class<? extends Module>, Module> m_guiceModules = Maps.newListMultiMap();
    private Map<List<Module>, Injector> m_injectors = Maps.newHashMap();

    protected TestRunner(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners) {
        this.init(configuration, suite, test, outputDirectory, finder, skipFailedInvocationCounts, invokedMethodListeners, classListeners);
    }

    public TestRunner(IConfiguration configuration, ISuite suite, XmlTest test, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners) {
        this.init(configuration, suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(), skipFailedInvocationCounts, invokedMethodListeners, classListeners);
    }

    private void init(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder annotationFinder, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners) {
        this.m_configuration = configuration;
        this.m_xmlTest = test;
        this.m_suite = suite;
        this.m_testName = test.getName();
        this.m_host = suite.getHost();
        this.m_testClassesFromXml = test.getXmlClasses();
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.setVerbose(test.getVerbose());
        boolean preserveOrder = test.getPreserveOrder();
        this.m_methodInterceptors = new ArrayList<IMethodInterceptor>();
        this.builtinInterceptor = preserveOrder ? new PreserveOrderMethodInterceptor() : new InstanceOrderingMethodInterceptor();
        this.m_packageNamesFromXml = test.getXmlPackages();
        if (this.m_packageNamesFromXml != null) {
            for (XmlPackage xp : this.m_packageNamesFromXml) {
                this.m_testClassesFromXml.addAll(xp.getXmlClasses());
            }
        }
        this.m_annotationFinder = annotationFinder;
        this.m_invokedMethodListeners = invokedMethodListeners;
        this.m_classListeners.clear();
        for (IClassListener classListener : classListeners) {
            this.m_classListeners.put(classListener.getClass(), classListener);
        }
        this.m_invoker = new Invoker(this.m_configuration, (ITestContext)this, (ITestResultNotifier)this, this.m_suite.getSuiteState(), this.m_skipFailedInvocationCounts, invokedMethodListeners, classListeners);
        if (test.getParallel() != null) {
            this.log(3, "Running the tests in '" + test.getName() + "' with parallel mode:" + test.getParallel());
        }
        this.setOutputDirectory(outputDirectory);
        this.init();
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        if (!this.m_xmlTest.isJUnit()) {
            this.initMethods();
        }
        this.initListeners();
        this.addConfigurationListener(this.m_confListener);
        for (IConfigurationListener cl : this.m_configuration.getConfigurationListeners()) {
            this.addConfigurationListener(cl);
        }
    }

    private ListenerHolder findAllListeners(Class<?> cls) {
        ListenerHolder result = new ListenerHolder();
        result.listenerClasses = Lists.newArrayList();
        do {
            Class[] classes;
            IListenersAnnotation l;
            if ((l = (IListenersAnnotation)this.m_annotationFinder.findAnnotation(cls, IListenersAnnotation.class)) == null) continue;
            Class[] classArray = classes = l.getValue();
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                result.listenerClasses.add(c);
                if (ITestNGListenerFactory.class.isAssignableFrom(c)) {
                    if (result.listenerFactoryClass == null) {
                        result.listenerFactoryClass = c;
                    } else {
                        throw new TestNGException("Found more than one class implementingITestNGListenerFactory:" + c + " and " + result.listenerFactoryClass);
                    }
                }
                ++n2;
            }
        } while ((cls = cls.getSuperclass()) != Object.class);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void initListeners() {
        Set listenerClasses = Sets.newHashSet();
        Class listenerFactoryClass = null;
        for (IClass iClass : this.getTestClasses()) {
            Class realClass = iClass.getRealClass();
            ListenerHolder listenerHolder = this.findAllListeners(realClass);
            if (listenerFactoryClass == null) {
                listenerFactoryClass = listenerHolder.listenerFactoryClass;
            }
            listenerClasses.addAll(listenerHolder.listenerClasses);
        }
        Object var3_6 = null;
        try {
            void var3_8;
            IClass ic;
            if (this.m_testClassFinder != null && (ic = this.m_testClassFinder.getIClass(listenerFactoryClass)) != null) {
                ITestNGListenerFactory iTestNGListenerFactory = (ITestNGListenerFactory)ic.getInstances(false)[0];
            }
            if (var3_8 == null) {
                ITestNGListenerFactory iTestNGListenerFactory = listenerFactoryClass != null ? (ITestNGListenerFactory)listenerFactoryClass.newInstance() : null;
            }
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't instantiate the ITestNGListenerFactory: " + ex);
        }
        for (Class c : listenerClasses) {
            void var3_10;
            ITestNGListener listener;
            if (IClassListener.class.isAssignableFrom(c) && this.m_classListeners.containsKey(c)) continue;
            ITestNGListener iTestNGListener = listener = var3_10 != null ? var3_10.createListener(c) : null;
            if (listener == null) {
                listener = (ITestNGListener)ClassHelper.newInstance((Class)c);
            }
            this.addListener(listener);
        }
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map metaGroups = xmlTest.getMetaGroups();
        for (Map.Entry entry : metaGroups.entrySet()) {
            this.addMetaGroup((String)entry.getKey(), (List)entry.getValue());
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setExpression(this.m_xmlTest.getExpression());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector((IMethodSelector)this.m_xmlMethodSelector, 10);
        if (xmlTest.getMethodSelectors() != null) {
            for (org.testng.xml.XmlMethodSelector selector : xmlTest.getMethodSelectors()) {
                if (selector.getClassName() == null) continue;
                IMethodSelector s = ClassHelper.createSelector((org.testng.xml.XmlMethodSelector)selector);
                this.m_runInfo.addMethodSelector(s, selector.getPriority());
            }
        }
    }

    private void initMethods() {
        List beforeClassMethods = Lists.newArrayList();
        List testMethods = Lists.newArrayList();
        List afterClassMethods = Lists.newArrayList();
        List beforeSuiteMethods = Lists.newArrayList();
        List afterSuiteMethods = Lists.newArrayList();
        List beforeXmlTestMethods = Lists.newArrayList();
        List afterXmlTestMethods = Lists.newArrayList();
        ClassInfoMap classMap = new ClassInfoMap(this.m_testClassesFromXml);
        this.m_testClassFinder = new TestNGClassFinder(classMap, this.m_xmlTest, this.m_configuration, (ITestContext)this);
        TestNGMethodFinder testMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder);
        this.m_runInfo.setTestMethods(testMethods);
        IClass[] classes = this.m_testClassFinder.findTestClasses();
        IClass[] iClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            IClass ic = iClassArray[n2];
            TestClass tc = new TestClass(ic, (ITestMethodFinder)testMethodFinder, this.m_annotationFinder, this.m_runInfo, this.m_xmlTest, classMap.getXmlClass(ic.getRealClass()));
            this.m_classMap.put(ic.getRealClass(), tc);
            ++n2;
        }
        Map beforeGroupMethods = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), (boolean)true);
        Map afterGroupMethods = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), (boolean)false);
        for (ITestClass tc : this.m_classMap.values()) {
            this.fixMethodsWithClass(tc.getTestMethods(), tc, testMethods);
            this.fixMethodsWithClass(tc.getBeforeClassMethods(), tc, beforeClassMethods);
            this.fixMethodsWithClass(tc.getBeforeTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterClassMethods(), tc, afterClassMethods);
            this.fixMethodsWithClass(tc.getBeforeSuiteMethods(), tc, beforeSuiteMethods);
            this.fixMethodsWithClass(tc.getAfterSuiteMethods(), tc, afterSuiteMethods);
            this.fixMethodsWithClass(tc.getBeforeTestConfigurationMethods(), tc, beforeXmlTestMethods);
            this.fixMethodsWithClass(tc.getAfterTestConfigurationMethods(), tc, afterXmlTestMethods);
            this.fixMethodsWithClass(tc.getBeforeGroupsMethods(), tc, MethodHelper.uniqueMethodList(beforeGroupMethods.values()));
            this.fixMethodsWithClass(tc.getAfterGroupsMethods(), tc, MethodHelper.uniqueMethodList(afterGroupMethods.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(beforeSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(beforeXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(testMethods, true, this.m_runInfo, this.m_annotationFinder, false, this.m_excludedMethods);
        this.m_classMethodMap = new ClassMethodMap(testMethods, this.m_xmlMethodSelector);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(afterXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(afterSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_groupMethods = new ConfigurationGroupMethods(this.m_allTestMethods, beforeGroupMethods, afterGroupMethods);
    }

    private void fixMethodsWithClass(ITestNGMethod[] methods, ITestClass testCls, List<ITestNGMethod> methodList) {
        ITestNGMethod[] iTestNGMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ITestNGMethod itm = iTestNGMethodArray[n2];
            itm.setTestClass(testCls);
            if (methodList != null) {
                methodList.add(itm);
            }
            ++n2;
        }
    }

    public Collection<ITestClass> getTestClasses() {
        return this.m_classMap.values();
    }

    public void setTestName(String name) {
        this.m_testName = name;
    }

    public void setOutputDirectory(String od) {
        this.m_outputDirectory = od;
    }

    private void addMetaGroup(String name, List<String> groupNames) {
        this.m_metaGroups.put(name, groupNames);
    }

    private void collectGroups(String[] groups, List<String> unfinishedGroups, Map<String, String> result) {
        String[] stringArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String gn = stringArray[n2];
            List<String> subGroups = this.m_metaGroups.get(gn);
            if (subGroups != null) {
                for (String sg : subGroups) {
                    if (result.get(sg) != null) continue;
                    result.put(sg, sg);
                    unfinishedGroups.add(sg);
                }
            }
            ++n2;
        }
    }

    private Map<String, String> createGroups(List<String> groups) {
        return this.createGroups(groups.toArray(new String[groups.size()]));
    }

    private Map<String, String> createGroups(String[] groups) {
        Map result = Maps.newHashMap();
        String[] stringArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            result.put(group, group);
            ++n2;
        }
        List unfinishedGroups = Lists.newArrayList();
        if (this.m_metaGroups.size() > 0) {
            this.collectGroups(groups, unfinishedGroups, result);
            while (unfinishedGroups.size() > 0) {
                String[] uGroups = unfinishedGroups.toArray(new String[unfinishedGroups.size()]);
                unfinishedGroups = Lists.newArrayList();
                this.collectGroups(uGroups, unfinishedGroups, result);
            }
        }
        return result;
    }

    public void run() {
        this.beforeRun();
        try {
            XmlTest test = this.getTest();
            if (test.isJUnit()) {
                this.privateRunJUnit(test);
            } else {
                this.privateRun(test);
            }
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] testConfigurationMethods = this.getBeforeTestConfigurationMethods();
        if (testConfigurationMethods != null && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), null, null);
        }
    }

    private void privateRunJUnit(XmlTest xmlTest) {
        final ClassInfoMap cim = new ClassInfoMap(this.m_testClassesFromXml, false);
        final Set classes = cim.getClasses();
        final List runMethods = Lists.newArrayList();
        List workers = Lists.newArrayList();
        workers.add(new IWorker<ITestNGMethod>(){

            public long getTimeOut() {
                return 0L;
            }

            public void run() {
                for (Class tc : classes) {
                    List includedMethods = cim.getXmlClass(tc).getIncludedMethods();
                    List methods = Lists.newArrayList();
                    for (XmlInclude inc : includedMethods) {
                        methods.add(inc.getName());
                    }
                    IJUnitTestRunner tr = ClassHelper.createTestRunner((TestRunner)TestRunner.this);
                    tr.setInvokedMethodListeners(TestRunner.this.m_invokedMethodListeners);
                    try {
                        try {
                            tr.run(tc, methods.toArray(new String[methods.size()]));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            runMethods.addAll(tr.getTestMethods());
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        runMethods.addAll(tr.getTestMethods());
                        throw throwable;
                    }
                    runMethods.addAll(tr.getTestMethods());
                }
            }

            public List<ITestNGMethod> getTasks() {
                throw new TestNGException("JUnit not supported");
            }

            public int getPriority() {
                if (TestRunner.this.m_allTestMethods.length == 1) {
                    return TestRunner.this.m_allTestMethods[0].getPriority();
                }
                return 0;
            }

            public int compareTo(IWorker<ITestNGMethod> other) {
                return this.getPriority() - other.getPriority();
            }
        });
        this.runJUnitWorkers(workers);
        this.m_allTestMethods = runMethods.toArray(new ITestNGMethod[runMethods.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void privateRun(XmlTest xmlTest) {
        block7: {
            block6: {
                parallel = xmlTest.getParallel().isParallel();
                threadCount = parallel != false ? xmlTest.getThreadCount() : 1;
                graph = this.createDynamicGraph(this.intercept(this.m_allTestMethods));
                if (!parallel) break block6;
                if (graph.getNodeCount() > 0) {
                    executor = new GraphThreadPoolExecutor(graph, (IThreadWorkerFactory)this, threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<E>());
                    executor.run();
                    try {
                        timeOut = this.m_xmlTest.getTimeOut(0x7FFFFFFFL);
                        Utils.log((String)"TestRunner", (int)2, (String)("Starting executor for test " + this.m_xmlTest.getName() + " with time out:" + timeOut + " milliseconds."));
                        executor.awaitTermination(timeOut, TimeUnit.MILLISECONDS);
                        executor.shutdownNow();
                    }
                    catch (InterruptedException handled) {
                        handled.printStackTrace();
                        Thread.currentThread().interrupt();
                    }
                }
                break block7;
            }
            debug = false;
            freeNodes = graph.getFreeNodes();
            if (debug) {
                System.out.println("Free nodes:" + freeNodes);
            }
            if (graph.getNodeCount() <= 0 || !freeNodes.isEmpty()) ** GOTO lbl35
            throw new TestNGException("No free nodes found in:" + graph);
lbl-1000:
            // 1 sources

            {
                runnables = this.createWorkers(freeNodes);
                for (IWorker<ITestNGMethod> r : runnables) {
                    r.run();
                }
                graph.setStatus((Collection)freeNodes, DynamicGraph.Status.FINISHED);
                freeNodes = graph.getFreeNodes();
                if (!debug) continue;
                System.out.println("Free nodes:" + freeNodes);
lbl35:
                // 3 sources

                ** while (!freeNodes.isEmpty())
            }
        }
    }

    private ITestNGMethod[] intercept(ITestNGMethod[] methods) {
        List methodInstances = this.methodsToMethodInstances(Arrays.asList(methods));
        this.m_methodInterceptors.add(this.builtinInterceptor);
        for (IMethodInterceptor m_methodInterceptor : this.m_methodInterceptors) {
            methodInstances = m_methodInterceptor.intercept(methodInstances, (ITestContext)this);
        }
        List result = Lists.newArrayList();
        for (IMethodInstance imi : methodInstances) {
            result.add(imi.getMethod());
        }
        this.m_classMethodMap = new ClassMethodMap(result, null);
        return result.toArray(new ITestNGMethod[result.size()]);
    }

    public List<IWorker<ITestNGMethod>> createWorkers(List<ITestNGMethod> methods) {
        List<IWorker<ITestNGMethod>> result = XmlSuite.ParallelMode.INSTANCES.equals((Object)this.m_xmlTest.getParallel()) ? this.createInstanceBasedParallelWorkers(methods) : this.createClassBasedParallelWorkers(methods);
        return result;
    }

    private List<IWorker<ITestNGMethod>> createClassBasedParallelWorkers(List<ITestNGMethod> methods) {
        List result = Lists.newArrayList();
        Set sequentialClasses = Sets.newHashSet();
        for (ITestNGMethod m : methods) {
            Class cls = m.getRealClass();
            ITestAnnotation test = (ITestAnnotation)this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class);
            if ((test == null || !test.getSequential() && !test.getSingleThreaded()) && !XmlSuite.ParallelMode.CLASSES.equals((Object)this.m_xmlTest.getParallel())) continue;
            sequentialClasses.add(cls);
        }
        List methodInstances = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            methodInstances.addAll(this.methodsToMultipleMethodInstances(tm));
        }
        Map params2 = this.m_xmlTest.getAllParameters();
        Set processedClasses = Sets.newHashSet();
        for (IMethodInstance im : methodInstances) {
            TestMethodWorker worker;
            Class c = im.getMethod().getTestClass().getRealClass();
            if (sequentialClasses.contains(c)) {
                if (processedClasses.contains(c)) continue;
                processedClasses.add(c);
                if (System.getProperty("experimental") != null) {
                    List<List<IMethodInstance>> instances = this.createInstances(methodInstances);
                    for (List<IMethodInstance> inst : instances) {
                        TestMethodWorker worker2 = this.createTestMethodWorker(inst, params2, c);
                        result.add(worker2);
                    }
                    continue;
                }
                worker = this.createTestMethodWorker(methodInstances, params2, c);
                result.add(worker);
                continue;
            }
            worker = this.createTestMethodWorker(Arrays.asList(im), params2, c);
            result.add(worker);
        }
        Collections.sort(result);
        return result;
    }

    private List<IWorker<ITestNGMethod>> createInstanceBasedParallelWorkers(List<ITestNGMethod> methods) {
        List result = Lists.newArrayList();
        ListMultiMap lmm = Maps.newListMultiMap();
        for (ITestNGMethod m : methods) {
            lmm.put(m.getInstance(), (Object)m);
        }
        for (Map.Entry es : lmm.entrySet()) {
            List methodInstances = Lists.newArrayList();
            for (ITestNGMethod m : (List)es.getValue()) {
                methodInstances.add(new MethodInstance(m));
            }
            TestMethodWorker tmw = new TestMethodWorker(this.m_invoker, methodInstances.toArray(new IMethodInstance[methodInstances.size()]), this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), this.m_groupMethods, this.m_classMethodMap, (ITestContext)this, new ArrayList<IClassListener>(this.m_classListeners.values()));
            result.add(tmw);
        }
        return result;
    }

    private List<List<IMethodInstance>> createInstances(List<IMethodInstance> methodInstances) {
        Map map = Maps.newHashMap();
        for (IMethodInstance imi : methodInstances) {
            Object[] objectArray = imi.getInstances();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                System.out.println(o);
                List l = (List)map.get(o);
                if (l == null) {
                    l = Lists.newArrayList();
                    map.put(o, l);
                }
                l.add(imi);
                ++n2;
            }
        }
        return new ArrayList<List<IMethodInstance>>(map.values());
    }

    private TestMethodWorker createTestMethodWorker(List<IMethodInstance> methodInstances, Map<String, String> params2, Class<?> c) {
        return new TestMethodWorker(this.m_invoker, this.findClasses(methodInstances, c), this.m_xmlTest.getSuite(), params2, this.m_groupMethods, this.m_classMethodMap, (ITestContext)this, new ArrayList<IClassListener>(this.m_classListeners.values()));
    }

    private IMethodInstance[] findClasses(List<IMethodInstance> methodInstances, Class<?> c) {
        List result = Lists.newArrayList();
        for (IMethodInstance mi : methodInstances) {
            if (mi.getMethod().getTestClass().getRealClass() != c) continue;
            result.add(mi);
        }
        return result.toArray(new IMethodInstance[result.size()]);
    }

    private List<MethodInstance> methodsToMultipleMethodInstances(ITestNGMethod ... sl) {
        List vResult = Lists.newArrayList();
        ITestNGMethod[] iTestNGMethodArray = sl;
        int n = sl.length;
        int n2 = 0;
        while (n2 < n) {
            ITestNGMethod m = iTestNGMethodArray[n2];
            vResult.add(new MethodInstance(m));
            ++n2;
        }
        return vResult;
    }

    private List<IMethodInstance> methodsToMethodInstances(List<ITestNGMethod> sl) {
        ArrayList<IMethodInstance> result = new ArrayList<IMethodInstance>();
        for (ITestNGMethod iTestNGMethod : sl) {
            result.add((IMethodInstance)new MethodInstance(iTestNGMethod));
        }
        return result;
    }

    private void runJUnitWorkers(List<? extends IWorker<ITestNGMethod>> workers) {
        for (IWorker<ITestNGMethod> iWorker : workers) {
            iWorker.run();
        }
    }

    private void afterRun() {
        ITestNGMethod[] testConfigurationMethods = this.getAfterTestConfigurationMethods();
        if (testConfigurationMethods != null && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getAllParameters(), null, null);
        }
        this.m_endDate = new Date(System.currentTimeMillis());
        if (TestRunner.getVerbose() >= 3) {
            this.dumpInvokedMethods();
        }
        this.fireEvent(false);
    }

    private DynamicGraph<ITestNGMethod> createDynamicGraph(ITestNGMethod[] methods) {
        DynamicGraph result = new DynamicGraph();
        ListMultiMap methodsByPriority = Maps.newListMultiMap();
        ITestNGMethod[] iTestNGMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ITestNGMethod method = iTestNGMethodArray[n2];
            methodsByPriority.put((Object)method.getPriority(), (Object)method);
            ++n2;
        }
        List availablePriorities = Lists.newArrayList((Collection)methodsByPriority.keySet());
        Collections.sort(availablePriorities);
        Integer previousPriority = methods.length > 0 ? (Integer)availablePriorities.get(0) : 0;
        int i = 1;
        while (i < availablePriorities.size()) {
            Integer currentPriority = (Integer)availablePriorities.get(i);
            for (ITestNGMethod p0Method : (List)methodsByPriority.get((Object)previousPriority)) {
                for (ITestNGMethod p1Method : (List)methodsByPriority.get((Object)currentPriority)) {
                    result.addEdge(PriorityWeight.priority.ordinal(), (Object)p1Method, (Object[])new ITestNGMethod[]{p0Method});
                }
            }
            previousPriority = currentPriority;
            ++i;
        }
        DependencyMap dependencyMap = new DependencyMap(methods);
        boolean hasDependencies = false;
        ITestNGMethod[] iTestNGMethodArray2 = methods;
        int n3 = methods.length;
        int n4 = 0;
        while (n4 < n3) {
            String d;
            int n5;
            int n6;
            String[] stringArray;
            ITestNGMethod m = iTestNGMethodArray2[n4];
            result.addNode((Object)m);
            String[] dependentMethods = m.getMethodsDependedUpon();
            if (dependentMethods != null) {
                stringArray = dependentMethods;
                n6 = dependentMethods.length;
                n5 = 0;
                while (n5 < n6) {
                    d = stringArray[n5];
                    ITestNGMethod dm = dependencyMap.getMethodDependingOn(d, m);
                    if (m != dm) {
                        result.addEdge(PriorityWeight.dependsOnMethods.ordinal(), (Object)m, (Object[])new ITestNGMethod[]{dm});
                    }
                    ++n5;
                }
            }
            String[] dependentGroups = m.getGroupsDependedUpon();
            stringArray = dependentGroups;
            n6 = dependentGroups.length;
            n5 = 0;
            while (n5 < n6) {
                d = stringArray[n5];
                hasDependencies = true;
                List<ITestNGMethod> dg = dependencyMap.getMethodsThatBelongTo(d, m);
                if (dg == null) {
                    throw new TestNGException("Method \"" + m + "\" depends on nonexistent group \"" + d + "\"");
                }
                for (ITestNGMethod ddm : dg) {
                    result.addEdge(PriorityWeight.dependsOnGroups.ordinal(), (Object)m, (Object[])new ITestNGMethod[]{ddm});
                }
                ++n5;
            }
            ++n4;
        }
        if (!hasDependencies && this.getCurrentXmlTest().getParallel() == XmlSuite.ParallelMode.NONE && this.getCurrentXmlTest().getPreserveOrder().booleanValue()) {
            ListMultiMap<ITestNGMethod, ITestNGMethod> classDependencies = this.createClassDependencies(methods, this.getCurrentXmlTest());
            for (Map.Entry es : classDependencies.entrySet()) {
                for (ITestNGMethod dm : (List)es.getValue()) {
                    result.addEdge(PriorityWeight.preserveOrder.ordinal(), (Object)dm, (Object[])new ITestNGMethod[]{(ITestNGMethod)es.getKey()});
                }
            }
        }
        if (this.getCurrentXmlTest().getGroupByInstances()) {
            ListMultiMap<ITestNGMethod, ITestNGMethod> instanceDependencies = this.createInstanceDependencies(methods);
            for (Map.Entry es : instanceDependencies.entrySet()) {
                result.addEdge(PriorityWeight.groupByInstance.ordinal(), (Object)((ITestNGMethod)es.getKey()), (Iterable)es.getValue());
            }
        }
        return result;
    }

    private ListMultiMap<ITestNGMethod, ITestNGMethod> createInstanceDependencies(ITestNGMethod[] methods) {
        ListMultiMap instanceMap = Maps.newSortedListMultiMap();
        ITestNGMethod[] iTestNGMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ITestNGMethod m = iTestNGMethodArray[n2];
            instanceMap.put(m.getInstance(), (Object)m);
            ++n2;
        }
        ListMultiMap result = Maps.newListMultiMap();
        Object previousInstance = null;
        for (Map.Entry es : instanceMap.entrySet()) {
            if (previousInstance == null) {
                previousInstance = es.getKey();
                continue;
            }
            List previousMethods = (List)instanceMap.get(previousInstance);
            Object currentInstance = es.getKey();
            List currentMethods = (List)instanceMap.get(currentInstance);
            for (ITestNGMethod cm : currentMethods) {
                for (ITestNGMethod pm : previousMethods) {
                    result.put((Object)cm, (Object)pm);
                }
            }
            previousInstance = currentInstance;
        }
        return result;
    }

    private ListMultiMap<ITestNGMethod, ITestNGMethod> createClassDependencies(ITestNGMethod[] methods, XmlTest test) {
        Map classes = Maps.newHashMap();
        List sortedClasses = Lists.newArrayList();
        for (XmlClass c : test.getXmlClasses()) {
            classes.put(c.getName(), new ArrayList());
            if (sortedClasses.contains(c)) continue;
            sortedClasses.add(c);
        }
        Collections.sort(sortedClasses, new Comparator<XmlClass>(){

            @Override
            public int compare(XmlClass arg0, XmlClass arg1) {
                return arg0.getIndex() - arg1.getIndex();
            }
        });
        Map indexedClasses1 = Maps.newHashMap();
        Map indexedClasses2 = Maps.newHashMap();
        int i = 0;
        for (XmlClass c : sortedClasses) {
            indexedClasses1.put(c.getName(), i);
            indexedClasses2.put(i, c.getName());
            ++i;
        }
        ListMultiMap methodsFromClass = Maps.newListMultiMap();
        ITestNGMethod[] iTestNGMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ITestNGMethod m = iTestNGMethodArray[n2];
            methodsFromClass.put((Object)m.getTestClass().getName(), (Object)m);
            ++n2;
        }
        ListMultiMap result = Maps.newListMultiMap();
        ITestNGMethod[] iTestNGMethodArray2 = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            ITestNGMethod m = iTestNGMethodArray2[n];
            String name = m.getTestClass().getName();
            Integer index = (Integer)indexedClasses1.get(name);
            if (index != null && index > 0) {
                String classDependedUpon = (String)indexedClasses2.get(index - 1);
                List methodsDependedUpon = (List)methodsFromClass.get((Object)classDependedUpon);
                for (ITestNGMethod mdu : methodsDependedUpon) {
                    result.put((Object)mdu, (Object)m);
                }
            }
            ++n;
        }
        return result;
    }

    private void logStart() {
        this.log(3, "Running test " + this.m_testName + " on " + this.m_classMap.size() + " " + " classes, " + " included groups:[" + this.mapToString(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + this.mapToString(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass tc : this.m_classMap.values()) {
                ((TestClass)tc).dump();
            }
        }
    }

    private void fireEvent(boolean isStart) {
        for (ITestListener itl : this.m_testListeners) {
            try {
                if (isStart) {
                    itl.onStart((ITestContext)this);
                    continue;
                }
                itl.onFinish((ITestContext)this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.m_testName;
    }

    public Date getStartDate() {
        return this.m_startDate;
    }

    public Date getEndDate() {
        return this.m_endDate;
    }

    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    public String[] getIncludedGroups() {
        Map ig = this.m_xmlMethodSelector.getIncludedGroups();
        String[] result = ig.values().toArray(new String[ig.size()]);
        return result;
    }

    public String[] getExcludedGroups() {
        Map eg = this.m_xmlMethodSelector.getExcludedGroups();
        String[] result = eg.values().toArray(new String[eg.size()]);
        return result;
    }

    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    public ISuite getSuite() {
        return this.m_suite;
    }

    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    public String getHost() {
        return this.m_host;
    }

    public Collection<ITestNGMethod> getExcludedMethods() {
        Map vResult = Maps.newHashMap();
        for (ITestNGMethod m : this.m_excludedMethods) {
            vResult.put(m, m);
        }
        return vResult.keySet();
    }

    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    public void addPassedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_passedTests.addResult(tr, tm);
    }

    public Set<ITestResult> getPassedTests(ITestNGMethod tm) {
        return this.m_passedTests.getResults(tm);
    }

    public Set<ITestResult> getFailedTests(ITestNGMethod tm) {
        return this.m_failedTests.getResults(tm);
    }

    public Set<ITestResult> getSkippedTests(ITestNGMethod tm) {
        return this.m_skippedTests.getResults(tm);
    }

    public void addSkippedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_skippedTests.addResult(tr, tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvokedMethod(InvokedMethod im) {
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            this.m_invokedMethods.add(im);
        }
    }

    public void addFailedTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, false);
    }

    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, true);
    }

    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    public List<IConfigurationListener> getConfigurationListeners() {
        return Lists.newArrayList(this.m_configurationListeners);
    }

    private void logFailedTest(ITestNGMethod method, ITestResult tr, boolean withinSuccessPercentage) {
        if (withinSuccessPercentage) {
            this.m_failedButWithinSuccessPercentageTests.addResult(tr, method);
        } else {
            this.m_failedTests.addResult(tr, method);
        }
    }

    private String mapToString(Map<?, ?> m) {
        StringBuffer result = new StringBuffer();
        for (Object o : m.values()) {
            result.append(o.toString()).append(" ");
        }
        return result.toString();
    }

    private void log(int level, String s) {
        Utils.log((String)"TestRunner", (int)level, (String)s);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    private void log(String s) {
        Utils.log((String)"TestRunner", (int)2, (String)s);
    }

    @Deprecated
    public void addListener(Object listener) {
        if (listener instanceof ITestNGListener) {
            this.addListener((ITestNGListener)listener);
        }
    }

    public void addListener(ITestNGListener listener) {
        IClassListener classListener;
        if (listener instanceof IMethodInterceptor) {
            this.m_methodInterceptors.add((IMethodInterceptor)listener);
        }
        if (listener instanceof ITestListener) {
            this.addTestListener((ITestListener)listener);
        }
        if (listener instanceof IClassListener && !this.m_classListeners.containsKey((classListener = (IClassListener)listener).getClass())) {
            this.m_classListeners.put(classListener.getClass(), classListener);
        }
        if (listener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)listener);
        }
        if (listener instanceof IConfigurable) {
            this.m_configuration.setConfigurable((IConfigurable)listener);
        }
        if (listener instanceof IHookable) {
            this.m_configuration.setHookable((IHookable)listener);
        }
        if (listener instanceof IExecutionListener) {
            IExecutionListener iel = (IExecutionListener)listener;
            iel.onExecutionStart();
            this.m_configuration.addExecutionListener(iel);
        }
        this.m_suite.addListener(listener);
    }

    @Deprecated
    public void addTestListener(ITestListener il) {
        this.m_testListeners.add(il);
    }

    void addConfigurationListener(IConfigurationListener icl) {
        this.m_configurationListeners.add(icl);
    }

    private void dumpInvokedMethods() {
        System.out.println("===== Invoked methods");
        for (IInvokedMethod iInvokedMethod : this.m_invokedMethods) {
            if (iInvokedMethod.isTestMethod()) {
                System.out.print("    ");
            } else {
                if (!iInvokedMethod.isConfigurationMethod()) continue;
                System.out.print("  ");
            }
            System.out.println("" + iInvokedMethod);
        }
        System.out.println("=====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getInvokedMethods() {
        List result = Lists.newArrayList();
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            for (IInvokedMethod iInvokedMethod : this.m_invokedMethods) {
                ITestNGMethod tm = iInvokedMethod.getTestMethod();
                tm.setDate(iInvokedMethod.getDate());
                result.add(tm);
            }
        }
        return result;
    }

    @Deprecated
    public void setMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptors.add(methodInterceptor);
    }

    public void addMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptors.add(methodInterceptor);
    }

    public XmlTest getCurrentXmlTest() {
        return this.m_xmlTest;
    }

    public Object getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.m_attributes.setAttribute(name, value);
    }

    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    public Object removeAttribute(String name) {
        return this.m_attributes.removeAttribute(name);
    }

    public List<Module> getGuiceModules(Class<? extends Module> cls) {
        return (List)this.m_guiceModules.get(cls);
    }

    private void addGuiceModule(Class<? extends Module> cls, Module module) {
        this.m_guiceModules.put(cls, (Object)module);
    }

    public Injector getInjector(List<Module> moduleInstances) {
        return this.m_injectors.get(moduleInstances);
    }

    public Injector getInjector(IClass iClass) {
        Annotation annotation = AnnotationHelper.findAnnotationSuperClasses(Guice.class, (Class)iClass.getRealClass());
        if (annotation == null) {
            return null;
        }
        if (iClass instanceof TestClass) {
            iClass = ((TestClass)iClass).getIClass();
        }
        if (!(iClass instanceof ClassImpl)) {
            return null;
        }
        Guice guice = (Guice)annotation;
        Injector parentInjector = ((ClassImpl)iClass).getParentInjector();
        List moduleInstances = Lists.newArrayList((Object[])this.getModules(guice, parentInjector, iClass.getRealClass()));
        Injector injector = this.getInjector(moduleInstances);
        if (injector == null) {
            injector = parentInjector.createChildInjector((Iterable)moduleInstances);
            this.addInjector(moduleInstances, injector);
        }
        return injector;
    }

    private Module[] getModules(Guice guice, Injector parentInjector, Class<?> testClass) {
        IModuleFactory factoryInstance;
        Module moduleClass;
        List result = Lists.newArrayList();
        Class[] classArray = guice.modules();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class moduleClass2 = classArray[n2];
            List<Module> modules = this.getGuiceModules(moduleClass2);
            if (modules != null && modules.size() > 0) {
                result.addAll(modules);
            } else {
                Module instance = (Module)parentInjector.getInstance(moduleClass2);
                result.add(instance);
                this.addGuiceModule(moduleClass2, instance);
            }
            ++n2;
        }
        Class factory = guice.moduleFactory();
        if (factory != IModuleFactory.class && (moduleClass = (factoryInstance = (IModuleFactory)parentInjector.getInstance(factory)).createModule((ITestContext)this, testClass)) != null) {
            result.add(moduleClass);
        }
        return result.toArray(new Module[result.size()]);
    }

    public void addInjector(List<Module> moduleInstances, Injector injector) {
        this.m_injectors.put(moduleInstances, injector);
    }

    private class ConfigurationListener
    implements IConfigurationListener2 {
        private ConfigurationListener() {
        }

        public void beforeConfiguration(ITestResult tr) {
        }

        public void onConfigurationFailure(ITestResult itr) {
            TestRunner.this.m_failedConfigurations.addResult(itr, itr.getMethod());
        }

        public void onConfigurationSkip(ITestResult itr) {
            TestRunner.this.m_skippedConfigurations.addResult(itr, itr.getMethod());
        }

        public void onConfigurationSuccess(ITestResult itr) {
            TestRunner.this.m_passedConfigurations.addResult(itr, itr.getMethod());
        }
    }

    private static class ListenerHolder {
        private List<Class<? extends ITestNGListener>> listenerClasses;
        private Class<? extends ITestNGListenerFactory> listenerFactoryClass;

        private ListenerHolder() {
        }
    }

    private static enum PriorityWeight {
        groupByInstance,
        preserveOrder,
        priority,
        dependsOnGroups,
        dependsOnMethods;

    }
}

