/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.qmetry.qaf.automation.gson.GsonObjectDeserializer;
import com.qmetry.qaf.automation.step.StringTestStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.client.CustomStep;
import com.qmetry.qaf.automation.step.client.DataDrivenScenario;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.ScenarioFileParser;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.json.JSONException;

public abstract class AbstractScenarioFileParser
implements ScenarioFileParser {
    public static final String STEP_DEF = "STEP-DEF";
    public static final String END = "END";
    public static final String TEST_DATA = "TEST-DATA";
    public static final String SCENARIO = "SCENARIO";
    public static final String DESCRIPTION = "desc";
    protected final Log logger = LogFactoryImpl.getLog(this.getClass());
    private Gson gson = new GsonBuilder().registerTypeAdapter(Map.class, (Object)new GsonObjectDeserializer()).create();
    private List<String> includeGroups = new ArrayList<String>();
    private List<String> excludeGroups = new ArrayList<String>();

    @Override
    public void parse(String scenarioFile, List<Scenario> scenarios) {
        Collection<Object[]> statements = this.parseFile(scenarioFile);
        String reference = FileUtil.getRelativePath(scenarioFile, "./");
        this.processStatements((Object[][])statements.toArray((T[])new Object[0][0]), reference, scenarios);
    }

    @Override
    public void setExcludeGroups(List<String> excludeGroups) {
        this.excludeGroups = excludeGroups;
    }

    @Override
    public void setIncludeGroups(List<String> includeGroups) {
        this.includeGroups = includeGroups;
    }

    protected abstract Collection<Object[]> parseFile(String var1);

    protected void processStatements(Object[][] statements, String referece, List<Scenario> scenarios) {
        int statementIndex = 0;
        while (statementIndex < statements.length) {
            String type = ((String)statements[statementIndex][0]).trim();
            if (StringUtil.isBlank((String)type) || type.equalsIgnoreCase(TEST_DATA) || !type.equalsIgnoreCase(STEP_DEF) && !type.equalsIgnoreCase(SCENARIO) && !type.equalsIgnoreCase(END)) {
                String nextSteptype = "";
                while (!((nextSteptype = statements.length > ++statementIndex + 2 ? ((String)statements[statementIndex + 1][0]).trim() : END).equalsIgnoreCase(STEP_DEF) || nextSteptype.equalsIgnoreCase(SCENARIO) || nextSteptype.equalsIgnoreCase(END))) {
                }
            }
            if (type.equalsIgnoreCase(STEP_DEF)) {
                statementIndex = this.parseStepDef(statements, statementIndex, referece);
            } else if (type.equalsIgnoreCase(SCENARIO)) {
                statementIndex = this.parseScenario(statements, statementIndex, referece, scenarios);
            }
            ++statementIndex;
        }
    }

    protected int parseStepDef(Object[][] statements, int statementIndex, String referece) {
        String stepName;
        Object[] stepDef = statements[statementIndex];
        String description = stepName = stepDef.length > 1 ? ((String)stepDef[1]).trim() : "";
        int lineNo = this.getLineNum(statements, statementIndex);
        ArrayList<TestStep> steps = new ArrayList<TestStep>();
        CustomStep customStep = new CustomStep(stepName, StringUtil.isBlank((String)description) ? stepName : description, steps);
        customStep.setFileName(referece);
        customStep.setLineNumber(lineNo);
        String nextSteptype = "";
        do {
            lineNo = this.getLineNum(statements, ++statementIndex);
            String currStepName = (String)statements[statementIndex][0];
            if (currStepName.equalsIgnoreCase(END)) continue;
            StringTestStep step = new StringTestStep((String)statements[statementIndex][0], (Object[])this.gson.fromJson((String)statements[statementIndex][1], Object[].class));
            step.setResultParamName((String)statements[statementIndex][2]);
            step.setFileName(referece);
            step.setLineNumber(lineNo);
            steps.add(step);
        } while (!(nextSteptype = statements.length > statementIndex + 2 ? ((String)statements[statementIndex + 1][0]).trim() : END).equalsIgnoreCase(STEP_DEF) && !nextSteptype.equalsIgnoreCase(SCENARIO) && !nextSteptype.equalsIgnoreCase(END) && !nextSteptype.equalsIgnoreCase(TEST_DATA));
        if (stepDef.length > 2 && stepDef[2] != null) {
            try {
                String metadatastr = (String)stepDef[2];
                HashMap<String, Object> metadata = StringUtil.isBlank((String)metadatastr) ? new HashMap() : JSONUtil.toMap(metadatastr);
                customStep.setMetaData(metadata);
                if (metadata.containsKey("name")) {
                    stepName = (String)metadata.get("name");
                    customStep.setName(stepName);
                }
                if (metadata.containsKey("description")) {
                    description = (String)metadata.get("description");
                    customStep.setDescription(description);
                }
                if (metadata.containsKey("threshold")) {
                    int threshold = ((Number)metadata.get("threshold")).intValue();
                    customStep.setThreshold(threshold);
                }
            }
            catch (JSONException jSONException) {}
        }
        StringTestStep.addStep(stepName, customStep);
        return statementIndex;
    }

    protected int parseScenario(Object[][] statements, int statementIndex, String referece, List<Scenario> scenarios) {
        String description = statements[statementIndex].length > 2 ? (String)statements[statementIndex][2] : "";
        String stepName = statements[statementIndex].length > 1 ? ((String)statements[statementIndex][1]).trim() : "";
        int lineNo = this.getLineNum(statements, statementIndex);
        ArrayList<TestStep> steps = new ArrayList<TestStep>();
        TreeMap<String, Object> metadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        if (StringUtil.isNotBlank((String)description)) {
            metadata.putAll((Map)this.gson.fromJson(description, Map.class));
        }
        metadata.put("referece", referece);
        metadata.put("lineNo", lineNo);
        if (this.include(metadata)) {
            boolean dataProvider = this.hasDP(metadata);
            Scenario scenario = dataProvider ? new DataDrivenScenario(stepName, steps, metadata) : new Scenario(stepName, steps, metadata);
            scenarios.add(scenario);
        } else {
            this.logger.debug((Object)("Excluded SCENARIO - " + stepName + ":" + metadata.get(DESCRIPTION)));
        }
        String nextSteptype = "";
        do {
            lineNo = this.getLineNum(statements, ++statementIndex);
            String currStepName = (String)statements[statementIndex][0];
            if (currStepName.equalsIgnoreCase(END)) continue;
            TestStep step = this.parseStepCall(statements[statementIndex], referece, lineNo);
            steps.add(step);
        } while (!(nextSteptype = statements.length > statementIndex + 2 ? ((String)statements[statementIndex + 1][0]).trim() : END).equalsIgnoreCase(STEP_DEF) && !nextSteptype.equalsIgnoreCase(SCENARIO) && !nextSteptype.equalsIgnoreCase(END) && !nextSteptype.equalsIgnoreCase(TEST_DATA));
        return statementIndex;
    }

    protected TestStep parseStepCall(Object[] statement, String referece, int lineNo) {
        String currStepName = (String)statement[0];
        Object[] currStepArgs = null;
        try {
            currStepArgs = StringUtil.isNotBlank((String)((String)statement[1])) ? (Object[])this.gson.fromJson((String)statement[1], Object[].class) : null;
        }
        catch (JsonSyntaxException jse) {
            this.logger.error((Object)(String.valueOf(jse.getMessage()) + statement[1]), (Throwable)jse);
        }
        String currStepRes = statement.length > 2 ? (String)statement[2] : "";
        StringTestStep step = new StringTestStep(currStepName, currStepArgs);
        step.setResultParamName(currStepRes);
        step.setFileName(referece);
        step.setLineNumber(lineNo);
        return step;
    }

    private int getLineNum(Object[][] statements, int statementIndex) {
        try {
            return statements[statementIndex].length > 3 && statements[statementIndex][3] != null ? (Integer)statements[statementIndex][3] : statementIndex;
        }
        catch (Exception exception) {
            return statementIndex;
        }
    }

    protected boolean hasDP(Map<String, Object> metadata) {
        QAFDataProvider.params[] paramsArray = QAFDataProvider.params.values();
        int n = paramsArray.length;
        int n2 = 0;
        while (n2 < n) {
            QAFDataProvider.params key = paramsArray[n2];
            if (metadata.containsKey(key.name())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean include(Map<String, Object> metadata) {
        return this.include(metadata, this.includeGroups);
    }

    protected boolean include(Map<String, Object> metadata, List<String> defInclude) {
        if (metadata.containsKey("enabled") && !((Boolean)metadata.get("enabled")).booleanValue()) {
            return false;
        }
        HashSet groups = new HashSet(metadata.containsKey("groups") ? (List)metadata.get("groups") : new ArrayList());
        if (!this.includeGroups.isEmpty()) {
            groups.retainAll(this.includeGroups);
        } else {
            groups.retainAll(defInclude);
        }
        groups.removeAll(this.excludeGroups);
        return !groups.isEmpty() || this.includeGroups.isEmpty() && defInclude.isEmpty() && this.excludeGroups.isEmpty();
    }
}

