/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client;

import com.google.gson.Gson;
import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.step.BaseTestStep;
import com.qmetry.qaf.automation.step.StepExecutionTracker;
import com.qmetry.qaf.automation.step.StepInvocationException;
import com.qmetry.qaf.automation.step.StringTestStep;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.step.TestStepCompositer;
import com.qmetry.qaf.automation.step.client.text.BDDDefinitionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrSubstitutor;

public class CustomStep
extends BaseTestStep
implements TestStepCompositer {
    private Collection<TestStep> steps;
    private String def;

    public CustomStep(String name, String description, Collection<TestStep> steps) {
        super(name, description, new Object[0]);
        this.steps = steps;
        this.def = description;
    }

    @Override
    protected Object doExecute() {
        try {
            Object res = null;
            this.processStepParams();
            int executionIndx = 0;
            TestStep[] stepsToExecute = this.steps.toArray(new TestStep[this.steps.size()]);
            executionIndx = 0;
            while (executionIndx < stepsToExecute.length) {
                TestStep currTestStep = stepsToExecute[executionIndx];
                ((StringTestStep)currTestStep).initStep();
                StepExecutionTracker stepExecutionTracker = currTestStep.getStepExecutionTracker();
                if (stepExecutionTracker == null) {
                    ++executionIndx;
                    QAFTestBase stb = (QAFTestBase)TestBaseProvider.instance().get();
                    CheckpointResultBean stepResultBean = new CheckpointResultBean();
                    stepResultBean.setMessage(String.valueOf(currTestStep.getDescription()) + " :: Not Found.");
                    stepResultBean.setType(MessageTypes.Warn);
                    stb.getCheckPointResults().add(stepResultBean);
                    LoggingBean comLoggingBean = new LoggingBean(currTestStep.getName(), new String[]{Arrays.toString(currTestStep.getActualArgs())}, "Error: Step Not Found");
                    stb.getLog().add(comLoggingBean);
                    throw new StepInvocationException(currTestStep, "Test Step (" + currTestStep.getDescription() + ") Not Found.\n Please provide implementation or check 'step.provider.pkg' property value points to appropriate package.", true);
                }
                stepExecutionTracker.getContext().putAll(this.getStepExecutionTracker().getContext());
                stepExecutionTracker.getContext().put("testStepCompositer", this);
                stepExecutionTracker.setStepCompositer(this);
                stepExecutionTracker.setStepIndex(executionIndx);
                stepExecutionTracker.setNextStepIndex(++executionIndx);
                res = currTestStep.execute();
                executionIndx = stepExecutionTracker.getNextStepIndex();
            }
            return res;
        }
        catch (Throwable e) {
            throw new StepInvocationException(this, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSignature() {
        return "Custom-Step[" + this.name + ":" + this.getFileName() + "#" + this.getLineNumber() + "] - " + this.getDescription();
    }

    public void processStepParams() {
        if (this.actualArgs != null && this.actualArgs.length > 0) {
            Map<String, Object> paramMap = this.getStepExecutionTracker().getContext();
            List<String> paramNames = BDDDefinitionHelper.getArgNames(this.def);
            System.out.println(paramNames);
            int i = 0;
            while (i < this.actualArgs.length) {
                String paramName = paramNames.get(i).trim();
                paramName = paramName.substring(1, paramName.length() - 1).split(":", 2)[0];
                if (this.actualArgs[i] instanceof String) {
                    String pstr = (String)this.actualArgs[i];
                    if (pstr.startsWith("${") && pstr.endsWith("}")) {
                        String pname = pstr.substring(2, pstr.length() - 1);
                        this.actualArgs[i] = paramMap.containsKey(pstr) ? paramMap.get(pstr) : (paramMap.containsKey(pname) ? paramMap.get(pname) : (ConfigurationManager.getBundle().containsKey(pstr) ? ConfigurationManager.getBundle().getObject(pstr) : ConfigurationManager.getBundle().getObject(pname)));
                    } else if (pstr.indexOf("$") >= 0) {
                        pstr = ConfigurationManager.getBundle().getSubstitutor().replace(pstr);
                        this.actualArgs[i] = StrSubstitutor.replace((Object)pstr, paramMap);
                    }
                    BDDDefinitionHelper.ParamType ptype = BDDDefinitionHelper.ParamType.getType(pstr);
                    if (ptype.equals((Object)BDDDefinitionHelper.ParamType.MAP)) {
                        Map kv = (Map)new Gson().fromJson(pstr, Map.class);
                        paramMap.put(paramName, kv);
                        for (String key : kv.keySet()) {
                            paramMap.put(String.valueOf(paramName) + "." + key, kv.get(key));
                        }
                    } else if (ptype.equals((Object)BDDDefinitionHelper.ParamType.LIST)) {
                        List lst = (List)new Gson().fromJson(pstr, List.class);
                        paramMap.put(paramName, lst);
                        int li = 0;
                        while (li < lst.size()) {
                            paramMap.put(String.valueOf(paramName) + "[" + li + "]", lst.get(li));
                            ++li;
                        }
                    }
                }
                paramMap.put("${args[" + i + "]}", this.actualArgs[i]);
                paramMap.put("args[" + i + "]", this.actualArgs[i]);
                paramMap.put(paramName, this.actualArgs[i]);
                ++i;
            }
            this.description = StrSubstitutor.replace((Object)this.description, paramMap);
            for (TestStep step : this.steps) {
                ((StringTestStep)step).initStep();
                if (step.getActualArgs() != null && step.getActualArgs().length > 0) {
                    int j = 0;
                    while (j < step.getActualArgs().length) {
                        step.getActualArgs()[j] = paramMap.containsKey(step.getActualArgs()[j]) ? paramMap.get(step.getActualArgs()[j]) : StrSubstitutor.replace((Object)step.getActualArgs()[j], paramMap);
                        ++j;
                    }
                    continue;
                }
                if (step.getName().indexOf("$") < 0) continue;
                String name = StrSubstitutor.replace((Object)step.getName(), paramMap);
                ((BaseTestStep)step).setName(name);
            }
        }
    }

    @Override
    public TestStep clone() {
        ArrayList<TestStep> stepsClone = new ArrayList<TestStep>();
        for (TestStep ts : this.steps) {
            stepsClone.add(ts.clone());
        }
        CustomStep cloneObj = new CustomStep(this.name, this.description, stepsClone);
        cloneObj.setFileName(this.getFileName());
        cloneObj.setLineNumber(this.getLineNumber());
        cloneObj.setThreshold(this.getThreshold());
        cloneObj.setMetaData(this.getMetaData());
        if (this.actualArgs != null) {
            cloneObj.actualArgs = (Object[])this.actualArgs.clone();
        }
        return cloneObj;
    }

    @Override
    public Collection<TestStep> getSteps() {
        return this.steps;
    }
}

