/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.selenium;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ui.SeleniumTestBase;
import com.qmetry.qaf.automation.ui.selenium.IsSelenium;
import com.qmetry.qaf.automation.ui.selenium.JavaScriptHelper;
import com.qmetry.qaf.automation.util.StringUtil;
import com.thoughtworks.selenium.Wait;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaitService {
    private IsSelenium selenium;
    private final Log logger;

    public WaitService(IsSelenium selenium) {
        this.selenium = selenium;
        this.logger = LogFactory.getLog(this.getClass());
    }

    public WaitService() {
        this(new SeleniumTestBase().getDriver());
    }

    public void waitForState(ReadyState state, String ... timeout) {
        String tout = timeout != null && timeout.length > 0 && StringUtils.isNotEmpty((String)timeout[0]) ? timeout[0] : WaitService.getDefaultPageWaitTime();
        try {
            this.waitForNotState(state, String.valueOf(Integer.parseInt(tout) / 5));
        }
        catch (Throwable t) {
            this.logger.warn((Object)t.getMessage());
        }
        String expr = JavaScriptHelper.getExpression("document.readyState=='" + state.name() + "'");
        this.selenium.waitForCondition(expr, tout);
    }

    public void waitForNotState(ReadyState state, String ... timeout) {
        String tout = timeout != null && timeout.length > 0 ? timeout[0] : WaitService.getDefaultPageWaitTime();
        String expr = JavaScriptHelper.getExpression("document.readyState!='" + state.name() + "'");
        this.selenium.waitForCondition(expr, tout);
    }

    public void waitForPageToLoad() {
        this.selenium.waitForPageToLoad(WaitService.getDefaultPageWaitTime());
    }

    public void waitForPageToLoad(String timeToWait) {
        this.selenium.waitForPageToLoad(timeToWait);
    }

    public void waitForAjaxToComplete(JsToolkit kit) {
        this.selenium.waitForCondition(kit.waitCondition(), WaitService.getDefaultPageWaitTime());
    }

    public void waitForAjaxToComplete() {
        String waitCondition = "";
        JsToolkit[] jsToolkitArray = JsToolkit.values();
        int n = jsToolkitArray.length;
        int n2 = 0;
        while (n2 < n) {
            JsToolkit kit = jsToolkitArray[n2];
            waitCondition = String.valueOf(waitCondition) + (waitCondition.equalsIgnoreCase("") ? kit.waitCondition() : " && " + kit.waitCondition());
            ++n2;
        }
        waitCondition = String.valueOf(waitCondition) + " && (null == selenium.browserbot.getCurrentWindow().event)";
        try {
            this.selenium.waitForCondition(waitCondition, WaitService.getDefaultPageWaitTime());
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage());
        }
    }

    public void waitForFrameToLoad(String frameLocator) {
        this.selenium.waitForFrameToLoad(frameLocator, WaitService.getDefaultPageWaitTime());
    }

    public void waitForFrameToLoad(String frameLocator, String timeToWait) {
        this.selenium.waitForFrameToLoad(frameLocator, timeToWait);
    }

    public void waitForElementVisible(final String elementVisibleIndicator) {
        new Wait(){

            public boolean until() {
                return WaitService.this.selenium.isElementPresent(elementVisibleIndicator) && WaitService.this.selenium.isVisible(elementVisibleIndicator);
            }
        }.wait("Element is not visible", Long.parseLong(WaitService.getDefaultPageWaitTime()), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForElementEditable(final String element) {
        new Wait(){

            public boolean until() {
                return WaitService.this.selenium.isElementPresent(element) && WaitService.this.selenium.isEditable(element);
            }
        }.wait("Element is not Editable", Long.parseLong(WaitService.getDefaultPageWaitTime()), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForElementNotEditable(final String element) {
        new Wait(){

            public boolean until() {
                return WaitService.this.selenium.isElementPresent(element) && !WaitService.this.selenium.isEditable(element);
            }
        }.wait("Element is Editable", Long.parseLong(WaitService.getDefaultPageWaitTime()), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForElementInVisible(final String elementVisibleIndicator) {
        new Wait(){

            public boolean until() {
                return !WaitService.this.selenium.isVisible(elementVisibleIndicator);
            }
        }.wait("Element is visible", Long.parseLong(WaitService.getDefaultPageWaitTime()), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForElementInVisible(final String elementVisibleIndicator, String failMsg, long timeOut) {
        new Wait(){

            public boolean until() {
                return !WaitService.this.selenium.isVisible(elementVisibleIndicator);
            }
        }.wait(failMsg, timeOut, WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForCSSClassPresent(String elementVisibleIndicator, final String cssClass) {
        final String ele = StringUtil.isXpath(elementVisibleIndicator) ? StringUtil.getWellFormedXPATH(elementVisibleIndicator) : elementVisibleIndicator;
        new Wait(){

            public boolean until() {
                return WaitService.this.selenium.getAttribute(String.valueOf(ele) + "@class").contains(cssClass);
            }
        }.wait("CSS class not present", Long.parseLong(WaitService.getDefaultPageWaitTime()));
    }

    public void waitForCSSClassNotPresent(String elementVisibleIndicator, final String cssClass) {
        final String ele = StringUtil.isXpath(elementVisibleIndicator) ? StringUtil.getWellFormedXPATH(elementVisibleIndicator) : elementVisibleIndicator;
        new Wait(){

            public boolean until() {
                return !WaitService.this.selenium.getAttribute(String.valueOf(ele) + "@class").contains(cssClass);
            }
        }.wait("CSS class present", Long.parseLong(WaitService.getDefaultPageWaitTime()), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForElementNotPresent(String elementLocator) {
        this.waitForElementNotPresent(elementLocator, WaitService.getDefaultPageWaitTimeNum());
    }

    public void waitForElementNotPresent(final String elementLocator, long waitTime) {
        new Wait(){

            public boolean until() {
                return !WaitService.this.selenium.isElementPresent(elementLocator);
            }
        }.wait("Element present", waitTime, WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForElementPresent(final String element) {
        new Wait(){

            public boolean until() {
                return WaitService.this.selenium.isElementPresent(element);
            }
        }.wait("Element is not present", Long.parseLong(WaitService.getDefaultPageWaitTime()));
    }

    public void waitForTextNotPresent(final String text) {
        new Wait(){

            public boolean until() {
                return !WaitService.this.selenium.isTextPresent(text);
            }
        }.wait("Text: " + text + " present", WaitService.getDefaultPageWaitTimeNum(), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForTextNotPresent(final String loc, final String text) {
        new Wait(){

            public boolean until() {
                return !WaitService.this.selenium.getText(loc).toUpperCase().contains(text.toUpperCase());
            }
        }.wait("Text " + text + " present", WaitService.getDefaultPageWaitTimeNum(), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForTextPresent(final String loc, final String text) {
        new Wait(){

            public boolean until() {
                return WaitService.this.selenium.isElementPresent(loc) && WaitService.this.selenium.getText(loc).toUpperCase().contains(text.toUpperCase());
            }
        }.wait("Text present", WaitService.getDefaultPageWaitTimeNum(), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForTextPresent(final String text) {
        new Wait(){

            public boolean until() {
                return WaitService.this.selenium.isTextPresent(text.toUpperCase());
            }
        }.wait("Text " + text + " not present", WaitService.getDefaultPageWaitTimeNum(), WaitService.getDefaultWaitIntervalTimeNum());
    }

    public void waitForElementAttribute(String ele, String attr, String val, String timeout) {
        if (StringUtil.isXpath(ele)) {
            ele = StringUtil.getWellFormedXPATH(ele);
        }
        this.selenium.waitForCondition("var attr=selenium.getAttribute('" + ele + "@" + attr + "');attr==" + val + ";", timeout);
    }

    public void waitForElementCSSClassPresent(String ele, String cssClass, String timeout) {
        this.selenium.waitForCondition(JavaScriptHelper.getConditionforCSSClassExist(ele, cssClass), timeout);
    }

    public void waitForElementCSSClassNotPresent(String ele, String cssClass, String timeout) {
        this.selenium.waitForCondition(JavaScriptHelper.getConditionforCSSClassNotExist(ele, cssClass), timeout);
    }

    public void waitForImageToLoad(String imgLoc) {
        this.waitForElementPresent(imgLoc);
        this.selenium.waitForCondition(JavaScriptHelper.getConditionforImageLoaded(imgLoc), WaitService.getDefaultPageWaitTime());
    }

    public void waitForElementClassNamePresent(String ele, String val) {
        this.waitForElementCSSClassPresent(ele, val, WaitService.getDefaultPageWaitTime());
    }

    public void waitForElementCSSClassNotPresent(String ele, String cssClass) {
        this.waitForElementCSSClassNotPresent(ele, cssClass, WaitService.getDefaultPageWaitTime());
    }

    public static String getDefaultPageWaitTime() {
        return ConfigurationManager.getBundle().getString("selenium.wait.timeout", "5000");
    }

    public static long getDefaultPageWaitTimeNum() {
        return Long.valueOf(WaitService.getDefaultPageWaitTime());
    }

    public static String getDefaultWaitIntervalTime() {
        return ConfigurationManager.getBundle().getString("selenium.wait.interval", "1000");
    }

    public static long getDefaultWaitIntervalTimeNum() {
        return Long.valueOf(WaitService.getDefaultWaitIntervalTime());
    }

    public static enum JsToolkit {
        DOJO("dojo", "dojo.io.XMLHTTPTransport.inFlight.length==0"),
        EXTJS("Ext", "Ext.Ajax.isLoading()==false"),
        JQUERY("jQuery", "jQuery.active==0"),
        YUI("YAHOO", "YAHOO.util.Connect.isCallInProgress==false"),
        PHPJS("PHP_JS", "PHP_JS.resourceIdCounter==0"),
        PROTOTYPE("Ajax", "Ajax.activeRequestCount==0");

        String identifier;
        String expr;

        private JsToolkit(String identifier, String expr) {
            this.identifier = identifier;
            this.expr = expr;
        }

        private String IsNotPresent() {
            return "!selenium.browserbot.getCurrentWindow()." + this.identifier;
        }

        private String isAjaxCallComplete() {
            return "selenium.browserbot.getCurrentWindow()." + this.expr;
        }

        public String waitCondition() {
            return "(" + this.IsNotPresent() + " || " + this.isAjaxCallComplete() + ")";
        }

        public String waitConditionWD() {
            return "return (!" + this.identifier + " || " + this.expr + ");";
        }
    }

    public static enum ReadyState {
        complete,
        interactive,
        loading,
        uninitialized;

    }
}

