/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.util;

import com.qmetry.qaf.automation.ui.util.ExpectedCondition;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;

public class QAFWebDriverExpectedConditions {
    private QAFWebDriverExpectedConditions() {
    }

    public static ExpectedCondition<QAFExtendedWebDriver, Boolean> jsCondition(final String snippet) {
        return new ExpectedCondition<QAFExtendedWebDriver, Boolean>(){

            public Boolean apply(QAFExtendedWebDriver driver) {
                Object res = driver.executeScript(snippet, new Object[0]);
                return (Boolean)res;
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebDriver, Boolean> elementPresent(final By locator) {
        return new ExpectedCondition<QAFExtendedWebDriver, Boolean>(){

            public Boolean apply(QAFExtendedWebDriver driver) {
                try {
                    driver.findElement(locator);
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebDriver, Boolean> elementNotPresent(final By locator) {
        return new ExpectedCondition<QAFExtendedWebDriver, Boolean>(){

            public Boolean apply(QAFExtendedWebDriver driver) {
                try {
                    driver.findElement(locator);
                }
                catch (RuntimeException runtimeException) {
                    return true;
                }
                return false;
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebDriver, Alert> alertPresent() {
        return new ExpectedCondition<QAFExtendedWebDriver, Alert>(){

            public Alert apply(QAFExtendedWebDriver driver) {
                try {
                    Alert alert = driver.switchTo().alert();
                    alert.getText();
                    return alert;
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebDriver, Boolean> noOfwindowsPresent(final int count) {
        return new ExpectedCondition<QAFExtendedWebDriver, Boolean>(){

            public Boolean apply(QAFExtendedWebDriver driver) {
                try {
                    if (driver.getWindowHandles().size() >= count) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
    }

    public static ExpectedCondition<QAFExtendedWebDriver, Boolean> windowTitle(final String title) {
        return new ExpectedCondition<QAFExtendedWebDriver, Boolean>(){

            public Boolean apply(QAFExtendedWebDriver driver) {
                try {
                    return title.equalsIgnoreCase(driver.getTitle());
                }
                catch (Exception exception) {
                    return false;
                }
            }
        };
    }
}

