/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.gson.GsonDeserializerObjectWrapper;
import com.qmetry.qaf.automation.gson.ObjectWrapper;
import com.qmetry.qaf.automation.step.QAFTestStepArgumentFormatter;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang.text.StrSubstitutor;

public class QAFTestStepArgumentFormatterImpl
implements QAFTestStepArgumentFormatter<Object> {
    private static final Gson gson = new GsonBuilder().setDateFormat("dd-MM-yyyy").registerTypeAdapter(ObjectWrapper.class, (Object)new GsonDeserializerObjectWrapper()).create();

    @Override
    public Object format(Object objVal, Map<String, Object> context) {
        Class paramType = (Class)context.get("__paramType");
        if (objVal instanceof String) {
            String pstr = (String)objVal;
            if (pstr.startsWith("${") && pstr.endsWith("}")) {
                String pname = pstr.substring(2, pstr.length() - 1);
                objVal = context.containsKey(pstr) ? context.get(pstr) : (context.containsKey(pname) ? context.get(pname) : (ConfigurationManager.getBundle().containsKey(pstr) ? this.getObject(pstr, paramType) : this.getPropValue(pname, paramType)));
            } else if (pstr.indexOf("$") >= 0) {
                pstr = StrSubstitutor.replace((Object)pstr, context);
                objVal = ConfigurationManager.getBundle().getSubstitutor().replace(pstr);
            }
        }
        if (String.class.isAssignableFrom(paramType)) {
            return objVal;
        }
        try {
            String strVal = objVal instanceof String ? String.valueOf(objVal) : gson.toJson(objVal);
            strVal = ConfigurationManager.getBundle().getSubstitutor().replace(strVal);
            strVal = StrSubstitutor.replace((Object)strVal, context);
            try {
                ObjectWrapper w = (ObjectWrapper)gson.fromJson(strVal, ObjectWrapper.class);
                Object obj = w.getObject();
                try {
                    objVal = paramType.cast(obj);
                }
                catch (Exception exception) {
                    JsonElement j = gson.toJsonTree(obj);
                    objVal = gson.fromJson(j, paramType);
                }
            }
            catch (Exception exception) {
                try {
                    objVal = gson.fromJson(strVal, paramType);
                }
                catch (Exception exception2) {
                    Object oval = gson.fromJson(strVal, Object.class);
                    if (oval != null && oval instanceof List) {
                        objVal = null;
                        List lst = (List)oval;
                        if (!lst.isEmpty()) {
                            objVal = lst.get(0);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return objVal;
    }

    private Object getPropValue(String pname, Class<?> paramType) {
        Configuration o = ConfigurationManager.getBundle().subset(pname);
        if (o instanceof HierarchicalConfiguration && ((HierarchicalConfiguration)o).getRoot().getValue() == null && ((HierarchicalConfiguration)o).getRoot().getChildrenCount() > 0) {
            return new ConfigurationMap(ConfigurationManager.getBundle().subset(pname));
        }
        return this.getObject(pname, paramType);
    }

    private Object getObject(String key, Class<?> paramType) {
        Object o = ConfigurationManager.getBundle().getProperty(key);
        if (o != null && o.toString().indexOf("${") >= 0) {
            String ref = o.toString();
            if (ref.startsWith("${") && ref.toString().endsWith("}")) {
                String pname = ref.substring(2, ref.length() - 1);
                return this.getPropValue(pname, paramType);
            }
            return ConfigurationManager.getBundle().getSubstitutor().replace(ref);
        }
        if (o == null || o.getClass().isAssignableFrom(paramType)) {
            return o;
        }
        if (paramType.isArray()) {
            return ConfigurationManager.getBundle().getList(key).toArray();
        }
        if (o instanceof List) {
            return ((List)o).get(0);
        }
        return o;
    }
}

