/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client.text;

import com.google.gson.Gson;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.step.client.AbstractScenarioFileParser;
import com.qmetry.qaf.automation.step.client.Scenario;
import com.qmetry.qaf.automation.step.client.text.BehaviorScanner;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BDDFileParser2
extends AbstractScenarioFileParser {
    private static final Log logger = LogFactory.getLog(BehaviorScanner.class);
    private static final String TAG = "@";
    private static final String COMMENT_CHARS = "#!|";
    private static final String MULTI_LINE_COMMENT = "\"\"\"";
    private static final String MULTI_LINE_COMMENT_END = "COMMENT_END";
    public static final String SCENARIO_OUTELINE = "Scenario Outline";
    public static final String EXAMPLES = "EXAMPLES";
    public static final String FEATURE = "Feature";
    public static final String BACKGROUND = "Background";
    private static final List<String> DEF_INCLUDE_FOR_EXMAPLES = Arrays.asList("default");

    @Override
    protected void processStatements(Object[][] statements, String referece, List<Scenario> scenarios) {
        int statementIndex = 0;
        while (statementIndex < statements.length) {
            String type = ((String)statements[statementIndex][0]).trim();
            if (StringUtil.isBlank((String)type) || !type.equalsIgnoreCase(FEATURE) && !type.equalsIgnoreCase("SCENARIO") && !type.equalsIgnoreCase(EXAMPLES)) {
                String nextSteptype = "";
                do {
                    nextSteptype = statements.length > ++statementIndex + 2 ? ((String)statements[statementIndex][0]).trim() : "END";
                    type = nextSteptype;
                } while (!nextSteptype.equalsIgnoreCase(EXAMPLES) && !nextSteptype.equalsIgnoreCase("SCENARIO") && !nextSteptype.equalsIgnoreCase("END"));
            }
            if (type.equalsIgnoreCase("STEP-DEF")) {
                statementIndex = this.parseStepDef(statements, statementIndex, referece);
            } else if (type.equalsIgnoreCase("SCENARIO")) {
                statementIndex = this.parseScenario(statements, statementIndex, referece, scenarios);
            }
            ++statementIndex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Collection<Object[]> parseFile(String strFile) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ArrayList<Object[]> background = new ArrayList<Object[]>();
        int lineNo = 0;
        boolean bglobalTags = true;
        boolean outline = false;
        boolean isBackground = false;
        ArrayList<String> globalTags = new ArrayList<String>();
        ArrayList<String> scenarioTags = new ArrayList<String>();
        ArrayList<List<Object>> examplesTable = new ArrayList<List<Object>>();
        boolean excludeExamples = false;
        BufferedReader br = null;
        try {
            try {
                logger.info((Object)("loading feature file: " + strFile));
                File textFile = new File(strFile);
                br = new BufferedReader(new FileReader(textFile));
                String strLine = "";
                int lastScenarioIndex = 0;
                StringBuffer currLineBuffer = new StringBuffer();
                while (true) {
                    if ((strLine = br.readLine()) == null) {
                        if (rows.isEmpty()) break;
                        int lastStatementIndex = rows.size() - 1;
                        String lastStamtent = (String)((Object[])rows.get(lastStatementIndex))[0];
                        if (lastStamtent.equalsIgnoreCase(EXAMPLES)) {
                            rows.remove(lastStatementIndex);
                            lastStatementIndex = lastScenarioIndex;
                        }
                        if (!examplesTable.isEmpty()) {
                            this.setExamples((Object[])rows.get(lastStatementIndex), examplesTable);
                            examplesTable.clear();
                        }
                        break;
                    }
                    ++lineNo;
                    if (!"".equalsIgnoreCase(strLine.trim()) && !COMMENT_CHARS.contains("" + strLine.trim().charAt(0))) {
                        String currLine;
                        Object[] cols;
                        block37: {
                            currLineBuffer.append(strLine.trim());
                            cols = new Object[]{"", "", "", lineNo};
                            currLine = currLineBuffer.toString();
                            String type = this.getType(currLine);
                            if (type.equalsIgnoreCase(MULTI_LINE_COMMENT)) {
                                currLineBuffer.append("\n");
                                continue;
                            }
                            if (type.equalsIgnoreCase(MULTI_LINE_COMMENT_END)) {
                                cols[1] = new Gson().toJson((Object)new String[]{currLine.replace(MULTI_LINE_COMMENT, "")});
                            } else if (type == "") {
                                cols[0] = outline ? this.convertParam(currLine) : currLine;
                            } else {
                                isBackground = false;
                                if (type.equalsIgnoreCase(TAG)) {
                                    String[] tags = currLine.split(TAG);
                                    if (bglobalTags) {
                                        globalTags.addAll(Arrays.asList(tags));
                                    } else {
                                        scenarioTags.addAll(Arrays.asList(tags));
                                    }
                                    currLineBuffer = new StringBuffer();
                                    continue;
                                }
                                if (type.equalsIgnoreCase(BACKGROUND)) {
                                    isBackground = true;
                                    currLineBuffer = new StringBuffer();
                                    continue;
                                }
                                System.arraycopy(currLine.split(":", 2), 0, cols, 0, 2);
                                if (type.equalsIgnoreCase(EXAMPLES)) {
                                    Object[] scenario = rows.get(lastScenarioIndex);
                                    scenario[0] = "SCENARIO";
                                    Map<String, Object> tags = this.getMetaData(scenarioTags);
                                    scenarioTags.clear();
                                    List groups = (List)tags.get("groups");
                                    Map metadata = (Map)new Gson().fromJson((String)scenario[2], Map.class);
                                    if (groups.isEmpty() || this.include(tags, DEF_INCLUDE_FOR_EXMAPLES)) {
                                        excludeExamples = false;
                                        List scenariogroups = (List)metadata.get("groups");
                                        scenariogroups.addAll(groups);
                                        scenario[2] = new Gson().toJson((Object)metadata);
                                        String exampleMetadata = (String)cols[1];
                                        if (StringUtil.isNotBlank((String)exampleMetadata) && exampleMetadata.trim().startsWith("{")) {
                                            metadata.putAll((Map)new Gson().fromJson(exampleMetadata, Map.class));
                                            scenario[2] = new Gson().toJson((Object)metadata);
                                            currLineBuffer = new StringBuffer();
                                            continue;
                                        }
                                        break block37;
                                    } else {
                                        excludeExamples = true;
                                        if (!metadata.containsKey((Object)QAFDataProvider.params.JSON_DATA_TABLE)) {
                                            metadata.put(QAFDataProvider.params.JSON_DATA_TABLE.name(), "[]");
                                            scenario[2] = new Gson().toJson((Object)metadata);
                                        }
                                        currLineBuffer = new StringBuffer();
                                        continue;
                                    }
                                }
                                scenarioTags.addAll(globalTags);
                                Map<String, Object> metadata = this.getMetaData(scenarioTags);
                                cols[2] = new Gson().toJson(metadata);
                                scenarioTags.clear();
                                if (type.equalsIgnoreCase(FEATURE)) {
                                    bglobalTags = false;
                                    outline = false;
                                } else {
                                    boolean bl = outline = type.equalsIgnoreCase(SCENARIO_OUTELINE) || MetaDataScanner.hasDP(metadata);
                                }
                            }
                        }
                        if (!examplesTable.isEmpty()) {
                            String lastStamtent = (String)rows.get(rows.size() - 1)[0];
                            int lastStatementIndex = lastStamtent.equalsIgnoreCase(EXAMPLES) ? lastScenarioIndex : rows.size() - 1;
                            this.setExamples(rows.get(lastStatementIndex), examplesTable);
                            examplesTable.clear();
                            if (lastStamtent.equalsIgnoreCase(EXAMPLES)) {
                                rows.remove(rows.size() - 1);
                            }
                        }
                        if (isBackground) {
                            background.add(cols);
                        } else {
                            boolean scenarioStarted;
                            rows.add(cols);
                            boolean bl = scenarioStarted = StringUtil.indexOfIgnoreCase((String)currLine, (String)"SCENARIO") == 0;
                            if (scenarioStarted) {
                                cols[0] = "SCENARIO";
                                lastScenarioIndex = rows.size() - 1;
                                rows.addAll(background);
                                excludeExamples = false;
                            }
                        }
                        currLineBuffer = new StringBuffer();
                        continue;
                    }
                    if (!StringUtil.isNotBlank((String)strLine) || strLine.trim().charAt(0) != '|' || excludeExamples) continue;
                    this.addExample(strLine.trim(), examplesTable);
                }
            }
            catch (Exception e) {
                String strMsg = "Exception while reading BDD file: " + strFile + "#" + lineNo;
                logger.error((Object)(String.valueOf(strMsg) + e));
                throw new AutomationError(strMsg, e);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        rows.add(new Object[]{"END", "", "", lineNo + 1});
        return rows;
    }

    private void setExamples(Object[] cols, ArrayList<List<Object>> examplesTable) {
        boolean isMap = examplesTable.get(0).size() > 1;
        boolean isScenario = ((String)cols[0]).trim().equalsIgnoreCase("SCENARIO");
        ArrayList<Object> data = null;
        if (isMap || isScenario) {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList dataMapList = new ArrayList();
            for (Object entry : examplesTable.get(0)) {
                keys.add((String)entry);
            }
            int i = 1;
            while (i < examplesTable.size()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                int k = 0;
                while (k < keys.size()) {
                    Object val = examplesTable.get(i).get(k);
                    map.put((String)keys.get(k), val != null ? val.toString().trim() : null);
                    ++k;
                }
                dataMapList.add(map);
                ++i;
            }
            data = dataMapList;
        } else {
            ArrayList<Object> res = new ArrayList<Object>();
            for (List<Object> entry : examplesTable) {
                Object o = entry.get(0);
                res.add(o);
            }
            data = res;
        }
        if (isScenario) {
            Map metadata = (Map)new Gson().fromJson((String)cols[2], Map.class);
            metadata.put(QAFDataProvider.params.JSON_DATA_TABLE.name(), new Gson().toJson(data));
            cols[2] = new Gson().toJson((Object)metadata);
        } else {
            cols[0] = cols[0] + new Gson().toJson(data);
        }
    }

    private void addExample(String line, ArrayList<List<Object>> examplesTable) {
        Object[] rawData = StringUtil.parseCSV(line, '|');
        ArrayList<Object> cols = new ArrayList<Object>();
        int i = 1;
        while (i < rawData.length - 1) {
            cols.add(rawData[i]);
            ++i;
        }
        examplesTable.add(cols);
    }

    private String convertParam(String currLine) {
        return StringUtil.replace((String)StringUtil.replace((String)currLine, (String)">", (String)"}", (int)-1), (String)"<", (String)"${", (int)-1);
    }

    private String getType(String line) {
        if (StringUtil.indexOfIgnoreCase((String)line, (String)TAG) == 0) {
            return TAG;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)SCENARIO_OUTELINE) == 0) {
            return SCENARIO_OUTELINE;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)"SCENARIO") == 0) {
            return "SCENARIO";
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)"STEP-DEF") == 0) {
            return "SCENARIO";
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)EXAMPLES) == 0) {
            return EXAMPLES;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)FEATURE) == 0) {
            return FEATURE;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)BACKGROUND) == 0) {
            return BACKGROUND;
        }
        if (StringUtil.indexOfIgnoreCase((String)line, (String)MULTI_LINE_COMMENT) == 0) {
            if (StringUtil.indexOfIgnoreCase((String)line, (String)MULTI_LINE_COMMENT, (int)3) > 0) {
                return MULTI_LINE_COMMENT_END;
            }
            return MULTI_LINE_COMMENT;
        }
        return "";
    }

    private Map<String, Object> getMetaData(List<String> tags) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        ArrayList<String> groups = new ArrayList<String>();
        for (String tag : tags) {
            if (!StringUtil.isNotBlank((String)tag)) continue;
            if (tag.indexOf(":") > 0) {
                String[] keyVal = tag.trim().split(":", 2);
                metaData.put(keyVal[0], StringUtil.toObject(keyVal[1]));
                continue;
            }
            groups.add(tag.trim());
        }
        metaData.put("groups", groups);
        return metaData;
    }
}

