/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.codegeneration;

import com.qmetry.qaf.automation.step.StringTestStep;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;

public class CodeGenerator {
    private static final String LINE_BREAK = "_&";
    private static final String PKG_DECLARATION = "package ${pkg};";
    private static final String[] IMPORT_STATEMENTS = new String[]{"import static com.qmetry.qaf.automation.step.StringTestStep.execute;", "import org.testng.annotations.Test;", "import com.qmetry.qaf.automation.ui.WebDriverTestCase;"};
    private static final String CLASS_DECLARATION_STRAT = "public class ${cls} extends WebDriverTestCase {";
    private static final String CLASS_DECLARATION_END = "}";
    private static final String TEST_ANNOTATION_DECLARATION = "\t@Test(${testng.params})";
    private static final String DATAPROVIDER_ANNOTATION_DECLARATION = "\t@com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider(${dp.params})";
    private static final String METHOD_DECLARATION_STRAT = "\tpublic void \"${test}\"(){";
    private static final String METHOD_DECLARATION_END = "\t}";

    public static void generateClass(String file) {
    }

    private void generateSrc(String filePath) throws IOException {
        File file = new File(filePath);
        file.getParentFile();
        CodeGenerator.scan(new FileReader(file));
    }

    private static LinkedList<Statement> scan(Reader source) throws IOException {
        BufferedReader br = null;
        LinkedList<Statement> statements = new LinkedList<Statement>();
        String strLine = "";
        StringBuffer currLineBuffer = new StringBuffer();
        int lineNo = 0;
        try {
            br = new BufferedReader(source);
            while ((strLine = br.readLine()) != null) {
                ++lineNo;
                currLineBuffer.append(strLine.trim());
                if (!strLine.endsWith(LINE_BREAK)) {
                    statements.add(new Statement(currLineBuffer.toString(), lineNo));
                    currLineBuffer = new StringBuffer();
                    continue;
                }
                currLineBuffer.delete(currLineBuffer.length() - LINE_BREAK.length(), currLineBuffer.length());
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return statements;
    }

    static class CodeBlock {
        String text;
        int startIndex;
        String type;

        CodeBlock() {
        }

        static enum Type {
            Scenario("Scenario"),
            Statement,
            comment("#"),
            emptyLine,
            None,
            Annotation("@");

            String indicator;

            private Type() {
            }

            private Type(String indicator) {
                this.indicator = indicator;
            }
        }
    }

    static class ScanarioBlock {
        private Map<String, Object> metadata;
        private String name;
        private ArrayList<StringTestStep> steps;

        ScanarioBlock() {
        }
    }

    static class Statement {
        String text;
        int lineNo;

        public Statement(String text, int lineNo) {
            this.text = text;
            this.lineNo = lineNo;
        }

        public static enum Type {
            Annotation("@"),
            Comment("#"),
            Scenario("Scenario"),
            StepDef("Step-def"),
            End("End"),
            MetaData("Meta-data"),
            EmptyLine,
            Other;

            String indicator;

            private Type() {
            }

            private Type(String indicator) {
                this.indicator = indicator;
            }

            public static Type getType(String stmt) {
                if (StringUtil.isBlank((String)stmt)) {
                    return EmptyLine;
                }
                Type[] typeArray = Type.values();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    if (type.equals((Object)EmptyLine)) break;
                    if (StringMatcher.startsWithIgnoringCase(type.indicator).match(stmt)) {
                        return type;
                    }
                    ++n2;
                }
                return Other;
            }
        }
    }
}

