/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.WebDriverCommandLogger;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

public class LiveIsExtendedWebDriver
extends QAFExtendedWebDriver {
    private Capabilities capabilities;

    public LiveIsExtendedWebDriver(URL url, Capabilities capabilities, WebDriverCommandLogger reporter) {
        super(url, capabilities, reporter);
        this.capabilities = capabilities;
    }

    protected void startClient() {
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    protected void startSession(Capabilities desiredCapabilities) {
        String sessionId = ApplicationProperties.WEBDRIVER_REMOTE_SESSION.getStringVal((String)desiredCapabilities.asMap().get(ApplicationProperties.WEBDRIVER_REMOTE_SESSION.key)).trim();
        this.setSessionId(sessionId);
    }

    protected void startSession(Capabilities desiredCapabilities, Capabilities reqCapabilities) {
        this.startSession(desiredCapabilities);
    }

    @Override
    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        if (driverCommand.equalsIgnoreCase("quit")) {
            return new Response();
        }
        return super.execute(driverCommand, parameters);
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        return this.execute("executeScript", this.validateScriptCommand(script, args)).getValue();
    }

    @Override
    public Object executeAsyncScript(String script, Object ... args) {
        return this.execute("executeAsyncScript", this.validateScriptCommand(script, args)).getValue();
    }

    private boolean isJavaScriptEnabled() {
        return this.capabilities.isJavascriptEnabled();
    }

    private Map<String, ?> validateScriptCommand(String script, Object ... args) {
        if (!this.isJavaScriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        ImmutableMap params2 = ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
        return params2;
    }
}

