/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.core;

import com.google.common.base.Supplier;
import com.qmetry.qaf.automation.core.CheckpointResultBean;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.HtmlCheckpointResultFormatter;
import com.qmetry.qaf.automation.core.HtmlCommandLogFormatter;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.MessageTypes;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.UiDriver;
import com.qmetry.qaf.automation.ui.UiDriverFactory;
import com.qmetry.qaf.automation.ui.WebDriverTestBase;
import com.qmetry.qaf.automation.ui.util.DynamicWait;
import com.qmetry.qaf.automation.ui.util.ExpectedCondition;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.openqa.selenium.WebDriverException;
import org.testng.ITestResult;
import org.testng.Reporter;

public class QAFTestBase {
    private static final String COMMAND_LOG = "commandLog";
    private static final String CHECKPOINTS = "checkPointResults";
    private static final String CONTEXT = "qafcontext";
    private static final String VERIFICATION_ERRORS = "verificationErrors";
    public static final String SELENIUM_DEFAULT_TIMEOUT = "selenium.wait.timeout";
    private Map<String, UiDriver> driverContext;
    private final Log logger = LogFactoryImpl.getLog(QAFTestBase.class);
    private boolean prepareForShutdown;
    private String[] stb;
    private boolean alwaysCaptureScreenShot = false;
    private boolean captureScreenShotOnFailure = false;
    private String lastCapturedScreenShot;
    private String screenShotDir;
    private String reportDir;
    private PropertyUtil context = new PropertyUtil();

    protected QAFTestBase() {
        this.context.setDelimiterParsingDisabled(true);
        this.context.setProperty(COMMAND_LOG, new ArrayList());
        this.context.setProperty(CHECKPOINTS, new ArrayList());
        this.context.setProperty(VERIFICATION_ERRORS, 0);
        this.driverContext = new HashMap<String, UiDriver>();
        this.setAlwaysCaptureScreenShot(ApplicationProperties.SUCEESS_SCREENSHOT.getBoolenVal(new boolean[0]));
        this.setScreenShotDir(ApplicationProperties.SCREENSHOT_DIR.getStringVal("./img"));
        this.setReportDir(ApplicationProperties.REPORT_DIR.getStringVal("./"));
    }

    public String getHTMLFormattedLog() {
        return new HtmlCommandLogFormatter().getLog(this.getLog());
    }

    public List<LoggingBean> getLog() {
        return (List)this.getContext().getObject(COMMAND_LOG);
    }

    public String getBrowser() {
        return STBArgs.browser_str.getFrom(this.stb);
    }

    public String getDriverName() {
        return STBArgs.browser_str.getFrom(this.stb);
    }

    public void tearDown() {
        String[] drivers;
        Map<String, UiDriver> drivercontext = this.getDriverContext();
        String[] stringArray = drivers = drivercontext.keySet().toArray(new String[0]);
        int n = drivers.length;
        int n2 = 0;
        while (n2 < n) {
            String driver = stringArray[n2];
            UiDriver uiDriver = drivercontext.get(driver);
            if (uiDriver != null) {
                new UiDriverFactory().tearDown(uiDriver);
                if (this.getDriverName().equalsIgnoreCase(driver)) {
                    this.setDriver("");
                }
            }
            drivercontext.remove(driver);
            ++n2;
        }
    }

    public void tearDown(String driverName) {
        Map<String, UiDriver> drivercontext = this.getDriverContext();
        UiDriver uiDriver = drivercontext.get(driverName);
        if (uiDriver != null) {
            new UiDriverFactory().tearDown(uiDriver);
        }
        drivercontext.remove(driverName);
        if (this.getDriverName().equalsIgnoreCase(driverName)) {
            this.setDriver("");
        }
    }

    public void setDriver(String driverName) {
        this.stb = STBArgs.browser_str.set(driverName, new String[0]);
        if (StringUtil.isNotBlank((String)driverName) && this.hasDriver()) {
            UiDriverFactory.loadDriverResouces(driverName);
            UiDriver driver = this.getDriverContext().get(driverName);
            if (driver != null && driver instanceof QAFExtendedWebDriver) {
                ConfigurationManager.getBundle().setProperty("driver.actualCapabilities", ((QAFExtendedWebDriver)driver).getCapabilities().asMap());
            }
        } else {
            ConfigurationManager.getBundle().clearProperty("driver.actualCapabilities");
        }
    }

    public void setDriver(String driverName, UiDriver driver) {
        this.stb = STBArgs.browser_str.set(driverName, new String[0]);
        this.setUiDriver(driver);
    }

    public String getBaseUrl() {
        return STBArgs.base_url.getFrom(this.stb);
    }

    public boolean hasDriver(String driverName) {
        return this.getDriverContext().containsKey(driverName);
    }

    public boolean hasDriver() {
        String driverName = this.getDriverName();
        return StringUtil.isNotBlank((String)driverName) && this.hasDriver(driverName);
    }

    public UiDriver getUiDriver() {
        if (!this.hasUiDriver()) {
            this.init();
        }
        return this.getDriverContext().get(this.getDriverName());
    }

    public static void pause(long millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException interruptedException) {}
    }

    public boolean isPrepareForShutdown() {
        return this.prepareForShutdown;
    }

    public void setMethod(Method method) {
        ConfigurationManager.getBundle().addProperty(ApplicationProperties.CURRENT_TEST_NAME.key, method.getName());
    }

    public void setPrepareForShutdown(boolean prepareForShutdown) {
        this.prepareForShutdown = prepareForShutdown;
    }

    public String getLastCapturedScreenShot() {
        if (!this.hasDriver() || StringUtil.isBlank((String)this.lastCapturedScreenShot)) {
            return "";
        }
        String dir = ApplicationProperties.SCREENSHOT_RELATIVE_PATH.getStringVal(FileUtil.getReletivePath(ApplicationProperties.REPORT_DIR.getStringVal("./"), ApplicationProperties.SCREENSHOT_DIR.getStringVal("./img/")));
        if (!dir.endsWith("/")) {
            dir = String.valueOf(dir) + "/";
        }
        return String.valueOf(dir) + this.lastCapturedScreenShot;
    }

    public void setLastCapturedScreenShot(String lastCapturedScreenShot) {
        this.lastCapturedScreenShot = lastCapturedScreenShot;
    }

    public boolean isVerificationFailed() {
        return this.getVerificationErrors() > 0;
    }

    public void checkForVerificationErrors() {
        if (this.isVerificationFailed()) {
            QAFTestBase.fail(String.valueOf(this.getVerificationErrors()) + " Verification Errors");
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public void claerAssertionsLog() {
        this.clearVerificationErrors();
        this.getCheckPointResults().clear();
        this.getLog().clear();
        this.lastCapturedScreenShot = "";
    }

    public void clearVerificationErrors() {
        this.getContext().setProperty(VERIFICATION_ERRORS, 0);
    }

    public int getVerificationErrors() {
        return this.getContext().getInt(VERIFICATION_ERRORS);
    }

    public String getAssertionsLog() {
        return new HtmlCheckpointResultFormatter().getResults(this.getCheckPointResults());
    }

    public List<CheckpointResultBean> getCheckPointResults() {
        return (List)this.getContext().getObject(CHECKPOINTS);
    }

    public String getLastCapturedScreenShotFile() {
        return this.lastCapturedScreenShot;
    }

    public void setAlwaysCaptureScreenShot(boolean alwaysCaptureScreenShot) {
        this.alwaysCaptureScreenShot = alwaysCaptureScreenShot;
    }

    public String takeScreenShot() {
        if (!this.hasUiDriver()) {
            return "";
        }
        try {
            this.lastCapturedScreenShot = this.base64ImageToFile(this.getUiDriver().takeScreenShot());
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return this.lastCapturedScreenShot;
    }

    public void addVerificationError(Throwable e) {
        this.addAssertionLog(e.getMessage(), MessageTypes.Fail);
        if (!this.logger.isDebugEnabled()) {
            this.logger.error((Object)MessageTypes.Fail.formatText(e.getMessage()));
        } else {
            this.logger.debug((Object)e.getMessage(), e);
        }
    }

    public void addVerificationError(String message) {
        this.addAssertionLog(message, MessageTypes.Fail);
        this.logger.debug((Object)message);
    }

    public void addAssertionLogWithScreenShot(String msg, MessageTypes type) {
        this.takeScreenShot();
        this.addAssertionLog(msg, type);
    }

    public void addAssertionLog(String msg, MessageTypes type) {
        this.logger.debug((Object)type.formatText(msg));
        if (type.shouldReport()) {
            CheckpointResultBean bean = new CheckpointResultBean();
            bean.setMessage(msg);
            bean.setType(type);
            boolean added = this.addCheckpoint(bean);
            if (added && StringUtil.isBlank((String)this.getLastCapturedScreenShot()) && (ApplicationProperties.FAILURE_SCREENSHOT.getBoolenVal(true) && type.isFailure() || type != MessageTypes.Info && ApplicationProperties.SUCEESS_SCREENSHOT.getBoolenVal(false))) {
                this.takeScreenShot();
            }
            bean.setScreenshot(this.getLastCapturedScreenShot());
            this.setLastCapturedScreenShot("");
        }
        if (type == MessageTypes.Fail) {
            int verificationErrors = this.getVerificationErrors() + 1;
            this.getContext().setProperty(VERIFICATION_ERRORS, verificationErrors);
        }
    }

    public PropertyUtil getContext() {
        try {
            ITestResult tr = Reporter.getCurrentTestResult();
            if (tr != null) {
                PropertyUtil contextFromTr = (PropertyUtil)((Object)Reporter.getCurrentTestResult().getAttribute(CONTEXT));
                if (contextFromTr == null) {
                    Reporter.getCurrentTestResult().setAttribute(CONTEXT, (Object)this.context);
                    return this.context;
                }
                return contextFromTr;
            }
        }
        catch (Exception exception) {}
        return this.context;
    }

    protected String getReportDir() {
        return this.reportDir;
    }

    protected boolean isCaptureScreenShotOnFailure() {
        return this.captureScreenShotOnFailure;
    }

    protected void setCaptureScreenShotOnFailure(boolean captureScreetShotOnFailure) {
        this.captureScreenShotOnFailure = captureScreetShotOnFailure;
    }

    protected boolean isAlwaysCaptureScreenShot() {
        return this.alwaysCaptureScreenShot;
    }

    protected String getTestCaseName() {
        return ApplicationProperties.CURRENT_TEST_NAME.getStringVal("QAFTest");
    }

    protected void setScreenShotDir(String screenShotDir) {
        this.screenShotDir = screenShotDir;
        FileUtil.checkCreateDir(screenShotDir);
    }

    protected void setReportDir(String reportDir) {
        this.reportDir = reportDir;
    }

    protected void finalize() throws Throwable {
        this.logger.debug((Object)"Unloading TestBase, cleaning up...");
        this.tearDown();
        super.finalize();
    }

    private void init() {
        if (ApplicationProperties.DRIVER_NAME.getStringVal("").equalsIgnoreCase("")) {
            System.err.println("Driver not configured!... \nUsing " + STBArgs.browser_str.getDefaultVal() + " as default value. Please configure driver to be used using '" + ApplicationProperties.DRIVER_NAME.key + "' property");
        }
        this.stb = this.initStbArgs(new String[0]);
        this.logger.info((Object)("Initializing Driver..." + STBArgs.allToString(this.stb)));
        DriverInitExpectedCondition driverInitExpectedCondition = new DriverInitExpectedCondition((ArrayList)this.getLog(), this.stb);
        UiDriver uiDriver = new UiDriverInitializer().withTimeout(ApplicationProperties.DRIVER_INIT_TIMEOUT.getIntVal(0), TimeUnit.SECONDS).pollingEvery(10L, TimeUnit.SECONDS).withMessage(driverInitExpectedCondition).ignoring(WebDriverException.class).until(driverInitExpectedCondition);
        this.setUiDriver(uiDriver);
        this.logger.info((Object)"driver init done");
    }

    private boolean hasFailure(List<CheckpointResultBean> subSteps) {
        for (CheckpointResultBean subStep : subSteps) {
            if (!StringMatcher.containsIgnoringCase("fail").match(subStep.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean addCheckpoint(CheckpointResultBean bean) {
        CheckpointResultBean prevCheckpointResultBean;
        int checkPoints = this.getCheckPointResults().size();
        CheckpointResultBean lastCheckpoint = checkPoints > 1 ? this.getCheckPointResults().get(checkPoints - 1) : null;
        List<CheckpointResultBean> parent = MessageTypes.TestStep.name().equalsIgnoreCase(bean.getType()) || lastCheckpoint == null || !MessageTypes.TestStep.name().equalsIgnoreCase(lastCheckpoint.getType()) ? this.getCheckPointResults() : lastCheckpoint.getSubCheckPoints();
        CheckpointResultBean checkpointResultBean = prevCheckpointResultBean = !parent.isEmpty() ? parent.get(parent.size() - 1) : null;
        if (prevCheckpointResultBean == null || !prevCheckpointResultBean.equals(bean)) {
            parent.add(bean);
            if (lastCheckpoint != null && MessageTypes.TestStep.name().equalsIgnoreCase(lastCheckpoint.getType())) {
                lastCheckpoint.setType(this.hasFailure(lastCheckpoint.getSubCheckPoints()) ? MessageTypes.TestStepFail : MessageTypes.TestStepPass);
            }
            return true;
        }
        return false;
    }

    private String getScreenShotDir() {
        return this.screenShotDir;
    }

    private String base64ImageToFile(String base64Image) {
        String filename = "";
        try {
            String tcname = StringUtil.toTitleCaseIdentifier(this.getTestCaseName());
            if (tcname.length() > 25) {
                tcname.substring(0, 25);
            }
            this.lastCapturedScreenShot = filename = FileUtil.saveImageFile(base64Image, StringUtil.createRandomString(tcname), this.getScreenShotDir());
            this.logger.debug((Object)("Capturing screen shot" + this.lastCapturedScreenShot));
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in capturing screenshot\n" + e.getMessage()));
        }
        return filename;
    }

    private String[] initStbArgs(String ... args) {
        args = STBArgs.browser_str.setIfEmpty(this.getBrowser(), args);
        return STBArgs.browser_str.setIfEmpty(ApplicationProperties.DRIVER_NAME.getStringVal(STBArgs.browser_str.defaultVal), STBArgs.base_url.setIfEmpty(ApplicationProperties.SELENIUM_BASE_URL.getStringVal(STBArgs.base_url.defaultVal), STBArgs.port.setIfEmpty(ApplicationProperties.REMOTE_PORT.getStringVal(STBArgs.port.defaultVal), STBArgs.sel_server.setIfEmpty(ApplicationProperties.REMOTE_SERVER.getStringVal(STBArgs.sel_server.defaultVal), args))));
    }

    private boolean hasUiDriver() {
        return this.driverContext.get(this.getDriverName()) != null;
    }

    private void setUiDriver(UiDriver uiDriver) {
        this.driverContext.put(this.getDriverName(), uiDriver);
    }

    private Map<String, UiDriver> getDriverContext() {
        return this.driverContext;
    }

    public static void main(String[] args) {
        System.setProperty("driver.name", "chromeDriver");
        System.setProperty("webdriver.chrome.driver", "/Users/chiragjayswal/Downloads/chromedriver");
        System.setProperty("webdriver.gecko.driver", "/Users/chiragjayswal/Downloads/geckodriver");
        new WebDriverTestBase().getDriver().get("http://www.google.com");
        QAFTestBase.pause(5000L);
        System.out.println(((QAFTestBase)TestBaseProvider.instance().get()).getDriverName());
        ((QAFTestBase)TestBaseProvider.instance().get()).setDriver("chrome2Driver");
        System.out.println(((QAFTestBase)TestBaseProvider.instance().get()).getDriverName());
        new WebDriverTestBase().getDriver().get("http://www.google.com");
        new WebDriverTestBase().getDriver().findElement("name=q").sendKeys(new CharSequence[]{"firefoxDriver"});
        ((QAFTestBase)TestBaseProvider.instance().get()).setDriver("chromeDriver");
        System.out.println(((QAFTestBase)TestBaseProvider.instance().get()).getDriverName());
        new WebDriverTestBase().getDriver().findElement("name=q").sendKeys(new CharSequence[]{"chromeDriver"});
        QAFTestBase.pause(50000L);
        System.exit(0);
    }

    private class DriverInitExpectedCondition
    implements ExpectedCondition<UiDriverFactory, UiDriver>,
    Supplier<String> {
        int count = 0;
        private ArrayList<LoggingBean> commandLog;
        private String[] stb;

        public DriverInitExpectedCondition(ArrayList<LoggingBean> commandLog, String[] stb) {
            this.commandLog = commandLog;
            this.stb = stb;
        }

        public UiDriver apply(UiDriverFactory driverFectory) {
            try {
                ++this.count;
                return driverFectory.get((ArrayList)this.commandLog, this.stb);
            }
            catch (Throwable e) {
                String msg = this.get();
                System.err.println(String.valueOf(msg) + e.getMessage());
                throw new WebDriverException(msg, e.getCause());
            }
        }

        public String get() {
            return "Unable to create driver instance in " + StringUtil.toStringWithSufix(this.count) + " attempt with retry timeout of " + ApplicationProperties.DRIVER_INIT_TIMEOUT.getIntVal(0) + " seconds. You can check/set value of '" + ApplicationProperties.DRIVER_INIT_TIMEOUT.key + "' appropriately to set retry timeout on driver initialization failure.";
        }
    }

    public static enum STBArgs {
        browser_str("firefoxDriver"),
        base_url("http://localhost"),
        sel_server("localhost"),
        port("4444");

        public String defaultVal;

        private STBArgs(String def) {
            this.defaultVal = def;
        }

        public String getFrom(String ... args) {
            if (args != null && args.length > this.ordinal()) {
                return ConfigurationManager.getBundle().getSubstitutor().replace(args[this.ordinal()]);
            }
            return "";
        }

        public static String allToString(String ... args) {
            StringBuilder sb = new StringBuilder();
            STBArgs[] sTBArgsArray = STBArgs.values();
            int n = sTBArgsArray.length;
            int n2 = 0;
            while (n2 < n) {
                STBArgs arg = sTBArgsArray[n2];
                sb.append("," + arg.name() + ":" + arg.getFrom(args));
                ++n2;
            }
            return sb.substring(1);
        }

        public String[] set(String val, String ... args) {
            if (args != null && args.length > this.ordinal()) {
                args[this.ordinal()] = val;
                return args;
            }
            String[] extended = new String[STBArgs.values().length];
            extended[this.ordinal()] = val;
            if (args != null) {
                System.arraycopy(args, 0, extended, 0, args.length);
            }
            return extended;
        }

        public String[] setIfEmpty(String val, String ... args) {
            if (StringUtils.isBlank((String)this.getFrom(args))) {
                return this.set(val, args);
            }
            return args;
        }

        public String getDefaultVal() {
            return this.defaultVal;
        }
    }

    private class UiDriverInitializer
    extends DynamicWait<UiDriverFactory> {
        public UiDriverInitializer() {
            super(new UiDriverFactory());
        }
    }
}

