/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.integration;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.integration.TestCaseResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.util.PropertyUtil;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class ResultUpdator
extends Thread {
    private static final Log logger = LogFactoryImpl.getLog(ResultUpdator.class);
    private static Set<TestCaseResultUpdator> updators = ResultUpdator.registerUpdators();
    private TestCaseRunResult result;
    private TestCaseResultUpdator updator;
    private PropertyUtil context = ConfigurationManager.getBundle();
    private static boolean hasActivePool = false;
    private static boolean hasActiveSingleThreadedPool = false;

    protected ResultUpdator(TestCaseRunResult result, TestCaseResultUpdator updator) {
        this.result = result;
        if (updator.allowParallel()) {
            try {
                this.updator = (TestCaseResultUpdator)updator.getClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error((Object)e);
                this.updator = updator;
            }
        } else {
            this.updator = updator;
        }
        logger.info((Object)String.format("%s: %s", updator.getToolName(), result.getMetaData()));
    }

    @Override
    public void run() {
        try {
            logger.debug((Object)(String.valueOf(this.updator.getToolName()) + ": started to update result"));
            ConfigurationManager.setBundle(this.context);
            this.updator.updateResult(this.result);
        }
        catch (Throwable t) {
            logger.error((Object)("Unable to update result on " + this.updator.getToolName()), t);
        }
    }

    public static ThreadPoolExecutor getPool() {
        hasActivePool = true;
        return ExecutorHolder.INSTANCE;
    }

    public static ThreadPoolExecutor getSingleThreadedPool() {
        hasActiveSingleThreadedPool = true;
        return SingleTheradExecutorHolder.INSTANCE;
    }

    public static int getActiveCount() {
        if (hasActivePool) {
            ResultUpdator.getPool().getActiveCount();
        }
        if (hasActiveSingleThreadedPool) {
            ResultUpdator.getSingleThreadedPool().getActiveCount();
        }
        return 0;
    }

    public static void awaitTermination() {
        if (hasActiveSingleThreadedPool || hasActivePool) {
            ThreadPoolExecutor pool;
            if (hasActiveSingleThreadedPool) {
                pool = ResultUpdator.getSingleThreadedPool();
                ResultUpdator.awaitTermination(pool);
                hasActiveSingleThreadedPool = false;
            }
            if (hasActivePool) {
                pool = ResultUpdator.getPool();
                ResultUpdator.awaitTermination(pool);
                hasActivePool = false;
            }
            for (TestCaseResultUpdator updator : updators) {
                try {
                    updator.beforeShutDown();
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to call beforeShutDown for " + updator.getToolName()), (Throwable)e);
                }
            }
        }
    }

    private static void awaitTermination(ThreadPoolExecutor pool) {
        while (pool.getActiveCount() > 0) {
            logger.info((Object)("Result updator: Completed " + pool.getCompletedTaskCount() + " Remaining " + pool.getActiveCount() + " result to be update."));
            try {
                pool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        System.out.println("Result updator: Completed " + pool.getCompletedTaskCount() + " Remaining " + pool.getActiveCount() + " result to be update.");
        try {
            pool.shutdownNow();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static void updateResult(TestCaseRunResult result, TestCaseResultUpdator toolUpdator) {
        ResultUpdator updator = new ResultUpdator(result, toolUpdator);
        if (toolUpdator.allowConfigAndRetry() || result.isTest() && !result.willRetry()) {
            ThreadPoolExecutor executor = toolUpdator.allowParallel() ? ResultUpdator.getPool() : ResultUpdator.getSingleThreadedPool();
            executor.execute(updator);
        }
    }

    public static void updateResult(TestCaseRunResult result) {
        for (TestCaseResultUpdator updator : updators) {
            try {
                ResultUpdator.updateResult(result, updator);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to update result using " + updator.getToolName()), (Throwable)e);
            }
        }
    }

    public static int getResultUpdatorsCnt() {
        return updators.size();
    }

    private static Set<TestCaseResultUpdator> registerUpdators() {
        LinkedHashSet<TestCaseResultUpdator> allUpdators = new LinkedHashSet<TestCaseResultUpdator>();
        try {
            String[] testCaseResultUpdatorCls = ConfigurationManager.getBundle().getStringArray("result.updator");
            if (testCaseResultUpdatorCls != null) {
                String[] stringArray = testCaseResultUpdatorCls;
                int n = testCaseResultUpdatorCls.length;
                int n2 = 0;
                while (n2 < n) {
                    String updaterCls = stringArray[n2];
                    try {
                        TestCaseResultUpdator updator = (TestCaseResultUpdator)Class.forName(updaterCls).newInstance();
                        if (updator.enabled() && allUpdators.add(updator)) {
                            logger.info((Object)("Registered " + updator.getToolName()));
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            }
            ServiceLoader<TestCaseResultUpdator> testCaseResultUpdators = ServiceLoader.load(TestCaseResultUpdator.class);
            for (TestCaseResultUpdator updator : testCaseResultUpdators) {
                if (!updator.enabled() || !allUpdators.add(updator)) continue;
                logger.info((Object)("Registered " + updator.getToolName()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return allUpdators;
    }

    private static class ExecutorHolder {
        private static final ThreadPoolExecutor INSTANCE = new ThreadPoolExecutor(0, 5, 5L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());

        private ExecutorHolder() {
        }
    }

    private static class SingleTheradExecutorHolder {
        private static final ThreadPoolExecutor INSTANCE = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());

        private SingleTheradExecutorHolder() {
        }
    }
}

