/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.data.MetaData;
import com.qmetry.qaf.automation.step.BDDStepMatcherFactory;
import com.qmetry.qaf.automation.step.BaseTestStep;
import com.qmetry.qaf.automation.step.Formatter;
import com.qmetry.qaf.automation.step.ObjectFactory;
import com.qmetry.qaf.automation.step.QAFTestStep;
import com.qmetry.qaf.automation.step.QAFTestStepArgumentFormatter;
import com.qmetry.qaf.automation.step.QAFTestStepArgumentFormatterImpl;
import com.qmetry.qaf.automation.step.QAFTestStepProvider;
import com.qmetry.qaf.automation.step.StepInvocationException;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebElement;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.json.JSONException;

@XmlRootElement
public class JavaStep
extends BaseTestStep {
    public static final String ATTACH_LISTENER = "attach.javastep.listener";
    protected transient Method method;
    private Object stepProvider;
    String signature = "";
    private boolean qafStepImpl = true;

    public JavaStep(Method method) {
        this(method, "", "");
    }

    public JavaStep(Method method, String name, String description) {
        this.method = method;
        this.name = name;
        this.description = description;
        this.init();
    }

    public boolean isQafStepImpl() {
        return this.qafStepImpl;
    }

    private void init() {
        this.fileName = this.method.getDeclaringClass().getName();
        MetaData stepMetaData = ClassUtil.getAnnotation(this.method, MetaData.class);
        MetaData classMetaData = ClassUtil.getAnnotation(this.method.getDeclaringClass(), MetaData.class);
        QAFTestStep step = ClassUtil.getAnnotation(this.method, QAFTestStep.class);
        if (classMetaData != null && StringUtils.isNotBlank((String)classMetaData.value())) {
            try {
                this.metaData = JSONUtil.toMap(classMetaData.value());
            }
            catch (JSONException jSONException) {
                System.err.println(this.metaData + " is not valid json map for step meta-data");
            }
        }
        this.setMetaData();
        if (stepMetaData != null && StringUtils.isNotBlank((String)stepMetaData.value())) {
            try {
                this.metaData.putAll(JSONUtil.toMap(stepMetaData.value()));
            }
            catch (JSONException jSONException) {
                System.err.println(this.metaData + " is not valid json map for step meta-data");
            }
        }
        if (StringUtils.isBlank((String)this.name)) {
            QAFTestStepProvider provider = this.method.getDeclaringClass().getAnnotation(QAFTestStepProvider.class);
            String prefix = provider != null && StringUtils.isNotBlank((String)provider.prefix()) ? String.valueOf(provider.prefix()) + "." : "";
            this.name = String.valueOf(prefix) + (step != null && StringUtils.isNotBlank((String)step.stepName()) ? step.stepName() : this.method.getName());
        }
        if (step != null) {
            this.threshold = step.threshold();
            if (StringUtils.isNotBlank((String)step.description())) {
                this.description = step.description();
                this.qafStepImpl = true;
            }
        }
        if (StringUtils.isBlank((String)this.description)) {
            this.description = this.name;
        }
        this.stepMatcher = BDDStepMatcherFactory.getStepMatcher(this);
    }

    @Override
    protected Object doExecute() {
        try {
            Object stepProvider;
            block8: {
                stepProvider = null;
                try {
                    stepProvider = this.getStepProvider();
                }
                catch (Exception exception) {
                    if (Modifier.isStatic(this.method.getModifiers())) break block8;
                    throw new StepInvocationException((TestStep)this, "Unable to Instantiate JavaStep: " + this.getName() + Arrays.toString(this.actualArgs) + this.getSignature(), true);
                }
            }
            ((QAFTestBase)TestBaseProvider.instance().get()).getContext().setProperty(ATTACH_LISTENER, false);
            ((QAFTestBase)TestBaseProvider.instance().get()).getContext().setProperty("current.teststep", this);
            this.method.setAccessible(true);
            Object[] args = this.processArgs(this.method, this.actualArgs);
            return this.method.invoke(stepProvider, args);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StepInvocationException((TestStep)this, "Unable to invoke JavaStep with given arguments: " + this.getName() + Arrays.toString(this.actualArgs) + "\nat " + this.getSignature(), true);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new StepInvocationException((TestStep)this, "Unable to invoke JavaStep: " + this.getName() + Arrays.toString(this.actualArgs) + "\nat " + this.getSignature(), true);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new StepInvocationException(this, e.getCause());
        }
    }

    protected Object getStepProvider() throws Exception {
        return this.stepProvider == null ? ObjectFactory.INSTANCE.getObject(this.method.getDeclaringClass()) : this.stepProvider;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    protected Object[] processArgs(Method method, Object ... objects) {
        int noOfParams = method.getParameterTypes().length;
        if (noOfParams == 0) {
            return null;
        }
        Object[] params2 = new Object[noOfParams];
        Map<String, Object> context = this.getStepExecutionTracker().getContext();
        try {
            if (noOfParams == objects.length - 1 && method.getParameterTypes()[noOfParams - 1].isArray()) {
                System.arraycopy(objects, 0, params2, 0, objects.length);
                params2[noOfParams - 1] = "[]";
            } else {
                System.arraycopy(objects, 0, params2, 0, noOfParams);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Wrong number of parameters, Expected " + noOfParams + " parameters but Actual is " + (objects == null ? "0" : Integer.valueOf(objects.length)));
        }
        this.description = StrSubstitutor.replace((Object)this.description, context);
        this.description = ConfigurationManager.getBundle().getSubstitutor().replace(this.description);
        Annotation[][] paramsAnnotations = method.getParameterAnnotations();
        context.put("__method", method);
        QAFTestStepArgumentFormatterImpl defaultFormatter = new QAFTestStepArgumentFormatterImpl();
        int i = 0;
        while (i < noOfParams) {
            Class<?> paramType = method.getParameterTypes()[i];
            context.put("__paramType", paramType);
            context.put("__paramIndex", i);
            Annotation[] paramAnnotations = paramsAnnotations[i];
            Class<QAFTestStepArgumentFormatter<?>> formatter = null;
            Annotation[] annotationArray = paramAnnotations;
            int n = paramAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation paramAnnotation = annotationArray[n2];
                if (paramAnnotation instanceof Formatter) {
                    formatter = ((Formatter)paramAnnotation).value();
                }
                ++n2;
            }
            if (formatter != null) {
                try {
                    params2[i] = ((QAFTestStepArgumentFormatter)formatter.newInstance()).format(params2[i], context);
                }
                catch (InstantiationException e) {
                    throw new AutomationError("Unable to use formatter " + formatter, e);
                }
                catch (IllegalAccessException e) {
                    throw new AutomationError("Unable to use formatter " + formatter, e);
                }
            } else {
                params2[i] = defaultFormatter.format(params2[i], context);
            }
            ++i;
        }
        return params2;
    }

    @Override
    public TestStep clone() {
        JavaStep cloneObj = new JavaStep(this.method);
        if (this.actualArgs != null) {
            cloneObj.actualArgs = (Object[])this.actualArgs.clone();
        }
        this.setStepMatcher(this.getStepMatcher());
        return cloneObj;
    }

    public void getSubSteps() {
        this.method.getReturnType().isInstance(QAFWebElement.class);
    }

    private void setMetaData() {
        Annotation[] allAnnotations;
        Annotation[] annotationArray = allAnnotations = this.method.getAnnotations();
        int n = allAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (!(annotation instanceof MetaData) && !(annotation instanceof QAFTestStep)) {
                Method[] annotationMethods;
                Method[] methodArray = annotationMethods = annotation.annotationType().getDeclaredMethods();
                int n3 = annotationMethods.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method annotationMethod = methodArray[n4];
                    try {
                        Object objVal = annotationMethod.invoke((Object)annotation, new Object[0]);
                        String key = annotationMethod.getName();
                        this.metaData.put(key, objVal);
                        if (key.equalsIgnoreCase("value") && this.isTestStepAnnotation(annotation)) {
                            this.description = (String)objVal;
                            this.qafStepImpl = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private boolean isTestStepAnnotation(Annotation annotation) {
        List annotationPkgs = ConfigurationManager.getBundle().getList("step.annotation.pkgs", Arrays.asList("cucumber.api.java", "io.cucumber.java"));
        for (String pkg : annotationPkgs) {
            if (annotation.annotationType().getName().indexOf(pkg) < 0) continue;
            return true;
        }
        return false;
    }
}

