/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.qmetry.qaf.automation.step.JavaStep;
import com.qmetry.qaf.automation.step.StepInvocationException;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class WebElementStep
extends JavaStep {
    private String loc;
    private Class<?> component;

    public WebElementStep(Method method) {
        super(method);
    }

    public WebElementStep(Method method, Class<?> component) {
        super(method);
        this.component = component;
    }

    @Override
    public void setActualArgs(Object ... args) {
        if (args == null || args.length == 0) {
            return;
        }
        this.loc = (String)args[0];
        this.actualArgs = new Object[this.method.getParameterTypes().length];
        if (args.length > 1) {
            try {
                System.arraycopy(args, 1, this.actualArgs, 0, args.length - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("args: " + args.length + " method params: " + this.method.getParameterTypes().length);
                throw new StepInvocationException("Wrong number of arguments", true);
            }
        }
    }

    @Override
    protected Object getStepProvider() {
        if (this.component != null) {
            try {
                Constructor<?> con = this.component.getDeclaredConstructor(String.class);
                con.setAccessible(true);
                return con.newInstance(this.loc);
            }
            catch (Exception exception) {
                throw new StepInvocationException("Unable to initialize step: " + this.getDescription(), true);
            }
        }
        return new QAFExtendedWebElement(this.loc);
    }

    @Override
    public TestStep clone() {
        WebElementStep weStep = new WebElementStep(this.method);
        if (this.actualArgs != null) {
            weStep.actualArgs = (Object[])this.actualArgs.clone();
        }
        weStep.loc = this.loc;
        return weStep;
    }
}

