/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step.client.xml;

import com.google.gson.Gson;
import com.qmetry.qaf.automation.step.client.AbstractScenarioFileParser;
import com.qmetry.qaf.automation.step.client.ScenarioFactory;
import com.qmetry.qaf.automation.step.client.ScenarioFileParser;
import com.qmetry.qaf.automation.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class XMLScenarioFactory
extends ScenarioFactory {
    private ScenarioFileParser xmlParser;
    Gson gson = new Gson();

    public XMLScenarioFactory() {
        super(Arrays.asList("xml"));
        this.xmlParser = new XmlScenarioFileParser();
    }

    @Override
    protected ScenarioFileParser getParser() {
        return this.xmlParser;
    }

    private Object toObject(String s) {
        if (StringUtil.isNumeric((String)s)) {
            return this.gson.fromJson(s, Long.class);
        }
        if (StringUtil.startsWith((String)s, (String)"[")) {
            return this.gson.fromJson(s, List.class);
        }
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")) {
            return Boolean.valueOf(s);
        }
        return s;
    }

    public class XmlScenarioFileParser
    extends AbstractScenarioFileParser {
        @Override
        protected Collection<Object[]> parseFile(String xmlFile) {
            ArrayList<Object[]> statements = new ArrayList<Object[]>();
            try {
                XMLConfiguration processor = new XMLConfiguration(xmlFile);
                List definations = processor.getRoot().getChildren();
                for (Object definationObj : definations) {
                    ConfigurationNode defination = (ConfigurationNode)definationObj;
                    String type = defination.getName();
                    String[] entry = new String[3];
                    if (!type.equalsIgnoreCase("SCENARIO") && !type.equalsIgnoreCase("STEP-DEF")) continue;
                    entry[0] = type;
                    Map<?, ?> metaData = this.getMetaData(defination);
                    entry[1] = (String)metaData.get("name");
                    metaData.remove("name");
                    entry[2] = XMLScenarioFactory.this.gson.toJson(metaData);
                    statements.add(entry);
                    System.out.println("META-DATA:" + entry[2]);
                    this.addSteps(defination, statements);
                    statements.add(new String[]{"END", "", ""});
                }
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            return statements;
        }

        private void addSteps(ConfigurationNode defination, ArrayList<Object[]> statements) {
            for (Object o : defination.getChildren()) {
                HierarchicalConfiguration.Node stepNode = (HierarchicalConfiguration.Node)o;
                if (!stepNode.getName().equalsIgnoreCase("STEP")) continue;
                String name = this.getAttribute(stepNode, "name", null);
                String inParams = this.getAttribute(stepNode, "params", "[]");
                if (!inParams.startsWith("[")) {
                    Object[] params2 = new Object[]{XMLScenarioFactory.this.toObject(inParams)};
                    inParams = XMLScenarioFactory.this.gson.toJson((Object)params2);
                }
                String outParams = this.getAttribute(stepNode, "result", "");
                statements.add(new String[]{name, inParams, outParams});
            }
        }

        private Map<?, ?> getMetaData(ConfigurationNode defination) {
            HashMap<String, Object> metaData = new HashMap<String, Object>();
            for (Object obj : defination.getAttributes()) {
                HierarchicalConfiguration.Node node = (HierarchicalConfiguration.Node)obj;
                metaData.put(node.getName(), XMLScenarioFactory.this.toObject((String)node.getValue()));
            }
            return metaData;
        }

        private String getAttribute(HierarchicalConfiguration.Node node, String attrName, String defValue) {
            List attribute = node.getAttributes(attrName);
            if (attribute.size() > 0) {
                return (String)((HierarchicalConfiguration.Node)attribute.get(0)).getValue();
            }
            if (defValue == null) {
                throw new RuntimeException("Missing attribute " + attrName + " in " + node.getName() + " xml element");
            }
            return defValue;
        }
    }
}

