/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.dataprovider;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.testng.DataProviderException;
import com.qmetry.qaf.automation.testng.dataprovider.QAFInetrceptableDataProvider;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.json.JSONObject;
import org.testng.annotations.ITestAnnotation;

public class DataProviderUtil {
    private static final Log logger = LogFactoryImpl.getLog(DataProviderUtil.class);

    public static List<Object[]> getDataSetAsMap(String key, String file) {
        Configuration config = StringUtil.isBlank((String)file) ? ConfigurationManager.getBundle().subset(key) : new PropertyUtil(file).subset(key);
        ArrayList<Object[]> dataset = new ArrayList<Object[]>();
        if (config.isEmpty()) {
            logger.error((Object)("Missing data with key [" + key + "]. "));
            throw new DataProviderException("Not test data found with key:" + key);
        }
        int size = config.getList(config.getKeys().next().toString()).size();
        int i = 0;
        while (i < size) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Iterator iter = config.getKeys();
            while (iter.hasNext()) {
                String dataKey = String.valueOf(iter.next());
                try {
                    String value = config.getStringArray(dataKey)[i];
                    map.put(dataKey, StringUtil.toObject(value));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    logger.error((Object)("Missing entry for property " + dataKey + ". Provide value for each property (or blank) in each data set in data file."), (Throwable)e);
                    throw e;
                }
            }
            dataset.add(new Object[]{map});
            ++i;
        }
        return dataset;
    }

    public static void setQAFDataProvider(ITestAnnotation testAnnotation, Method method) {
        if (method != null && method.getParameterTypes() != null && method.getParameterTypes().length > 0) {
            String dataProvider = testAnnotation.getDataProvider();
            boolean hasDataProvider = StringUtils.isNotBlank((String)dataProvider);
            if (hasDataProvider && !dataProvider.startsWith("qaf-data-provider")) {
                HashMap<String, String> desc = new HashMap<String, String>();
                desc.put("description", testAnnotation.getDescription());
                desc.put("dataProvider", testAnnotation.getDataProvider());
                Class dpClass = testAnnotation.getDataProviderClass();
                if (dpClass != null) {
                    desc.put("dataProviderClass", dpClass.getName());
                }
                testAnnotation.setDescription(new JSONObject(desc).toString());
            }
            boolean globalParallelSetting = ConfigurationManager.getBundle().getBoolean("global.datadriven.parallel", false);
            boolean parallel = ConfigurationManager.getBundle().getBoolean(String.valueOf(method.getName()) + ".parallel", globalParallelSetting);
            dataProvider = parallel ? "qaf-data-provider-parallel" : "qaf-data-provider";
            testAnnotation.setDataProvider(dataProvider);
            testAnnotation.setDataProviderClass(QAFInetrceptableDataProvider.class);
        }
    }
}

