/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.testng.dataprovider;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.data.DataBean;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.client.TestNGScenario;
import com.qmetry.qaf.automation.testng.DataProviderException;
import com.qmetry.qaf.automation.testng.dataprovider.DataProviderUtil;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProvider;
import com.qmetry.qaf.automation.testng.dataprovider.QAFDataProviderIntercepter;
import com.qmetry.qaf.automation.util.CSVUtil;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.DatabaseUtil;
import com.qmetry.qaf.automation.util.ExcelUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.ListUtils;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.json.JSONObject;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.DataProvider;
import org.testng.internal.ClassHelper;
import org.testng.internal.Configuration;
import org.testng.internal.MethodInvocationHelper;
import org.testng.internal.annotations.IAnnotationFinder;

public class QAFInetrceptableDataProvider {
    private static final Log logger = LogFactoryImpl.getLog(QAFInetrceptableDataProvider.class);

    @DataProvider(name="qaf-data-provider-parallel", parallel=true)
    public static Iterator<Object[]> interceptedParallelDataProvider(ITestNGMethod method, ITestContext c) {
        return QAFInetrceptableDataProvider.interceptedDataProvider(method, c);
    }

    @DataProvider(name="qaf-data-provider")
    public static Iterator<Object[]> interceptedDataProvider(ITestNGMethod method, ITestContext c) {
        boolean hasCustomDataProvider;
        TestNGScenario scenario = (TestNGScenario)method;
        Map<?, ?> parameters = QAFInetrceptableDataProvider.getParameters(scenario);
        Map<String, Object> metadata = scenario.getMetaData();
        metadata.putAll(parameters);
        Set<QAFDataProviderIntercepter> intercepters = QAFInetrceptableDataProvider.getIntercepters();
        for (QAFDataProviderIntercepter intercepter : intercepters) {
            intercepter.beforeFech(scenario, c);
        }
        List<Object[]> dataList = null;
        String dataProvider = (String)metadata.get(QAFDataProvider.params.DATAPROVIDER.name());
        boolean bl = hasCustomDataProvider = dataProvider != null && !dataProvider.startsWith("qaf-data-provider");
        if (hasCustomDataProvider) {
            String dataProviderClass = (String)metadata.get(QAFDataProvider.params.DATAPROVIDERCLASS.name());
            Iterator<Object[]> testData = QAFInetrceptableDataProvider.invokeCustomDataProvider(method, c, dataProvider, dataProviderClass);
            dataList = ListUtils.toList(testData);
        } else {
            Object[][] testData = QAFInetrceptableDataProvider.getData(metadata);
            dataList = ListUtils.toList(testData);
        }
        List<Object[]> data = QAFInetrceptableDataProvider.process(scenario, dataList);
        List<Object[]> interceptedData = QAFInetrceptableDataProvider.intercept(scenario, c, data, intercepters);
        return interceptedData.iterator();
    }

    private static List<Object[]> intercept(TestNGScenario scenario, ITestContext context, List<Object[]> testdata, Set<QAFDataProviderIntercepter> intercepters) {
        for (QAFDataProviderIntercepter intercepter : intercepters) {
            testdata = intercepter.intercept(scenario, context, testdata);
        }
        int from = 1;
        int to = testdata.size();
        Map<String, Object> metadata = scenario.getMetaData();
        if (metadata.containsKey(QAFDataProvider.params.FROM.name()) || metadata.containsKey(QAFDataProvider.params.TO.name())) {
            if (metadata.containsKey(QAFDataProvider.params.TO.name()) && (Integer)metadata.get(QAFDataProvider.params.TO.name()) < to) {
                to = (Integer)metadata.get(QAFDataProvider.params.TO.name());
            }
            if (metadata.containsKey(QAFDataProvider.params.FROM.name()) && (Integer)metadata.get(QAFDataProvider.params.FROM.name()) > from) {
                from = (Integer)metadata.get(QAFDataProvider.params.FROM.name());
            }
            return testdata.subList(from - 1, to);
        }
        if (metadata.containsKey(QAFDataProvider.params.INDICES.name())) {
            List indices = (List)metadata.get(QAFDataProvider.params.INDICES.name());
            ArrayList<Object[]> filteredList = new ArrayList<Object[]>();
            for (Object i : indices) {
                filteredList.add(testdata.get((Integer)i));
            }
            return filteredList;
        }
        return testdata;
    }

    private static Map<?, ?> getParameters(TestNGScenario scenario) {
        String testParameters;
        Map<String, Object> methodParameters = scenario.getMetaData();
        String description = scenario.getDescription();
        if (StringUtils.isNotBlank((String)description) && JSONUtil.isValidJsonString(description)) {
            Map paramsFromDesc = new JSONObject(description).toMap();
            description = (String)paramsFromDesc.remove("description");
            methodParameters.putAll(paramsFromDesc);
            scenario.setDescription(description);
        }
        if (StringUtils.isBlank((String)(testParameters = QAFInetrceptableDataProvider.getConfigParameters(String.valueOf(scenario.getMethodName()) + ".testdata"))) && StringUtils.isBlank((String)(testParameters = QAFInetrceptableDataProvider.getConfigParameters("global.testdata")))) {
            testParameters = new JSONObject(methodParameters).toString();
        }
        String cls = scenario.getConstructorOrMethod().getMethod().getDeclaringClass().getSimpleName();
        String mtd = scenario.getMethodName();
        testParameters = testParameters.replace("${class}", cls);
        testParameters = testParameters.replace("${method}", mtd);
        testParameters = StrSubstitutor.replace((Object)testParameters, methodParameters);
        testParameters = ConfigurationManager.getBundle().getSubstitutor().replace(testParameters);
        try {
            return new JSONObject(testParameters).toMap();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return StringUtil.toMap(testParameters, true, new char[0]);
        }
    }

    private static List<Object[]> process(TestNGScenario scenario, List<Object[]> data) {
        Class[] paramTypes = scenario.getConstructorOrMethod().getParameterTypes();
        ArrayList<Object[]> testdata = new ArrayList<Object[]>(data);
        if (testdata != null && !testdata.isEmpty() && ((Object[])testdata.get(0)).length == 1 && Map.class.isAssignableFrom(((Object[])testdata.get(0))[0].getClass())) {
            try {
                String filter = (String)scenario.getMetaData().get("filter");
                if (StringUtil.isNotBlank((String)filter)) {
                    TreeMap<String, Object> parametes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                    parametes.putAll(scenario.getMetaData());
                    parametes.put("method", scenario.getMethodName());
                    parametes.put("class", scenario.getMethod().getDeclaringClass().getSimpleName());
                    filter = StrSubstitutor.replace((Object)filter, parametes);
                    filter = ConfigurationManager.getBundle().getSubstitutor().replace(filter);
                    logger.info((Object)("Applying Filter " + filter));
                    int i = 0;
                    Iterator iter = testdata.iterator();
                    while (iter.hasNext()) {
                        Map record = (Map)((Object[])iter.next())[0];
                        boolean include = (Boolean)StringUtil.eval(filter, record);
                        ++i;
                        if (!include) {
                            logger.debug((Object)("removing " + record));
                            iter.remove();
                            continue;
                        }
                        record.put("__baseindex", i);
                    }
                }
            }
            catch (Exception e) {
                throw new DataProviderException("Unable to apply filter on data-set", e);
            }
            int i = 0;
            while (i < testdata.size()) {
                Map record = (Map)((Object[])testdata.get(i))[0];
                if (paramTypes.length > 1) {
                    Object[] values = record.values().toArray();
                    if (paramTypes.length == values.length && paramTypes[0].isAssignableFrom(values[0].getClass())) {
                        testdata.set(i, values);
                    } else {
                        Object[] params2 = new Object[paramTypes.length];
                        int pi = 0;
                        while (pi < paramTypes.length) {
                            try {
                                if (values.length > pi && paramTypes[pi].isAssignableFrom(values[pi].getClass())) {
                                    params2[pi] = values[pi];
                                } else if (DataBean.class.isAssignableFrom(paramTypes[pi])) {
                                    DataBean bean = (DataBean)paramTypes[pi].newInstance();
                                    bean.fillData(record);
                                    params2[pi] = bean;
                                } else {
                                    Gson gson = new Gson();
                                    String seralizedObj = gson.toJson((Object)record);
                                    params2[pi] = gson.fromJson(seralizedObj, paramTypes[pi]);
                                }
                            }
                            catch (Exception e) {
                                throw new DataProviderException("Unable to populate data" + paramTypes, e);
                            }
                            ++pi;
                        }
                        testdata.set(i, params2);
                    }
                } else if (!Map.class.isAssignableFrom(paramTypes[0])) {
                    if (DataBean.class.isAssignableFrom(paramTypes[0])) {
                        try {
                            DataBean bean = (DataBean)paramTypes[0].newInstance();
                            bean.fillData(record);
                            testdata.set(i, new Object[]{bean});
                        }
                        catch (Exception e) {
                            throw new DataProviderException("Unable to populate databean", e);
                        }
                    } else {
                        Gson gson = new Gson();
                        String seralizedObj = gson.toJson((Object)record);
                        Object obj = new Gson().fromJson(seralizedObj, paramTypes[0]);
                        testdata.set(i, new Object[]{obj});
                    }
                } else {
                    record.put("__index", i + 1);
                }
                ++i;
            }
        }
        return testdata;
    }

    public static Object[][] getData(Map<String, Object> metadata) {
        String query = (String)metadata.get(QAFDataProvider.params.SQLQUERY.name());
        if (StringUtils.isNotBlank((String)query)) {
            return DatabaseUtil.getRecordDataAsMap(query);
        }
        String jsonTable = (String)metadata.get(QAFDataProvider.params.JSON_DATA_TABLE.name());
        if (StringUtils.isNotBlank((String)jsonTable)) {
            return JSONUtil.getJsonArrayOfMaps(jsonTable);
        }
        String file = (String)metadata.get(QAFDataProvider.params.DATAFILE.name());
        String key = (String)metadata.get(QAFDataProvider.params.KEY.name());
        if (StringUtils.isNotBlank((String)file)) {
            if (file.endsWith("json")) {
                return JSONUtil.getJsonArrayOfMaps(file);
            }
            if (file.endsWith("xml")) {
                List<Object[]> mapData = DataProviderUtil.getDataSetAsMap(key, file);
                return (Object[][])mapData.toArray((T[])new Object[0][]);
            }
            if (file.endsWith("xls")) {
                if (StringUtils.isNotBlank((String)key)) {
                    return ExcelUtil.getTableDataAsMap(file, (String)metadata.get(QAFDataProvider.params.KEY.name()), (String)metadata.get(QAFDataProvider.params.SHEETNAME.name()));
                }
                return ExcelUtil.getExcelDataAsMap(file, (String)metadata.get(QAFDataProvider.params.SHEETNAME.name()));
            }
            List<Object[]> csvData = CSVUtil.getCSVDataAsMap(file);
            return (Object[][])csvData.toArray((T[])new Object[0][]);
        }
        if (StringUtils.isNotBlank((String)key)) {
            List<Object[]> mapData = DataProviderUtil.getDataSetAsMap(key, "");
            return (Object[][])mapData.toArray((T[])new Object[0][]);
        }
        throw new RuntimeException("No data provider found");
    }

    private static Iterator<Object[]> invokeCustomDataProvider(ITestNGMethod tm, ITestContext c, String dp, String dpc) {
        String methodClass = tm.getConstructorOrMethod().getDeclaringClass().getName();
        if (StringUtils.isBlank((String)dpc)) {
            dpc = ConfigurationManager.getBundle().getString("global.dataproviderclass", ConfigurationManager.getBundle().getString("dataproviderclass", methodClass));
        }
        if (StringUtils.isNotBlank((String)dpc)) {
            Method m;
            try {
                m = QAFInetrceptableDataProvider.getDataProviderMethod(dp, dpc);
            }
            catch (Exception exception) {
                m = QAFInetrceptableDataProvider.getDataProviderMethod(dp, methodClass);
            }
            Object instanceToUse = m.getDeclaringClass().equals(tm.getConstructorOrMethod().getDeclaringClass()) ? tm.getInstance() : ClassHelper.newInstanceOrNull(m.getDeclaringClass());
            return InvocatoinHelper.invokeDataProvider(instanceToUse, m, tm, c, null, new Configuration().getAnnotationFinder());
        }
        throw new DataProviderException("Data-provider class not found. Please provide fully qualified class name as dataProviderClass");
    }

    private static Method getDataProviderMethod(String dp, String dpc) {
        try {
            Class<?> dpClass = Class.forName(dpc);
            Set<Method> dpMethods = ClassUtil.getAllMethodsWithAnnotation(dpClass, DataProvider.class);
            for (Method m : dpMethods) {
                DataProvider dpObj = ClassUtil.getAnnotation(m, DataProvider.class);
                if (!dp.equalsIgnoreCase(dpObj.name())) continue;
                return m;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DataProviderException("Data-provider class " + dpc + " not found. Please provide fully qualified class name as dataProviderClass");
        }
        throw new DataProviderException("Data-provider: '" + dp + "' not found in class: '" + dpc + "'. Please provide valid data provider name as dataProvider");
    }

    private static Set<QAFDataProviderIntercepter> getIntercepters() {
        String[] listners;
        LinkedHashSet<QAFDataProviderIntercepter> intercepters = new LinkedHashSet<QAFDataProviderIntercepter>();
        String[] stringArray = listners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.QAF_LISTENERS.key);
        int n = listners.length;
        int n2 = 0;
        while (n2 < n) {
            String listener = stringArray[n2];
            try {
                Class<?> listenerClass = Class.forName(listener);
                if (QAFDataProviderIntercepter.class.isAssignableFrom(listenerClass)) {
                    QAFDataProviderIntercepter intercepter = (QAFDataProviderIntercepter)listenerClass.newInstance();
                    intercepters.add(intercepter);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        return intercepters;
    }

    private static String getConfigParameters(String key) {
        if (ConfigurationManager.getBundle().containsKey(key) || !ConfigurationManager.getBundle().subset(key).isEmpty()) {
            org.apache.commons.configuration.Configuration config = ConfigurationManager.getBundle().subset(key);
            if (config.isEmpty()) {
                return ConfigurationManager.getBundle().getString(key);
            }
            return new JSONObject(ConfigurationConverter.getMap((org.apache.commons.configuration.Configuration)config)).toString();
        }
        return "";
    }

    private static class InvocatoinHelper
    extends MethodInvocationHelper {
        private InvocatoinHelper() {
        }

        protected static Iterator<Object[]> invokeDataProvider(Object instance, Method dataProvider, ITestNGMethod method, ITestContext testContext, Object fedInstance, IAnnotationFinder annotationFinder) {
            return MethodInvocationHelper.invokeDataProvider((Object)instance, (Method)dataProvider, (ITestNGMethod)method, (ITestContext)testContext, (Object)fedInstance, (IAnnotationFinder)annotationFinder);
        }
    }
}

