/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.DriverFactory;
import com.qmetry.qaf.automation.core.LoggingBean;
import com.qmetry.qaf.automation.core.QAFListener;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.UiDriver;
import com.qmetry.qaf.automation.ui.WebDriverCommandLogger;
import com.qmetry.qaf.automation.ui.selenium.webdriver.SeleniumDriverFactory;
import com.qmetry.qaf.automation.ui.webdriver.ChromeDriverHelper;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.ui.webdriver.QAFWebDriverCommandListener;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class UiDriverFactory
implements DriverFactory<UiDriver> {
    private static final Log logger = LogFactoryImpl.getLog(UiDriverFactory.class);

    @Override
    public UiDriver get(ArrayList<LoggingBean> commandLog, String[] stb) {
        WebDriverCommandLogger cmdLogger = new WebDriverCommandLogger(commandLog);
        String browser = QAFTestBase.STBArgs.browser_str.getFrom(stb);
        logger.info((Object)("Driver: " + browser));
        if (browser.toLowerCase().contains("driver") && !browser.startsWith("*")) {
            return UiDriverFactory.getDriver(cmdLogger, stb);
        }
        return new SeleniumDriverFactory().getDriver(cmdLogger, stb);
    }

    @Override
    public void tearDown(UiDriver driver) {
        try {
            driver.stop();
            logger.info((Object)"UI-driver tear down complete...");
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage());
        }
    }

    public static DesiredCapabilities getDesiredCapabilities(String driverName) {
        return Browsers.getBrowser(driverName).getDesiredCapabilities();
    }

    public static String[] checkAndStartServer(String ... args) {
        if (!UiDriverFactory.isServerRequired(args)) {
            return args;
        }
        if (UiDriverFactory.isSeverRunning(QAFTestBase.STBArgs.sel_server.getFrom(args), Integer.parseInt(QAFTestBase.STBArgs.port.getFrom(args)))) {
            return args;
        }
        args = QAFTestBase.STBArgs.sel_server.set(QAFTestBase.STBArgs.sel_server.getDefaultVal(), args);
        if (UiDriverFactory.isSeverRunning(QAFTestBase.STBArgs.sel_server.getFrom(args), Integer.parseInt(QAFTestBase.STBArgs.port.getFrom(args)))) {
            logger.info((Object)"Assigning server running on localhost");
            return args;
        }
        return args;
    }

    private static boolean isServerRequired(String ... args) {
        String browser = QAFTestBase.STBArgs.browser_str.getFrom(args).toLowerCase();
        return browser.contains("*") || browser.contains("remote");
    }

    private static boolean isSeverRunning(String host, int port) {
        boolean isRunning;
        block14: {
            isRunning = false;
            Socket socket = null;
            try {
                try {
                    socket = new Socket(host, port);
                    isRunning = socket.isConnected();
                }
                catch (Exception exp) {
                    logger.error((Object)("Error occured while checking Selenium : " + exp.getMessage()));
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
        return isRunning;
    }

    private static void beforeInitialize(Capabilities desiredCapabilities, Collection<QAFWebDriverCommandListener> listners) {
        if (listners != null && !listners.isEmpty()) {
            for (QAFWebDriverCommandListener listener : listners) {
                listener.beforeInitialize(desiredCapabilities);
            }
        }
    }

    private static void onInitializationFailure(Capabilities desiredCapabilities, Throwable e, Collection<QAFWebDriverCommandListener> listners) {
        if (listners != null && !listners.isEmpty()) {
            for (QAFWebDriverCommandListener listener : listners) {
                listener.onInitializationFailure(desiredCapabilities, e);
            }
        }
    }

    private static Collection<QAFWebDriverCommandListener> getDriverListeners() {
        QAFListener cls;
        String[] clistners;
        LinkedHashSet<QAFWebDriverCommandListener> listners = new LinkedHashSet<QAFWebDriverCommandListener>();
        String[] stringArray = clistners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.WEBDRIVER_COMMAND_LISTENERS.key);
        int n = clistners.length;
        int n2 = 0;
        while (n2 < n) {
            String listenr = stringArray[n2];
            try {
                cls = (QAFWebDriverCommandListener)Class.forName(listenr).newInstance();
                listners.add((QAFWebDriverCommandListener)cls);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to register listener class " + listenr), (Throwable)e);
            }
            ++n2;
        }
        stringArray = clistners = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.QAF_LISTENERS.key);
        n = clistners.length;
        n2 = 0;
        while (n2 < n) {
            String listener = stringArray[n2];
            try {
                cls = (QAFListener)Class.forName(listener).newInstance();
                if (QAFWebDriverCommandListener.class.isAssignableFrom(cls.getClass())) {
                    listners.add((QAFWebDriverCommandListener)cls);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Unable to register class as driver listener:  " + listener), (Throwable)e);
            }
            ++n2;
        }
        return listners;
    }

    private static QAFExtendedWebDriver getDriver(WebDriverCommandLogger reporter, String ... args) {
        String b = QAFTestBase.STBArgs.browser_str.getFrom(args).toLowerCase();
        String urlStr = QAFTestBase.STBArgs.sel_server.getFrom(args).startsWith("http") ? QAFTestBase.STBArgs.sel_server.getFrom(args) : String.format("http://%s:%s/wd/hub", QAFTestBase.STBArgs.sel_server.getFrom(args), QAFTestBase.STBArgs.port.getFrom(args));
        Browsers browser = Browsers.getBrowser(b);
        UiDriverFactory.loadDriverResouces(browser);
        ConfigurationManager.getBundle().setProperty("driver.desiredCapabilities", browser.getDesiredCapabilities().asMap());
        QAFExtendedWebDriver driver = b.contains("remote") ? browser.getDriver(urlStr, reporter) : browser.getDriver(reporter, urlStr);
        ConfigurationManager.getBundle().setProperty("driver.actualCapabilities", driver.getCapabilities().asMap());
        return driver;
    }

    private static void loadDriverResouces(Browsers browser) {
        String driverResourcesKey = String.format(ApplicationProperties.DRIVER_RESOURCES_FORMAT.key, browser.browserName);
        String driverResources = ConfigurationManager.getBundle().getString(driverResourcesKey, "");
        if (StringUtil.isNotBlank((String)driverResources)) {
            ConfigurationManager.addBundle(driverResources);
        }
    }

    public static void loadDriverResouces(String driverName) {
        Browsers browser = Browsers.getBrowser(driverName);
        UiDriverFactory.loadDriverResouces(browser);
    }

    private static WebDriver getDriverObj(Class<? extends WebDriver> of, Capabilities capabilities, String urlStr) {
        try {
            Constructor<? extends WebDriver> constructor = of.getConstructor(URL.class, Capabilities.class);
            return constructor.newInstance(new URL(urlStr), capabilities);
        }
        catch (Exception exception) {
            try {
                Constructor<? extends WebDriver> constructor = of.getConstructor(Capabilities.class);
                return constructor.newInstance(capabilities);
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof WebDriverException) {
                    throw (WebDriverException)e.getCause();
                }
                try {
                    return of.newInstance();
                }
                catch (Exception exception2) {
                    try {
                        Constructor<? extends WebDriver> constructor = of.getConstructor(URL.class, Capabilities.class);
                        return constructor.newInstance(new URL(urlStr), capabilities);
                    }
                    catch (InvocationTargetException e2) {
                        throw new WebDriverException(e2.getTargetException());
                    }
                    catch (InstantiationException e2) {
                        throw new WebDriverException((Throwable)e2);
                    }
                    catch (IllegalAccessException e2) {
                        throw new WebDriverException((Throwable)e2);
                    }
                    catch (IllegalArgumentException e2) {
                        throw new WebDriverException((Throwable)e2);
                    }
                    catch (MalformedURLException e2) {
                        throw new WebDriverException((Throwable)e2);
                    }
                    catch (NoSuchMethodException e2) {
                        throw new WebDriverException((Throwable)e2);
                    }
                    catch (SecurityException e2) {
                        throw new WebDriverException((Throwable)e2);
                    }
                }
            }
        }
    }

    private static enum Browsers {
        edge((Capabilities)DesiredCapabilities.edge(), EdgeDriver.class),
        firefox((Capabilities)DesiredCapabilities.firefox(), FirefoxDriver.class),
        iexplorer((Capabilities)DesiredCapabilities.internetExplorer(), InternetExplorerDriver.class),
        chrome((Capabilities)DesiredCapabilities.chrome(), ChromeDriver.class),
        opera((Capabilities)DesiredCapabilities.operaBlink(), "com.opera.core.systems.OperaDriver"),
        android((Capabilities)new DesiredCapabilities("android", "", Platform.ANDROID), "org.openqa.selenium.android.AndroidDriver"),
        iphone((Capabilities)new DesiredCapabilities("iPhone", "", Platform.MAC), "org.openqa.selenium.iphone.IPhoneDriver"),
        ipad((Capabilities)new DesiredCapabilities("iPad", "", Platform.MAC), "org.openqa.selenium.iphone.IPhoneDriver"),
        safari((Capabilities)DesiredCapabilities.safari(), "org.openqa.selenium.safari.SafariDriver"),
        appium((Capabilities)new DesiredCapabilities(), "io.appium.java_client.AppiumDriver"),
        perfecto((Capabilities)new DesiredCapabilities()),
        other((Capabilities)new DesiredCapabilities());

        private DesiredCapabilities desiredCapabilities;
        private Class<? extends WebDriver> driverCls = null;
        private String browserName = this.name();

        private Browsers(Capabilities desiredCapabilities) {
            this.desiredCapabilities = new DesiredCapabilities(desiredCapabilities.asMap());
            this.desiredCapabilities.setCapability("javascriptEnabled", true);
            this.desiredCapabilities.setCapability("takesScreenshot", true);
            this.desiredCapabilities.setCapability("cssSelectorsEnabled", true);
        }

        private Browsers(Capabilities desiredCapabilities, String drivercls) {
            this(desiredCapabilities);
            if (this.driverCls == null) {
                try {
                    this.driverCls = Class.forName(drivercls);
                }
                catch (Exception exception) {}
            }
        }

        private Browsers(Capabilities desiredCapabilities, Class<? extends WebDriver> driver) {
            this(desiredCapabilities);
            if (this.driverCls == null) {
                this.driverCls = driver;
            }
        }

        private DesiredCapabilities getDesiredCapabilities() {
            HashMap<String, String> capabilities = new HashMap<String, String>(this.desiredCapabilities.asMap());
            Gson gson = new GsonBuilder().create();
            Map extraCapabilities = (Map)gson.fromJson(ApplicationProperties.DRIVER_ADDITIONAL_CAPABILITIES.getStringVal("{}"), Map.class);
            capabilities.putAll(extraCapabilities);
            Configuration config = ConfigurationManager.getBundle().subset(ApplicationProperties.DRIVER_CAPABILITY_PREFIX.key);
            capabilities.putAll((Map<String, String>)new ConfigurationMap(config));
            String driverCapsKey = String.format(ApplicationProperties.DRIVER_ADDITIONAL_CAPABILITIES_FORMAT.key, this.browserName);
            extraCapabilities = (Map)gson.fromJson(ConfigurationManager.getBundle().getString(driverCapsKey, "{}"), Map.class);
            capabilities.putAll(extraCapabilities);
            String driverCapKey = String.format(ApplicationProperties.DRIVER_CAPABILITY_PREFIX_FORMAT.key, this.browserName);
            config = ConfigurationManager.getBundle().subset(driverCapKey);
            capabilities.putAll((Map<String, String>)new ConfigurationMap(config));
            Object driverclass = capabilities.get(ApplicationProperties.CAPABILITY_NAME_DRIVER_CLASS.key);
            if (driverclass == null) {
                driverclass = capabilities.get("driver.class");
            }
            if (driverclass != null) {
                try {
                    this.driverCls = Class.forName(String.valueOf(driverclass));
                }
                catch (Exception exception) {}
            }
            for (String key : capabilities.keySet()) {
                Object value = capabilities.get(key);
                if (!(value instanceof String)) continue;
                capabilities.put(key, ConfigurationManager.getBundle().getSubstitutor().replace(value));
            }
            return new DesiredCapabilities(capabilities);
        }

        private static Browsers getBrowser(String name) {
            Browsers[] browsersArray = Browsers.values();
            int n = browsersArray.length;
            int n2 = 0;
            while (n2 < n) {
                Browsers browser = browsersArray[n2];
                if (name.contains(browser.name())) {
                    browser.setBrowserName(name);
                    return browser;
                }
                ++n2;
            }
            Browsers b = other;
            b.setBrowserName(name);
            return b;
        }

        private void setBrowserName(String name) {
            this.browserName = name.replaceAll("(?i)remote|driver", "");
        }

        private QAFExtendedWebDriver getDriver(WebDriverCommandLogger reporter, String urlstr) {
            DesiredCapabilities desiredCapabilities = this.getDesiredCapabilities();
            Collection listners = UiDriverFactory.getDriverListeners();
            UiDriverFactory.beforeInitialize((Capabilities)desiredCapabilities, listners);
            try {
                if (this.name().equalsIgnoreCase("chrome")) {
                    return new QAFExtendedWebDriver(ChromeDriverHelper.getService().getUrl(), (Capabilities)desiredCapabilities, reporter);
                }
                WebDriver driver = UiDriverFactory.getDriverObj(this.driverCls, (Capabilities)desiredCapabilities, urlstr);
                return new QAFExtendedWebDriver(driver, reporter);
            }
            catch (Throwable e) {
                UiDriverFactory.onInitializationFailure((Capabilities)desiredCapabilities, e, listners);
                throw new AutomationError("Unable to Create Driver Instance for " + this.browserName + ": " + e.getMessage(), e);
            }
        }

        private QAFExtendedWebDriver getDriver(String url, WebDriverCommandLogger reporter) {
            DesiredCapabilities desiredCapabilities = this.getDesiredCapabilities();
            Collection listners = UiDriverFactory.getDriverListeners();
            UiDriverFactory.beforeInitialize((Capabilities)desiredCapabilities, listners);
            try {
                if (StringUtil.isNotBlank((String)ApplicationProperties.WEBDRIVER_REMOTE_SESSION.getStringVal(new String[0])) || desiredCapabilities.asMap().containsKey(ApplicationProperties.WEBDRIVER_REMOTE_SESSION.key)) {
                    Constructor<?> constructor = Class.forName("com.qmetry.qaf.automation.ui.webdriver.LiveIsExtendedWebDriver").getDeclaredConstructor(URL.class, Capabilities.class, WebDriverCommandLogger.class);
                    return (QAFExtendedWebDriver)constructor.newInstance(new URL(url), desiredCapabilities, reporter);
                }
                return new QAFExtendedWebDriver(new URL(url), (Capabilities)desiredCapabilities, reporter);
            }
            catch (Throwable e) {
                UiDriverFactory.onInitializationFailure((Capabilities)desiredCapabilities, e, listners);
                throw new AutomationError("Unable to Create Driver Instance " + e.getMessage(), e);
            }
        }
    }
}

