/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.ui.WebDriverCommandLogger;
import com.qmetry.qaf.automation.ui.webdriver.QAFExtendedWebDriver;
import com.qmetry.qaf.automation.util.ClassUtil;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.Response;

public class LiveIsExtendedWebDriver
extends QAFExtendedWebDriver {
    private Capabilities capabilities;

    public LiveIsExtendedWebDriver(URL url, Capabilities capabilities, WebDriverCommandLogger reporter) {
        super(url, capabilities, reporter);
        this.capabilities = capabilities;
    }

    protected void startClient() {
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    protected void startSession(Capabilities desiredCapabilities) {
        String sessionId = ApplicationProperties.WEBDRIVER_REMOTE_SESSION.getStringVal((String)desiredCapabilities.asMap().get(ApplicationProperties.WEBDRIVER_REMOTE_SESSION.key)).trim();
        this.setSessionId(sessionId);
        this.setCodec();
    }

    protected void startSession(Capabilities desiredCapabilities, Capabilities reqCapabilities) {
        this.startSession(desiredCapabilities);
    }

    @Override
    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        if (driverCommand.equalsIgnoreCase("quit")) {
            return new Response();
        }
        return super.execute(driverCommand, parameters);
    }

    private void setCodec() {
        try {
            CommandExecutor executor = this.getCommandExecutor();
            ClassUtil.setField("commandCodec", executor, Dialect.W3C.getCommandCodec());
            ClassUtil.setField("responseCodec", executor, Dialect.W3C.getResponseCodec());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to set W3C codec", (Throwable)e);
        }
    }
}

