/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.ClassUtils;

public final class ClassUtil {
    private static final String CLASS_SUFIX = ".class";
    private static final String PROTOCOL_JAR = "jar";
    private static final Set<Class<?>> WRAPPER_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, String.class));

    public static Set<Method> getAllMethodsWithAnnotation(String packageName, Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        try {
            for (Class<?> cls : ClassUtil.getClasses(packageName)) {
                methods.addAll(ClassUtil.getAllMethodsWithAnnotation(cls, annotation));
            }
        }
        catch (SecurityException e) {
            System.err.println("ClassUtil.getAllMethodsWithAnnotation: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("ClassUtil.getAllMethodsWithAnnotation: " + e.getMessage());
        }
        return methods;
    }

    public static Set<Method> getAllMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        try {
            Method method;
            Method[] methodArray = cls.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                method = methodArray[n2];
                if (ClassUtil.hasAnnotation(method, annotation)) {
                    methods.add(method);
                }
                ++n2;
            }
            methodArray = cls.getMethods();
            n = methodArray.length;
            n2 = 0;
            while (n2 < n) {
                method = methodArray[n2];
                if (ClassUtil.hasAnnotation(method, annotation)) {
                    methods.add(method);
                }
                ++n2;
            }
        }
        catch (SecurityException e) {
            System.err.println("ClassUtil.getAllMethodsWithAnnotation: " + e.getMessage());
        }
        return methods;
    }

    public static boolean hasAnnotation(Method method, Class<? extends Annotation> annotation) {
        Class<?>[] intfaces;
        if (method.isAnnotationPresent(annotation)) {
            return true;
        }
        Class<?>[] classArray = intfaces = method.getDeclaringClass().getInterfaces();
        int n = intfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intface = classArray[n2];
            try {
                if (intface.getMethod(method.getName(), method.getParameterTypes()).isAnnotationPresent(annotation)) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {}
            ++n2;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotation) {
        Class<?>[] intfaces;
        if (method.isAnnotationPresent(annotation)) {
            return method.getAnnotation(annotation);
        }
        Class<?>[] classArray = intfaces = method.getDeclaringClass().getInterfaces();
        int n = intfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intface = classArray[n2];
            try {
                Method iMethod = intface.getMethod(method.getName(), method.getParameterTypes());
                if (iMethod.isAnnotationPresent(annotation)) {
                    return iMethod.getAnnotation(annotation);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {}
            ++n2;
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotation) {
        Class<?>[] intfaces;
        if (clazz.isAnnotationPresent(annotation)) {
            return clazz.getAnnotation(annotation);
        }
        Class<?>[] classArray = intfaces = clazz.getInterfaces();
        int n = intfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intface = classArray[n2];
            try {
                if (intface.isAnnotationPresent(annotation)) {
                    return intface.getAnnotation(annotation);
                }
            }
            catch (SecurityException securityException) {}
            ++n2;
        }
        return null;
    }

    public static List<Class<?>> getClasses(String pkg) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = pkg.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList classes = new ArrayList();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (resource.getProtocol().equalsIgnoreCase(PROTOCOL_JAR)) {
                try {
                    classes.addAll(ClassUtil.getClassesFromJar(resource, pkg));
                }
                catch (IOException iOException) {
                    System.err.println("Unable to get classes from jar: " + resource);
                }
                continue;
            }
            try {
                classes.addAll(ClassUtil.getClasses(new File(resource.toURI()), pkg));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return classes;
    }

    private static List<Class<?>> getClassesFromJar(URL jar, String pkg) throws IOException {
        ArrayList classes = new ArrayList();
        String jarFileName = URLDecoder.decode(jar.getFile(), "UTF-8");
        jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
        JarFile jf = new JarFile(jarFileName);
        Enumeration<JarEntry> jarEntries = jf.entries();
        while (jarEntries.hasMoreElements()) {
            String entryName = jarEntries.nextElement().getName().replace("/", ".");
            if (!entryName.startsWith(pkg) || !entryName.endsWith(CLASS_SUFIX)) continue;
            entryName = entryName.substring(0, entryName.lastIndexOf(46));
            try {
                classes.add(Class.forName(entryName));
            }
            catch (Throwable throwable) {
                System.err.println("Unable to get class " + entryName + " from jar " + jarFileName);
            }
        }
        jf.close();
        return classes;
    }

    private static List<Class<?>> getClasses(File directory, String packageName) {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                classes.addAll(ClassUtil.getClasses(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(CLASS_SUFIX)) {
                String clsName = String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().lastIndexOf("."));
                try {
                    classes.add(Class.forName(clsName));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            ++n2;
        }
        return classes;
    }

    public static Method getMethod(Class<?> clazz, String name) throws NoSuchMethodException {
        Method[] methods;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equalsIgnoreCase(name)) {
                return m;
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            ClassUtil.getMethod(clazz.getSuperclass(), name);
        }
        throw new NoSuchMethodException();
    }

    public static Field[] getAllFields(Class<?> clazz, Class<?> uptoParent) {
        HashSet<Field> fields = new HashSet<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(uptoParent)) {
            fields.addAll(Arrays.asList(ClassUtil.getAllFields(clazz.getSuperclass(), uptoParent)));
        }
        return fields.toArray(new Field[0]);
    }

    public static void extractInterfaces(Set<Class<?>> iSet, Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return;
        }
        Class<?>[] classes = clazz.getInterfaces();
        iSet.addAll(Arrays.asList(classes));
        ClassUtil.extractInterfaces(iSet, clazz.getSuperclass());
    }

    public static <C> C getInstance() {
        try {
            Class<?> class1 = ((ParameterizedType)ClassUtil.class.getMethod("getInstance", new Class[0]).getGenericReturnType()).getActualTypeArguments()[0].getClass();
            return (C)class1.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getMethodSignture(Method m, boolean includeClass) {
        StringBuilder signBuilder = new StringBuilder();
        if (includeClass) {
            signBuilder.append(m.getDeclaringClass().getCanonicalName());
            signBuilder.append("#");
        }
        signBuilder.append(m.getName());
        signBuilder.append("(");
        Iterator<Class<?>> iterator = Arrays.asList(m.getParameterTypes()).iterator();
        while (iterator.hasNext()) {
            Class<?> parameterType = iterator.next();
            signBuilder.append(parameterType.getCanonicalName());
            if (!iterator.hasNext()) continue;
            signBuilder.append(", ");
        }
        signBuilder.append(")");
        return signBuilder.toString();
    }

    public static Class getTemplateParameterOfInterface(Class base, Class desiredInterface) {
        Object rtn = ClassUtil.getSomething(base, desiredInterface);
        if (rtn != null && rtn instanceof Class) {
            return (Class)rtn;
        }
        return null;
    }

    private static Object getSomething(Class base, Class desiredInterface) {
        int i = 0;
        while (i < base.getInterfaces().length) {
            Class<?> intf = base.getInterfaces()[i];
            if (intf.equals(desiredInterface)) {
                Type generic = base.getGenericInterfaces()[i];
                if (generic instanceof ParameterizedType) {
                    ParameterizedType p = (ParameterizedType)generic;
                    Type type = p.getActualTypeArguments()[0];
                    Class<?> rtn = ClassUtil.getRawTypeNoException(type);
                    if (rtn != null) {
                        return rtn;
                    }
                    return type;
                }
                return null;
            }
            ++i;
        }
        if (base.getSuperclass() == null || base.getSuperclass().equals(Object.class)) {
            return null;
        }
        Object rtn = ClassUtil.getSomething(base.getSuperclass(), desiredInterface);
        if (rtn == null || rtn instanceof Class) {
            return rtn;
        }
        if (!(rtn instanceof TypeVariable)) {
            return null;
        }
        String name = ((TypeVariable)rtn).getName();
        int index = -1;
        TypeVariable<Class<T>>[] variables = base.getSuperclass().getTypeParameters();
        if (variables == null || variables.length < 1) {
            return null;
        }
        int i2 = 0;
        while (i2 < variables.length) {
            if (variables[i2].getName().equals(name)) {
                index = i2;
            }
            ++i2;
        }
        if (index == -1) {
            return null;
        }
        Type genericSuperclass = base.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)genericSuperclass;
        Type type = pt.getActualTypeArguments()[index];
        Class<?> clazz = ClassUtil.getRawTypeNoException(type);
        if (clazz != null) {
            return clazz;
        }
        return type;
    }

    public static Type getGenericReturnTypeOfGenericInterfaceMethod(Class clazz, Method method) {
        if (!method.getDeclaringClass().isInterface()) {
            return method.getGenericReturnType();
        }
        try {
            Method tmp = clazz.getMethod(method.getName(), method.getParameterTypes());
            return tmp.getGenericReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return method.getGenericReturnType();
        }
    }

    public static Type[] getGenericParameterTypesOfGenericInterfaceMethod(Class clazz, Method method) {
        if (!method.getDeclaringClass().isInterface()) {
            return method.getGenericParameterTypes();
        }
        try {
            Method tmp = clazz.getMethod(method.getName(), method.getParameterTypes());
            return tmp.getGenericParameterTypes();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return method.getGenericParameterTypes();
        }
    }

    public static Class<?> getRawType(Type type) {
        TypeVariable typeVar;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = ClassUtil.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        if (type instanceof TypeVariable && (typeVar = (TypeVariable)type).getBounds() != null && typeVar.getBounds().length > 0) {
            return ClassUtil.getRawType(typeVar.getBounds()[0]);
        }
        throw new RuntimeException("Unable to determine base class from Type");
    }

    public static Class<?> getRawTypeNoException(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = ClassUtil.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        return null;
    }

    public static Class<?> getTypeArgument(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Class typeArg = (Class)parameterizedType.getActualTypeArguments()[0];
        return typeArg;
    }

    public static Class getCollectionBaseType(Class type, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return ClassUtil.getRawType(componentGenericType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type componentGenericType = genericArrayType.getGenericComponentType();
            return ClassUtil.getRawType(componentGenericType);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    public static Class getMapKeyType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return ClassUtil.getRawType(componentGenericType);
        }
        return null;
    }

    public static Class getMapValueType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[1];
            return ClassUtil.getRawType(componentGenericType);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Type getActualValueOfTypevariable(Class<?> clazz, TypeVariable<?> typevariable) {
        block4: {
            if (!(typevariable.getGenericDeclaration() instanceof Class)) break block4;
            classDeclaringTypevariable = (Class)typevariable.getGenericDeclaration();
            fromInterface = ClassUtil.getTypeVariableViaGenericInterface(clazz, classDeclaringTypevariable, typevariable);
            if (fromInterface == null) ** GOTO lbl16
            return fromInterface;
lbl-1000:
            // 1 sources

            {
                if (clazz.getSuperclass().equals(classDeclaringTypevariable)) {
                    parameterizedSuperclass = (ParameterizedType)clazz.getGenericSuperclass();
                    i = 0;
                    while (i < classDeclaringTypevariable.getTypeParameters().length) {
                        tv = classDeclaringTypevariable.getTypeParameters()[i];
                        if (tv.equals(typevariable)) {
                            return parameterizedSuperclass.getActualTypeArguments()[i];
                        }
                        ++i;
                    }
                }
                clazz = clazz.getSuperclass();
lbl16:
                // 2 sources

                ** while (clazz.getSuperclass() != null)
            }
        }
        throw new RuntimeException("Unable to determine value of type parameter " + typevariable);
    }

    public static void setField(String fieldName, Object classObj, Object value) {
        try {
            Field field = ClassUtil.getField(fieldName, classObj.getClass());
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(classObj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Field getField(String fieldName, Class<?> clazz) throws NoSuchFieldException {
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            var7_4 = fields = ClassUtil.getAllFields(clazz, Object.class);
            var6_5 = fields.length;
            var5_6 = 0;
            ** while (var5_6 < var6_5)
        }
lbl-1000:
        // 1 sources

        {
            f = var7_4[var5_6];
            if (f.getName().equalsIgnoreCase(fieldName)) {
                return f;
            }
            ++var5_6;
            continue;
        }
lbl13:
        // 1 sources

        throw e;
    }

    public static Object getField(String fieldName, Object classObj) {
        try {
            Field field = ClassUtil.getField(fieldName, classObj.getClass());
            field.setAccessible(true);
            return field.get(classObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Type getTypeVariableViaGenericInterface(Class<?> clazz, Class<?> classDeclaringTypevariable, TypeVariable<?> typevariable) {
        Type[] typeArray = clazz.getGenericInterfaces();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type genericInterface = typeArray[n2];
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                int i = 0;
                while (i < classDeclaringTypevariable.getTypeParameters().length) {
                    TypeVariable<Class<?>> tv = classDeclaringTypevariable.getTypeParameters()[i];
                    if (tv.equals(typevariable)) {
                        return parameterizedType.getActualTypeArguments()[i];
                    }
                    ++i;
                }
            } else if (genericInterface instanceof Class) {
                return ClassUtil.getTypeVariableViaGenericInterface((Class)genericInterface, classDeclaringTypevariable, typevariable);
            }
            ++n2;
        }
        return null;
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    public static boolean isPrimitiveOrWrapperType(Class<?> clazz) {
        return clazz.isPrimitive() || ClassUtil.isWrapperType(clazz);
    }

    public static boolean isAssignableFrom(Type typeOfT, Class<?> clazz) {
        Class<?> cls = ClassUtil.getClass(typeOfT);
        return clazz.isAssignableFrom(cls);
    }

    public static Class<?> getClass(Type typeOfT) {
        if (typeOfT instanceof ParameterizedType) {
            return ClassUtil.getClass(((ParameterizedType)typeOfT).getRawType());
        }
        if (typeOfT instanceof Class) {
            return (Class)typeOfT;
        }
        try {
            return ClassUtils.getClass((String)typeOfT.getTypeName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return typeOfT.getClass();
        }
    }

    public static class TypeInfo {
        private Class<?> type;
        private Type genericType;

        public TypeInfo(Class<?> type, Type genericType) {
            this.type = type;
            this.genericType = genericType;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.genericType;
        }
    }
}

