/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public abstract class StringMatcher {
    protected String stringToMatch;

    public StringMatcher(String stringToMatch) {
        this.stringToMatch = stringToMatch;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ":" + this.stringToMatch;
    }

    public abstract boolean match(String var1);

    public static StringMatcher get(String type, String stringToMatch) {
        try {
            Method m = ClassUtil.getMethod(StringMatcher.class, type);
            return (StringMatcher)m.invoke(null, stringToMatch);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static StringMatcher exact(String stringToMatch) {
        return new Exact(stringToMatch);
    }

    public static StringMatcher exactIgnoringCase(String stringToMatch) {
        return new ExactIgnoringCase(stringToMatch);
    }

    public static StringMatcher startsWith(String stringToMatch) {
        return new StartsWith(stringToMatch);
    }

    public static StringMatcher startsWithIgnoringCase(String stringToMatch) {
        return new StartsWithIgnoringCase(stringToMatch);
    }

    public static StringMatcher endsWith(String stringToMatch) {
        return new EndsWith(stringToMatch);
    }

    public static StringMatcher endsWithIgnoringCase(String stringToMatch) {
        return new EndsWithIgnoringCase(stringToMatch);
    }

    public static StringMatcher contains(String stringToMatch) {
        return new Contains(stringToMatch);
    }

    public static StringMatcher containsIgnoringCase(String stringToMatch) {
        return new ContainsIgnoringCase(stringToMatch);
    }

    public static StringMatcher like(String stringToMatch) {
        return new Like(stringToMatch);
    }

    public static StringMatcher likeIgnoringCase(String stringToMatch) {
        return new LikeIgnoringCase(stringToMatch);
    }

    public static StringMatcher gt(String stringToMatch) {
        return new GT(stringToMatch);
    }

    public static StringMatcher gte(String stringToMatch) {
        return new GTE(stringToMatch);
    }

    public static StringMatcher lt(String stringToMatch) {
        return new LT(stringToMatch);
    }

    public static StringMatcher lte(String stringToMatch) {
        return new LTE(stringToMatch);
    }

    public static StringMatcher eq(String stringToMatch) {
        return new EQ(stringToMatch);
    }

    private static class Contains
    extends StringMatcher {
        Contains(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.contains(this.stringToMatch);
        }
    }

    private static class ContainsIgnoringCase
    extends StringMatcher {
        ContainsIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.toUpperCase().contains(this.stringToMatch.toUpperCase());
        }
    }

    private static class EQ
    extends StringMatcher {
        EQ(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual == expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class EndsWith
    extends StringMatcher {
        EndsWith(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.endsWith(this.stringToMatch);
        }
    }

    private static class EndsWithIgnoringCase
    extends StringMatcher {
        EndsWithIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.toUpperCase().endsWith(this.stringToMatch.toUpperCase());
        }
    }

    private static class Exact
    extends StringMatcher {
        Exact(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return this.stringToMatch.equals(target);
        }
    }

    private static class ExactIgnoringCase
    extends StringMatcher {
        ExactIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return this.stringToMatch.equalsIgnoreCase(target);
        }
    }

    private static class GT
    extends StringMatcher {
        GT(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual > expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class GTE
    extends StringMatcher {
        GTE(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual >= expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class LT
    extends StringMatcher {
        LT(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual < expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class LTE
    extends StringMatcher {
        LTE(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual <= expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class Like
    extends StringMatcher {
        Like(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return Pattern.matches(this.stringToMatch, target);
        }
    }

    private static class LikeIgnoringCase
    extends StringMatcher {
        LikeIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            Pattern p = Pattern.compile(this.stringToMatch, 2);
            return p.matcher(target).matches();
        }
    }

    private static class StartsWith
    extends StringMatcher {
        StartsWith(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.startsWith(this.stringToMatch);
        }
    }

    private static class StartsWithIgnoringCase
    extends StringMatcher {
        StartsWithIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.toUpperCase().startsWith(this.stringToMatch.toUpperCase());
        }
    }
}

