/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.ui.webdriver;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.ui.webdriver.FindsByCustomStretegy;
import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ByCustom
extends By {
    private static final Log logger = LogFactory.getLog(ByCustom.class);
    private By by;

    public ByCustom(String strategy, String loc) {
        this.by = this.getBy(strategy, loc);
    }

    public WebElement findElement(SearchContext context) {
        return this.by.findElement(context);
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.by.findElements(context);
    }

    private By getBy(String srategy, final String loc) {
        final String s = ConfigurationManager.getBundle().getString(srategy, srategy);
        try {
            Class<?> cls = Class.forName(s);
            try {
                Constructor<?> con = cls.getConstructor(String.class);
                con.setAccessible(true);
                return (By)con.newInstance(loc);
            }
            catch (Exception e) {
                throw new AutomationError("Unable to create By using class" + s + " for locator " + loc, e);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.info((Object)("No class registerd for strategy" + s + ". Will use '" + s + "' as custom strategy"));
            return new By(){

                public List<WebElement> findElements(SearchContext context) {
                    return ((FindsByCustomStretegy)context).findElementsByCustomStretegy(s, loc);
                }

                public WebElement findElement(SearchContext context) {
                    return ((FindsByCustomStretegy)context).findElementByCustomStretegy(s, loc);
                }

                public String toString() {
                    return String.format("Using %s: %s", s, loc);
                }
            };
        }
    }

    public String toString() {
        return this.by.toString();
    }

    public By getBy() {
        return this.by;
    }
}

