/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.testng.DataProviderException;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;
import org.apache.poi.ss.format.CellDateFormatter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class PoiExcelUtil {
    private static final Log logger = LogFactoryImpl.getLog(PoiExcelUtil.class);

    private static int getFirstRow(Sheet s, boolean skipHeaderRow) {
        int row = s.getFirstRowNum();
        while (row < s.getLastRowNum()) {
            Row r = s.getRow(row);
            boolean isEmptyRow = true;
            if (r != null) {
                short minColIx = r.getFirstCellNum();
                short maxColIx = r.getLastCellNum();
                short colIx = minColIx;
                while (colIx < maxColIx) {
                    Cell cell = r.getCell((int)colIx);
                    if (StringUtil.isNotBlank((String)PoiExcelUtil.getCellContentAsString(cell))) {
                        isEmptyRow = false;
                        break;
                    }
                    colIx = (short)(colIx + 1);
                }
            }
            if (!isEmptyRow) {
                if (!skipHeaderRow) break;
                skipHeaderRow = false;
            }
            ++row;
        }
        return row;
    }

    private static int getFirstCol(Sheet s) {
        Row row = s.getRow(PoiExcelUtil.getFirstRow(s, false));
        int col = row.getFirstCellNum();
        while (col < row.getLastCellNum()) {
            Cell cell = row.getCell(col);
            if (StringUtil.isNotBlank((String)PoiExcelUtil.getCellContentAsString(cell))) {
                return col;
            }
            ++col;
        }
        return 0;
    }

    public static List<String> getSheetNames(File f) {
        if (!f.exists() || !f.canRead()) {
            throw new AutomationError("File not" + (f.exists() ? " readable " : " found ") + f.getAbsolutePath());
        }
        LinkedList<String> names = new LinkedList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Workbook workbook = PoiExcelUtil.getWorkbook(f);){
                if (workbook != null) {
                    workbook.iterator().forEachRemaining(s -> {
                        boolean bl = names.add(s.getSheetName());
                    });
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new AutomationError(e);
        }
        return names;
    }

    public static Object[][] getExcelData(String file, boolean headerRow, String sheetName) {
        File f;
        Workbook workbook;
        Object[][] retobj;
        block14: {
            retobj = null;
            workbook = null;
            f = new File(file);
            workbook = PoiExcelUtil.getWorkbook(f);
            if (workbook != null) break block14;
            logger.error((Object)(" Can not read file " + f.getAbsolutePath() + " Returning empty dataset1"));
            Object[][] objectArray = new Object[][]{};
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            return objectArray;
        }
        try {
            try {
                Sheet sheet;
                Sheet sheet2 = sheet = StringUtil.isNotBlank((String)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
                if (sheet == null) {
                    throw new RuntimeException("Worksheet " + sheetName + " not found in " + f.getAbsolutePath());
                }
                int firstRow = PoiExcelUtil.getFirstRow(sheet, headerRow);
                int firstCol = PoiExcelUtil.getFirstCol(sheet);
                int lastRow = sheet.getLastRowNum();
                short colsCnt = sheet.getRow(firstRow).getLastCellNum();
                logger.info((Object)("Rows : " + lastRow));
                logger.info((Object)("Columns : " + colsCnt));
                retobj = new Object[lastRow - firstRow][colsCnt - firstCol];
                int rIndex = firstRow;
                while (rIndex < lastRow) {
                    Row row = sheet.getRow(rIndex);
                    int col = firstCol;
                    while (col < row.getLastCellNum()) {
                        retobj[rIndex - firstRow][col - firstCol] = PoiExcelUtil.getCellContent(row.getCell(col));
                        ++col;
                    }
                    ++rIndex;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error while fetching data from " + file), (Throwable)e);
                throw new DataProviderException("Error while fetching data from " + file, e);
            }
        }
        catch (Throwable throwable) {
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            workbook.close();
        }
        catch (Exception exception) {}
        return retobj;
    }

    public static Object[][] getExcelDataAsMap(String file, String sheetName) {
        File f;
        Workbook workbook;
        LinkedList<Object[]> retobj;
        block18: {
            retobj = null;
            workbook = null;
            f = new File(file);
            workbook = PoiExcelUtil.getWorkbook(f);
            if (workbook != null) break block18;
            logger.error((Object)(" Can not read file " + f.getAbsolutePath() + " Returning empty dataset1"));
            Object[][] objectArray = new Object[][]{};
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            return objectArray;
        }
        try {
            try {
                Sheet sheet;
                Sheet sheet2 = sheet = StringUtil.isNotBlank((String)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
                if (sheet == null) {
                    throw new RuntimeException("Worksheet " + sheetName + " not found in " + f.getAbsolutePath());
                }
                int firstRow = PoiExcelUtil.getFirstRow(sheet, false);
                int firstCol = PoiExcelUtil.getFirstCol(sheet);
                int lastRow = sheet.getLastRowNum();
                short colsCnt = sheet.getRow(firstRow).getLastCellNum();
                String[] colNames = new String[colsCnt - firstCol];
                logger.info((Object)("Rows : " + lastRow));
                logger.info((Object)("Columns : " + colsCnt));
                retobj = new LinkedList<Object[]>();
                int rIndex = firstRow;
                while (rIndex <= lastRow) {
                    Row row = sheet.getRow(rIndex);
                    if (row != null) {
                        if (rIndex == firstRow) {
                            int col = firstCol;
                            while (col < row.getLastCellNum()) {
                                colNames[col - firstCol] = PoiExcelUtil.getCellContentAsString(row.getCell(col));
                                ++col;
                            }
                        } else {
                            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                            int col = firstCol;
                            while (col < firstCol + colNames.length) {
                                Cell cell = row.getCell(col, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
                                map.put(colNames[col - firstCol], PoiExcelUtil.getCellContent(cell));
                                ++col;
                            }
                            retobj.add(new Object[]{map});
                        }
                        ++rIndex;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error while fetching data from " + file), (Throwable)e);
                throw new DataProviderException("Error while fetching data from " + file, e);
            }
        }
        catch (Throwable throwable) {
            try {
                workbook.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            workbook.close();
        }
        catch (Exception exception) {}
        return (Object[][])retobj.toArray((T[])new Object[0][]);
    }

    public static Workbook getWorkbook(File f) throws IOException {
        if (!f.exists() || !f.canRead()) {
            return null;
        }
        return WorkbookFactory.create((File)f, null, (boolean)true);
    }

    public static Object[][] getTableDataAsMap(String xlFilePath, String tableName, String sheetName) {
        File f;
        Workbook workbook;
        Object[][] tabArray;
        block22: {
            tabArray = null;
            workbook = null;
            f = new File(xlFilePath);
            workbook = PoiExcelUtil.getWorkbook(f);
            if (workbook != null) break block22;
            logger.error((Object)(" Can not read file " + f.getAbsolutePath() + " Returning empty dataset1"));
            Object[][] objectArray = new String[][]{};
            try {
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (Exception exception) {}
            return objectArray;
        }
        try {
            try {
                Sheet sheet;
                Sheet sheet2 = sheet = StringUtil.isNotBlank((String)sheetName) ? workbook.getSheet(sheetName) : workbook.getSheetAt(0);
                if (sheet == null) {
                    throw new RuntimeException("Worksheet " + sheetName + " not found in " + f.getAbsolutePath());
                }
                Cell tableStart = PoiExcelUtil.findCell(sheet, tableName, 0, sheet.getFirstRowNum());
                if (tableStart == null) {
                    throw new RuntimeException("Lable " + tableName + " for starting data range not found in sheet " + sheet.getSheetName());
                }
                int startRow = tableStart.getRowIndex();
                int startCol = tableStart.getColumnIndex();
                Cell tableEnd = PoiExcelUtil.findCell(sheet, tableName, startCol + 1, startRow + 1);
                if (tableEnd == null) {
                    throw new RuntimeException("Lable " + tableName + " for ending data range not found in sheet " + sheet.getSheetName());
                }
                int endRow = tableEnd.getRowIndex();
                int endCol = tableEnd.getColumnIndex();
                logger.debug((Object)("startRow=" + startRow + ", endRow=" + endRow + ", " + "startCol=" + startCol + ", endCol=" + endCol));
                tabArray = new Object[endRow - startRow][1];
                int ci = 0;
                String[] colNames = new String[endCol - startCol - 1];
                int i = startRow;
                while (i <= endRow) {
                    int cj = 0;
                    if (i == startRow) {
                        int j = startCol + 1;
                        while (j < endCol) {
                            colNames[cj] = PoiExcelUtil.getCellContentAsString(sheet.getRow(i).getCell(j));
                            logger.debug((Object)("header[" + cj + "] : " + colNames[cj]));
                            ++j;
                            ++cj;
                        }
                    } else {
                        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                        int j = startCol + 1;
                        while (j < endCol) {
                            map.put(colNames[cj], PoiExcelUtil.getCellContent(sheet.getRow(i).getCell(j)));
                            ++j;
                            ++cj;
                        }
                        logger.debug((Object)("Record " + ci + ":" + map));
                        tabArray[ci++][0] = map;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("error while fetching data from " + xlFilePath), (Throwable)e);
                throw new DataProviderException("Error while fetching data from " + xlFilePath, e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (workbook != null) {
                    workbook.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (workbook != null) {
                workbook.close();
            }
        }
        catch (Exception exception) {}
        return tabArray;
    }

    public static Cell findCell(Sheet sheet, String searchText, int firstCol, int firstRow) {
        int j = firstRow;
        while (j <= sheet.getLastRowNum()) {
            Row row = sheet.getRow(j);
            if (row != null) {
                int k = firstCol;
                while (k <= row.getLastCellNum()) {
                    Cell cell = row.getCell(k);
                    if (cell != null && PoiExcelUtil.getCellContentAsString(cell).equals(searchText)) {
                        return cell;
                    }
                    ++k;
                }
            }
            ++j;
        }
        return null;
    }

    public static Object getCellContent(Cell cell) {
        if (cell != null) {
            CellStyle colStyle = cell.getSheet().getColumnStyle(cell.getColumnIndex());
            CellStyle cellStyle = cell.getCellStyle();
            String format = colStyle != null ? colStyle.getDataFormatString() : cellStyle.getDataFormatString();
            FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
            if ("@".equalsIgnoreCase(format)) {
                String val = new DataFormatter().formatCellValue(cell, evaluator, null);
                return val == null ? "" : val;
            }
            CellValue cellValue = evaluator.evaluate(cell);
            if (cellValue == null) {
                return null;
            }
            switch (cellValue.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return DateUtil.getJavaDate((double)cellValue.getNumberValue());
                    }
                    return cellValue.getNumberValue();
                }
                case BOOLEAN: {
                    return cellValue.getBooleanValue();
                }
                case BLANK: {
                    return "";
                }
                case STRING: {
                    return cellValue.getStringValue();
                }
            }
            return cellValue.formatAsString();
        }
        return null;
    }

    public static String getCellContentAsString(Cell cell) {
        if (cell != null) {
            FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
            CellValue cellValue = evaluator.evaluate(cell);
            if (cellValue == null) {
                return "";
            }
            switch (cellValue.getCellType()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = DateUtil.getJavaDate((double)cellValue.getNumberValue());
                        String df = cell.getCellStyle().getDataFormatString();
                        return new CellDateFormatter(df).format((Object)date);
                    }
                    return String.valueOf(cellValue.getNumberValue());
                }
                case BOOLEAN: {
                    return String.valueOf(cellValue.getBooleanValue());
                }
                case BLANK: {
                    return "";
                }
                case STRING: {
                    return cellValue.getStringValue();
                }
            }
            return cellValue.formatAsString();
        }
        return null;
    }
}

