/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.util;

import com.qmetry.qaf.automation.core.AutomationError;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.util.ClassUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public abstract class StringMatcher {
    protected String stringToMatch;

    public StringMatcher(String stringToMatch) {
        this.stringToMatch = stringToMatch;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ":" + this.stringToMatch;
    }

    public abstract boolean match(String var1);

    public static boolean match(String val1, String val2) {
        if (val1 == null || val2 == null) {
            return val1 == val2;
        }
        StringMatcher matcher = StringMatcher.getMatcherOrNull(val1);
        if (matcher != null) {
            return matcher.match(val2);
        }
        matcher = StringMatcher.getMatcherOrNull(val2);
        if (matcher != null) {
            return matcher.match(val1);
        }
        String defaultMatcherType = ConfigurationManager.getBundle().getString("stringmatcher.default.matcher", "exact");
        matcher = StringMatcher.get(defaultMatcherType, val1);
        if (matcher != null) {
            return matcher.match(val2);
        }
        throw new AutomationError(String.format("Wrong matcher type [%s]", defaultMatcherType));
    }

    public static StringMatcher get(String type, String stringToMatch) {
        try {
            type = type.toLowerCase().replace("nocase", "ignoringcase").replace("anycase", "ignoringcase").replace("ignorecase", "ignoringcase");
            Method m = ClassUtil.getMethod(StringMatcher.class, type);
            return (StringMatcher)m.invoke(null, stringToMatch);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static StringMatcher getMatcherOrNull(String stringWithMatcher) {
        if (stringWithMatcher.indexOf(":") > 0) {
            try {
                String[] parts = stringWithMatcher.split(":", 2);
                return StringMatcher.get(parts[0], parts[1]);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static StringMatcher expected(String stringWithMatcher) {
        if (StringUtil.isNullOrEmpty(stringWithMatcher)) {
            return new NullOrEmpty();
        }
        String[] parts = stringWithMatcher.split(":", 2);
        if (StringUtil.isNotBlank((String)parts[0])) {
            try {
                return StringMatcher.get(parts[0], parts[1]);
            }
            catch (Exception exception) {}
        }
        return StringMatcher.getDefultMatcher(stringWithMatcher);
    }

    private static StringMatcher getDefultMatcher(String expectedString) {
        String defaultMatcherType = ConfigurationManager.getBundle().getString("stringmatcher.default.matcher", "exact");
        StringMatcher matcher = StringMatcher.get(defaultMatcherType, expectedString);
        if (matcher != null) {
            return matcher;
        }
        throw new AutomationError(String.format("Wrong matcher type [%s]", defaultMatcherType));
    }

    public static StringMatcher blank(String ... nothig) {
        return new Blank();
    }

    public static StringMatcher in(String stringToMatch) {
        return new Contains(stringToMatch);
    }

    public static StringMatcher end(String stringToMatch) {
        return new EndsWith(stringToMatch);
    }

    public static StringMatcher endIgnoringCase(String stringToMatch) {
        return new EndsWith(stringToMatch);
    }

    public static StringMatcher start(String stringToMatch) {
        return new StartsWith(stringToMatch);
    }

    public static StringMatcher startIgnoringCase(String stringToMatch) {
        return new StartsWithIgnoringCase(stringToMatch);
    }

    public static StringMatcher regex(String stringToMatch) {
        return new Like(stringToMatch);
    }

    public static StringMatcher regexp(String stringToMatch) {
        return new Like(stringToMatch);
    }

    public static StringMatcher regexi(String stringToMatch) {
        return new LikeIgnoringCase(stringToMatch);
    }

    public static StringMatcher regexpi(String stringToMatch) {
        return new LikeIgnoringCase(stringToMatch);
    }

    public static StringMatcher glob(String stringToMatch) {
        return new Global(stringToMatch);
    }

    public static StringMatcher exact(String stringToMatch) {
        return new Exact(stringToMatch);
    }

    public static StringMatcher exactIgnoringCase(String stringToMatch) {
        return new ExactIgnoringCase(stringToMatch);
    }

    public static StringMatcher startsWith(String stringToMatch) {
        return new StartsWith(stringToMatch);
    }

    public static StringMatcher startsWithIgnoringCase(String stringToMatch) {
        return new StartsWithIgnoringCase(stringToMatch);
    }

    public static StringMatcher endsWith(String stringToMatch) {
        return new EndsWith(stringToMatch);
    }

    public static StringMatcher endsWithIgnoringCase(String stringToMatch) {
        return new EndsWithIgnoringCase(stringToMatch);
    }

    public static StringMatcher contains(String stringToMatch) {
        return new Contains(stringToMatch);
    }

    public static StringMatcher containsIgnoringCase(String stringToMatch) {
        return new ContainsIgnoringCase(stringToMatch);
    }

    public static StringMatcher like(String stringToMatch) {
        return new Like(stringToMatch);
    }

    public static StringMatcher likeIgnoringCase(String stringToMatch) {
        return new LikeIgnoringCase(stringToMatch);
    }

    public static StringMatcher gt(String stringToMatch) {
        return new GT(stringToMatch);
    }

    public static StringMatcher gte(String stringToMatch) {
        return new GTE(stringToMatch);
    }

    public static StringMatcher lt(String stringToMatch) {
        return new LT(stringToMatch);
    }

    public static StringMatcher lte(String stringToMatch) {
        return new LTE(stringToMatch);
    }

    public static StringMatcher eq(String stringToMatch) {
        return new EQ(stringToMatch);
    }

    private static class Blank
    extends StringMatcher {
        Blank() {
            super("");
        }

        @Override
        public boolean match(String target) {
            return StringUtil.isBlank((String)this.stringToMatch);
        }
    }

    private static class Contains
    extends StringMatcher {
        Contains(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.contains(this.stringToMatch);
        }
    }

    private static class ContainsIgnoringCase
    extends StringMatcher {
        ContainsIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.toUpperCase().contains(this.stringToMatch.toUpperCase());
        }
    }

    private static class EQ
    extends StringMatcher {
        EQ(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual == expected;
            }
            catch (NumberFormatException numberFormatException) {
                return target == null ? target == this.stringToMatch : target.equals(this.stringToMatch);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class EndsWith
    extends StringMatcher {
        EndsWith(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.endsWith(this.stringToMatch);
        }
    }

    private static class EndsWithIgnoringCase
    extends StringMatcher {
        EndsWithIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.toUpperCase().endsWith(this.stringToMatch.toUpperCase());
        }
    }

    private static class Exact
    extends StringMatcher {
        Exact(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return this.stringToMatch.equals(target);
        }
    }

    private static class ExactIgnoringCase
    extends StringMatcher {
        ExactIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return this.stringToMatch.equalsIgnoreCase(target);
        }
    }

    private static class GT
    extends StringMatcher {
        GT(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual > expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class GTE
    extends StringMatcher {
        GTE(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual >= expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class Global
    extends StringMatcher {
        Global(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            String expectedGlob = this.stringToMatch.replaceAll("([\\]\\[\\\\{\\}$\\(\\)\\|\\^\\+.])", "\\\\$1");
            expectedGlob = expectedGlob.replaceAll("\\*", ".*");
            expectedGlob = expectedGlob.replaceAll("\\?", ".");
            return Pattern.compile(expectedGlob, 32).matcher(target).matches();
        }
    }

    private static class LT
    extends StringMatcher {
        LT(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual < expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class LTE
    extends StringMatcher {
        LTE(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            try {
                double expected = Double.parseDouble(this.stringToMatch);
                double actual = Double.parseDouble(target);
                return actual <= expected;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class Like
    extends StringMatcher {
        Like(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return Pattern.matches(this.stringToMatch, target);
        }
    }

    private static class LikeIgnoringCase
    extends StringMatcher {
        LikeIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            Pattern p = Pattern.compile(this.stringToMatch, 2);
            return p.matcher(target).matches();
        }
    }

    private static class NullOrEmpty
    extends StringMatcher {
        NullOrEmpty() {
            super("");
        }

        @Override
        public boolean match(String target) {
            return StringUtil.isNullOrEmpty(this.stringToMatch);
        }
    }

    private static class StartsWith
    extends StringMatcher {
        StartsWith(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.startsWith(this.stringToMatch);
        }
    }

    private static class StartsWithIgnoringCase
    extends StringMatcher {
        StartsWithIgnoringCase(String stringToMatch) {
            super(stringToMatch);
        }

        @Override
        public boolean match(String target) {
            return target.toUpperCase().startsWith(this.stringToMatch.toUpperCase());
        }
    }
}

