/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.data;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.testng.dataprovider.QAFInetrceptableDataProvider;
import com.qmetry.qaf.automation.util.DatabaseUtil;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.text.StrSubstitutor;

public class JsonDataBean {
    private int samples = 10;
    private Map<String, Master> master;
    private List<Field> fields;
    private List<RawCollectors> collectors;
    private transient List<Colloector> _collectors;
    private transient Map<String, Class<? extends Colloector>> colloectorByName;
    private transient PropertyUtil params = new PropertyUtil();

    private JsonDataBean() {
    }

    private void init() {
        this.colloectorByName = new TreeMap<String, Class<? extends Colloector>>(String.CASE_INSENSITIVE_ORDER);
        this.colloectorByName.put("file", FileCollector.class);
        this.colloectorByName.put("db", DBCollector.class);
        this.colloectorByName.put("database", DBCollector.class);
        this.colloectorByName.put("json", JsonCollector.class);
        this.colloectorByName.put("expr", ExprCollector.class);
        if (this.collectors != null) {
            this.collectors.stream().forEach(c -> this.addCollector(this.getColloector((RawCollectors)c)));
        }
        this.setDataGenerator();
    }

    private Colloector getColloector(RawCollectors rc) {
        Configuration collectorParams = this.params.subset("collectors." + rc.type);
        boolean disabled = collectorParams.getBoolean("disabled", rc.disabled);
        if (disabled) {
            return null;
        }
        Class<? extends Colloector> className = rc.className;
        if (className == null) {
            className = this.colloectorByName.get(rc.type);
        }
        if (className == null) {
            throw new RuntimeException("Collector class not found for type:" + rc.type + ". You can provide class for custom type using className");
        }
        if (rc.options == null) {
            rc.options = new HashMap();
        }
        collectorParams.subset("options").getKeys().forEachRemaining(e -> rc.options.put(e.toString(), collectorParams.getProperty("options." + e)));
        String options = JSONUtil.toString(rc.options);
        return JSONUtil.toObject(options, className);
    }

    private void setDataGenerator() {
        TreeMap<String, Class<Double>> classByName = new TreeMap<String, Class<Double>>(String.CASE_INSENSITIVE_ORDER);
        classByName.put("int", Integer.class);
        classByName.put("integer", Integer.class);
        classByName.put("short", Short.class);
        classByName.put("long", Long.class);
        classByName.put("float", Float.class);
        classByName.put("double", Double.class);
        for (Field field : this.fields) {
            Configuration fieldParams = this.params.subset(field.name);
            if (field.type != null) {
                field._type = (Class)classByName.get(field.type);
            }
            if (StringUtil.isNotBlank((String)field.reference)) {
                String[] kv = field.reference.split("\\.", 2);
                field._dataGenerator = new RefernceSelector(kv[0], kv[1]);
            } else if (field.dataset == null || field.dataset.length == 0) {
                int max;
                int min = fieldParams.getInt("min", field.min);
                if (min == (max = fieldParams.getInt("max", field.max)) && min == 0) {
                    if (StringUtil.isBlank((String)field.format)) {
                        if (field.type != null && field.type.toUpperCase().startsWith("CAL")) {
                            field._dataGenerator = m -> "";
                        } else {
                            field._dataGenerator = new StringGenerator(field.type, fieldParams.getInt("length", field.length), fieldParams.getString("charSet", field.charSet));
                        }
                    } else {
                        field._dataGenerator = new FormatGenerator(field.format);
                    }
                } else if (field.type != null && field.type.equalsIgnoreCase("date")) {
                    field._dataGenerator = new DateGenerator(min, max);
                } else {
                    field._dataGenerator = new DoubleGenerator(min, max);
                }
            } else {
                Object[] dataset = fieldParams.containsKey("dataset") ? fieldParams.getStringArray("dataset") : field.dataset;
                field._dataGenerator = new ListDataSelector(this.master, dataset);
            }
            if (!StringUtil.isNotBlank((String)field.prefix) && !StringUtil.isNotBlank((String)field.suffix)) continue;
            if (StringUtil.isBlank((String)field.formatVal)) {
                field.formatVal = "_value";
            }
            if (StringUtil.isNotBlank((String)field.prefix)) {
                field.formatVal = "'" + field.prefix + "'+" + field.formatVal;
            }
            if (!StringUtil.isNotBlank((String)field.suffix)) continue;
            field.formatVal = String.valueOf(field.formatVal) + "+'" + field.suffix + "'";
        }
    }

    public static JsonDataBean get(String file) {
        return JsonDataBean.get(file, null);
    }

    public static JsonDataBean get(String file, Map<String, Object> params2) {
        String source;
        try {
            source = FileUtil.readFileToString((File)new File(file), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read file.", e);
        }
        JsonDataBean bean = JSONUtil.toObject(source, JsonDataBean.class);
        if (params2 != null) {
            bean.params.addAll(params2);
        }
        bean.init();
        return bean;
    }

    public void addCollector(Colloector colloector) {
        if (this._collectors == null) {
            this._collectors = new ArrayList<Colloector>();
        }
        if (colloector != null) {
            this._collectors.add(colloector);
        }
    }

    public void removeAllCollectors() {
        if (this._collectors != null) {
            this._collectors.clear();
        }
    }

    public void setSamples(int samples) {
        this.samples = samples;
    }

    public void generateData() throws ScriptException {
        for (Colloector colloector : this._collectors) {
            String[] fidNames = (String[])this.fields.stream().map(f -> ((Field)f).name).toArray(String[]::new);
            colloector.init(fidNames);
        }
        int i = 0;
        while (i < this.samples) {
            Map<String, Object> record = this.populate();
            for (Colloector colloector : this._collectors) {
                colloector.collect(record);
            }
            ++i;
        }
        for (Colloector colloector : this._collectors) {
            colloector.close();
        }
    }

    public Map<String, Object> populate() throws ScriptException {
        LinkedHashMap<String, Object> record = new LinkedHashMap<String, Object>();
        HashMap<String, Map> _references = new HashMap<String, Map>();
        record.put("_references", _references);
        for (Field field : this.fields) {
            Object value = field._dataGenerator.generate(record);
            if (field.type != null && field.type.charAt(0) == 'r') {
                _references.put(field.name, (Map)value);
                continue;
            }
            if (field._type != null) {
                value = JSONUtil.toObject(String.valueOf(value), field._type);
            }
            if (StringUtil.isNotBlank((String)field.formatVal)) {
                LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(record);
                param.put("_value", value);
                value = StringUtil.eval(StrSubstitutor.replace((Object)field.formatVal, param), param);
            }
            record.put(field.name, value);
        }
        record.remove("_references");
        return record;
    }

    private void checkSetMasterData(Master masterRec) {
        if (masterRec.data == null && masterRec.metadata != null) {
            TreeMap<String, Object> metadata = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            metadata.putAll(masterRec.metadata);
            Object[][] data = QAFInetrceptableDataProvider.getData(metadata);
            masterRec.data = Stream.of(data).flatMap(Arrays::stream).map(c -> (Map)c).collect(Collectors.toList());
        }
    }

    public static void main(String[] args) throws IOException, ScriptException {
        String file = ConfigurationManager.getBundle().getString("schema", ConfigurationManager.getBundle().getString("datagen.schema", ""));
        int samples = ConfigurationManager.getBundle().getInt("samples", ConfigurationManager.getBundle().getInt("datagen.samples", 10));
        if (StringUtil.isBlank((String)file)) {
            throw new IOException("required datagen schema file. You can provide \"-Dschema=<filepath>\" or \"-Ddatagen.schema=<filepath>\"");
        }
        JsonDataBean bean = JsonDataBean.get(file);
        bean.setSamples(samples);
        bean.generateData();
    }

    public static interface Colloector {
        public void collect(Map<String, Object> var1);

        public void init(String[] var1);

        public void close();

        default public List<String> getErrorMessage() {
            return Collections.emptyList();
        }
    }

    private static class DBCollector
    implements Colloector {
        private String sql;
        private String prefix = "";
        private Connection con;

        private DBCollector() {
        }

        @Override
        public void collect(Map<String, Object> record) {
            String queryStr = new StrSubstitutor(record).replace(this.sql);
            if (this.con != null) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (Statement st = this.con.createStatement();){
                        st.executeUpdate(queryStr);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void init(String[] fidNames) {
            try {
                this.con = DatabaseUtil.getConnection(this.prefix);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void close() {
            DatabaseUtil.close(this.con);
        }
    }

    private class DateGenerator
    extends NumberGenerator {
        DateGenerator(int min, int max) {
            super(min, max);
        }

        @Override
        public Date generate(Map<String, Object> record) {
            return DateUtil.getDate(this.getNum().intValue());
        }
    }

    private class DoubleGenerator
    extends NumberGenerator {
        DoubleGenerator(int min, int max) {
            super(min, max);
        }

        @Override
        public Double generate(Map<String, Object> record) {
            return this.getNum();
        }
    }

    private static class ExprCollector
    implements Colloector {
        private String call;

        private ExprCollector() {
        }

        @Override
        public void collect(Map<String, Object> record) {
            LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>(record);
            param.put("_record", record);
            try {
                StringUtil.eval(this.call, param);
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void init(String[] fidNames) {
        }

        @Override
        public void close() {
        }
    }

    private class Field {
        private String name;
        private String type = "char";
        private String format;
        private String prefix;
        private String suffix;
        private int min;
        private int max;
        private int length = 10;
        private Object[] dataset;
        private String formatVal;
        private String reference;
        private transient RandomDataGenerator _dataGenerator;
        private String charSet;
        private transient Class<?> _type;

        private Field() {
        }
    }

    private static class FileCollector
    implements Colloector {
        private String file;
        private boolean append;
        private boolean headers;
        private String outputFormat;
        private String seperator = "";
        private PrintWriter out;
        private Formatter formatter;

        private FileCollector() {
        }

        @Override
        public void collect(Map<String, Object> record) {
            if (this.out != null) {
                this.out.println(this.formatter.format(record));
            }
        }

        @Override
        public void init(String[] fieldNames) {
            if (StringUtil.isNotBlank((String)this.file)) {
                try {
                    this.out = new PrintWriter(new FileWriter(this.file, this.append));
                    if (this.headers) {
                        this.out.println(StringUtil.join((Object[])fieldNames, (String)this.seperator));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.formatter = StringUtil.isNotBlank((String)this.outputFormat) ? data -> new StrSubstitutor(data).replace(this.outputFormat) : data -> {
                if (StringUtil.isBlank((String)this.seperator)) {
                    return StringUtil.join(data.values(), (String)"");
                }
                return data.values().stream().map(v -> {
                    if (v == null) {
                        return "";
                    }
                    if (v.toString().indexOf(this.seperator) >= 0) {
                        return "\"" + v + "\"";
                    }
                    return v.toString();
                }).collect(Collectors.joining(this.seperator));
            };
        }

        @Override
        public void close() {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
        }
    }

    private class FormatGenerator
    implements RandomDataGenerator {
        String format;

        FormatGenerator(String format) {
            this.format = format;
        }

        @Override
        public Object generate(Map<String, Object> record) {
            return StringUtil.getRandomString(this.format);
        }
    }

    private static interface Formatter {
        public String format(Map<String, Object> var1);
    }

    public static class JsonCollector
    implements Colloector {
        private String file;
        private List<Map<String, Object>> dataset;

        @Override
        public void collect(Map<String, Object> record) {
            this.dataset.add(record);
        }

        @Override
        public void init(String[] fidNames) {
            this.dataset = new ArrayList<Map<String, Object>>();
        }

        @Override
        public void close() {
            if (this.file != null) {
                JSONUtil.writeJsonObjectToFile(this.file, this.dataset);
            }
        }

        public List<Map<String, Object>> getDataset() {
            return this.dataset;
        }
    }

    private class ListDataSelector
    implements RandomDataGenerator {
        private Object[] values;
        private Map<String, Master> master;
        private boolean needToResolve;

        ListDataSelector(Map<String, Master> master, Object ... values) {
            this.values = values;
            this.master = master;
            this.needToResolve = false;
            if (values != null && values.length == 1) {
                if (values[0].toString().indexOf("${") < 0) {
                    String key = values[0].toString().replaceFirst("master.", "");
                    if (master != null && master.containsKey(key)) {
                        Master masterRec = master.get(key);
                        JsonDataBean.this.checkSetMasterData(masterRec);
                        this.values = masterRec.data.toArray(new Object[0]);
                    } else if (ConfigurationManager.getBundle().containsKey(values[0].toString())) {
                        this.values = ConfigurationManager.getBundle().getStringArray(values[0].toString(), values[0].toString());
                    }
                } else {
                    this.needToResolve = true;
                }
            }
        }

        @Override
        public Object generate(Map<String, Object> record) {
            Object[] values = (Object[])this.values.clone();
            if (this.needToResolve) {
                String key = StrSubstitutor.replace((Object)values[0], record);
                key = key.replaceFirst("master.", "");
                if (this.master != null && this.master.containsKey(key)) {
                    Master masterRec = this.master.get(key);
                    JsonDataBean.this.checkSetMasterData(masterRec);
                    values = masterRec.data.toArray(new Object[0]);
                } else if (ConfigurationManager.getBundle().containsKey(key)) {
                    values = ConfigurationManager.getBundle().getStringArray(key, key);
                }
            }
            if (values == null || values.length == 0) {
                return "";
            }
            Random rand = new Random();
            int r = rand.nextInt(values.length);
            return values[r];
        }
    }

    private class Master {
        private TreeMap<String, Object> metadata;
        private List<Map<String, Object>> data;

        private Master() {
        }
    }

    private abstract class NumberGenerator
    implements RandomDataGenerator {
        int min;
        int max;

        NumberGenerator(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public Double getNum() {
            return Math.random() * (double)(this.max - this.min + 1) + (double)this.min;
        }
    }

    private static interface RandomDataGenerator {
        public Object generate(Map<String, Object> var1);
    }

    private class RawCollectors {
        private String type = "file";
        private boolean disabled;
        private Class<? extends Colloector> className;
        private Map<String, Object> options;

        private RawCollectors() {
        }
    }

    private class RefernceSelector
    implements RandomDataGenerator {
        String refkey;
        String prop;

        RefernceSelector(String refKey, String prop) {
            this.refkey = refKey;
            this.prop = prop;
        }

        @Override
        public Object generate(Map<String, Object> record) {
            Map references = (Map)record.get("_references");
            Object val = ((Map)references.get(this.refkey)).get(this.prop);
            if (val instanceof List) {
                return new ListDataSelector(JsonDataBean.this.master, ((List)val).toArray(new Object[0])).generate(record);
            }
            if (val instanceof String) {
                return new ListDataSelector(JsonDataBean.this.master, val).generate(record);
            }
            return val;
        }
    }

    private class StringGenerator
    implements RandomDataGenerator {
        private static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private static final String NUMS = "0123456789";
        int length;
        char[] charSet;

        StringGenerator(String type, int length, String charSet) {
            int n = this.length = length > 0 ? length : 10;
            if (charSet == null || charSet.length() == 0) {
                StringBuilder set = new StringBuilder();
                if (type == null) {
                    set.append(CHARS);
                    set.append(CHARS.toLowerCase());
                    set.append(NUMS);
                } else if (type.toUpperCase().startsWith("CHAR") || type.toUpperCase().startsWith("STR")) {
                    set.append(CHARS);
                    set.append(CHARS.toLowerCase());
                } else {
                    set.append(NUMS);
                }
                this.charSet = set.toString().toCharArray();
            } else {
                this.charSet = charSet.toCharArray();
            }
        }

        @Override
        public Object generate(Map<String, Object> record) {
            StringBuilder sb = new StringBuilder(this.length);
            int i = 0;
            while (i < this.length) {
                int ci = (int)(Math.random() * (double)this.charSet.length);
                sb.append(this.charSet[ci]);
                ++i;
            }
            return sb.toString();
        }
    }
}

