/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.data.MetaDataScanner;
import com.qmetry.qaf.automation.integration.TestCaseResultUpdator;
import com.qmetry.qaf.automation.integration.TestCaseRunResult;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.report.StatusCounter;
import com.qmetry.qaf.automation.testng.report.ClassInfo;
import com.qmetry.qaf.automation.testng.report.MetaInfo;
import com.qmetry.qaf.automation.testng.report.MethodInfo;
import com.qmetry.qaf.automation.testng.report.MethodResult;
import com.qmetry.qaf.automation.testng.report.Report;
import com.qmetry.qaf.automation.testng.report.ReportEntry;
import com.qmetry.qaf.automation.testng.report.TestOverview;
import com.qmetry.qaf.automation.util.DateUtil;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public class JsonReporter
implements TestCaseResultUpdator {
    private static final Log logger = LogFactoryImpl.getLog(JsonReporter.class);
    private static final String REPORT_DIR = ApplicationProperties.JSON_REPORT_DIR.getStringVal(String.valueOf(ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal("test-results")) + "/" + DateUtil.getDate(0, "EdMMMyy_hhmmssa"));
    private static List<StatusCounter> suiteStatusCounters = new ArrayList<StatusCounter>();
    private static List<StatusCounter> testSetStatusCounters = new ArrayList<StatusCounter>();

    @Override
    public boolean updateResult(TestCaseRunResult result) {
        String suiteName = result.getExecutionInfo().getOrDefault("suiteName", "Default Suite").toString();
        String testName = String.valueOf(StringUtil.toTitleCaseIdentifier(suiteName)) + "/" + StringUtil.toTitleCaseIdentifier((String)result.getExecutionInfo().getOrDefault("testName", "Default Set"));
        String suitReportDir = REPORT_DIR;
        String testReportDir = String.valueOf(suitReportDir) + "/" + testName;
        StatusCounter suiteStatusCounter = this.getStatusCounter(suiteStatusCounters, StatusCounter.of(suiteName).withFile(suitReportDir));
        StatusCounter testStatusCounter = this.getStatusCounter(testSetStatusCounters, StatusCounter.of(testName).withFile(testReportDir));
        if (result.isTest() && !result.willRetry()) {
            suiteStatusCounter.add(result.getStatus());
            testStatusCounter.add(result.getStatus());
        }
        this.updateSuiteMetaData(result, suiteStatusCounter, testStatusCounter);
        this.updateTestOverView(result, testStatusCounter);
        this.addMethodResult(result, testStatusCounter);
        return true;
    }

    @Override
    public String getToolName() {
        return "QAF Json Reporter";
    }

    @Override
    public boolean allowConfigAndRetry() {
        return true;
    }

    @Override
    public boolean enabled() {
        return ConfigurationManager.getBundle().getBoolean("disable.qaf.testng.reporter", true) && ConfigurationManager.getBundle().getBoolean("qaf.json.reporter", true);
    }

    @Override
    public boolean allowParallel() {
        return false;
    }

    public static List<StatusCounter> getSuiteStatusCounters() {
        return Collections.unmodifiableList(suiteStatusCounters);
    }

    public static List<StatusCounter> getTestSetStatusCounters() {
        return Collections.unmodifiableList(testSetStatusCounters);
    }

    private StatusCounter getStatusCounter(List<StatusCounter> statusCounters, StatusCounter statusCounter) {
        int index = statusCounters.indexOf(statusCounter);
        if (index >= 0) {
            return statusCounters.get(index);
        }
        statusCounters.add(statusCounter);
        FileUtil.checkCreateDir(statusCounter.toString());
        return statusCounter;
    }

    private void addMethodResult(TestCaseRunResult result, StatusCounter testStatusCounter) {
        String methodResultDir;
        Object testData;
        int index = 1;
        MethodResult methodResult = new MethodResult();
        methodResult.setSeleniumLog((List)result.getCommandLogs());
        methodResult.setCheckPoints((List)result.getCheckPoints());
        methodResult.setThrowable(result.getThrowable());
        String identifierKey = ApplicationProperties.TESTCASE_IDENTIFIER_KEY.getStringVal("testCaseId");
        String methodResultFile = result.getMetaData().getOrDefault(identifierKey, "").toString();
        if (result.getTestData() != null && result.getTestData().size() > 0 && (testData = result.getTestData().iterator().next()) instanceof Map) {
            methodResultFile = ((Map)testData).getOrDefault(identifierKey, methodResultFile).toString();
            index = ((Map)testData).getOrDefault("__index", 1);
        }
        if (StringUtil.isBlank((String)methodResultFile)) {
            methodResultFile = result.getName();
        }
        if ((methodResultFile = StringUtil.toTitleCaseIdentifier(methodResultFile)).length() > 45) {
            methodResultFile = methodResultFile.substring(0, 45);
        }
        if (new File(methodResultDir = String.valueOf(testStatusCounter.toString()) + "/" + result.getClassName(), String.valueOf(methodResultFile) + ".json").exists()) {
            methodResultFile = String.valueOf(methodResultFile) + testStatusCounter.getTotal();
        }
        JSONUtil.writeJsonObjectToFile(String.valueOf(methodResultDir) + "/" + methodResultFile + ".json", methodResult);
        String classInfoFile = String.valueOf(methodResultDir) + "/meta-info.json";
        ClassInfo classInfo = JSONUtil.getJsonObjectFromFile(classInfoFile, ClassInfo.class);
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setStartTime(result.getStarttime());
        methodInfo.setDuration(result.getEndtime() - result.getStarttime());
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        methodInfo.setArgs(result.getTestData().stream().map(e -> gson.toJsonTree(e)).toArray());
        methodInfo.setIndex(index);
        methodInfo.setType(result.isTest() ? "test" : "config");
        methodInfo.setResult(result.getStatus().toQAF());
        Map<String, Object> metaData = result.getMetaData();
        if (!metaData.containsKey("name")) {
            metaData.put("name", result.getName());
        }
        metaData.put("resultFileName", methodResultFile);
        MetaDataScanner.formatMetaData(metaData);
        methodInfo.setMetaData(metaData);
        int retryCount = (Integer)result.getExecutionInfo().getOrDefault("retryCount", 0);
        if (retryCount > 0) {
            methodInfo.setRetryCount(retryCount);
        }
        if (!classInfo.getMethods().contains(methodInfo)) {
            classInfo.getMethods().add(methodInfo);
            JSONUtil.writeJsonObjectToFile(classInfoFile, classInfo);
        } else {
            logger.warn((Object)("methodInfo already wrritten for " + methodInfo.getName()));
        }
    }

    private void updateSuiteMetaData(TestCaseRunResult result, StatusCounter suiteStatusCounter, StatusCounter testStatusCounter) {
        Report report;
        String file = String.valueOf(suiteStatusCounter.toString()) + "/meta-info.json";
        if (new File(file).exists()) {
            report = JSONUtil.getJsonObjectFromFile(file, Report.class);
            report.getTests().add(testStatusCounter.getName());
        } else {
            report = new Report();
            report.setStartTime(result.getStarttime());
            HashSet<String> tests = new HashSet<String>();
            tests.add(testStatusCounter.getName());
            report.setTests(tests);
            report.setName(suiteStatusCounter.getName());
            ReportEntry reportEntry = new ReportEntry();
            reportEntry.setName(suiteStatusCounter.getName());
            reportEntry.setDir(suiteStatusCounter.toString());
            reportEntry.setStartTime(ConfigurationManager.getBundle().getLong("execution.start.ts", result.getStarttime()));
            String reportMetaInfoFile = String.valueOf(ApplicationProperties.JSON_REPORT_ROOT_DIR.getStringVal("test-results")) + "/meta-info.json";
            MetaInfo metaInfo = JSONUtil.getJsonObjectFromFile(reportMetaInfoFile, MetaInfo.class);
            metaInfo.getReports().add(reportEntry);
            JSONUtil.writeJsonObjectToFile(reportMetaInfoFile, metaInfo);
        }
        report.setEndTime(result.getEndtime());
        report.setPass(suiteStatusCounter.getPass());
        report.setFail(suiteStatusCounter.getFail());
        report.setSkip(suiteStatusCounter.getSkip());
        report.setTotal(suiteStatusCounter.getTotal());
        report.setStatus(suiteStatusCounter.getStatus());
        JSONUtil.writeJsonObjectToFile(file, report);
    }

    private void updateTestOverView(TestCaseRunResult result, StatusCounter testStatusCounter) {
        TestOverview testOverview;
        String file = String.valueOf(testStatusCounter.toString()) + "/overview.json";
        if (new File(file).exists()) {
            testOverview = JSONUtil.getJsonObjectFromFile(file, TestOverview.class);
            testOverview.getClasses().add(result.getClassName());
            Object dc = result.getExecutionInfo().get("driverCapabilities");
            if (dc != null) {
                testOverview.getEnvInfo().put("browser-desired-capabilities", ConfigurationManager.getBundle().getObject("driver.desiredCapabilities"));
                testOverview.getEnvInfo().put("browser-actual-capabilities", dc);
            }
        } else {
            testOverview = new TestOverview();
            testOverview.setStartTime(result.getStarttime());
            HashSet<String> classes = new HashSet<String>();
            classes.add(result.getClassName());
            testOverview.setClasses(classes);
            HashMap<String, Object> envInfo = new HashMap<String, Object>();
            HashMap<String, String> executionEnvInfo = new HashMap<String, String>();
            envInfo.put("execution-env-info", executionEnvInfo);
            testOverview.setEnvInfo(envInfo);
            envInfo.put("isfw-build-info", ConfigurationManager.getBundle().getObject("isfw.build.info"));
            envInfo.put("run-parameters", result.getExecutionInfo().get("env"));
            Object dc = result.getExecutionInfo().get("driverCapabilities");
            if (dc != null) {
                envInfo.put("browser-desired-capabilities", ConfigurationManager.getBundle().getObject("driver.desiredCapabilities"));
                envInfo.put("browser-actual-capabilities", dc);
            }
            executionEnvInfo.put("os.name", System.getProperty("os.name"));
            executionEnvInfo.put("os.version", System.getProperty("os.version"));
            executionEnvInfo.put("os.arch", System.getProperty("os.arch"));
            executionEnvInfo.put("java.version", System.getProperty("java.version"));
            executionEnvInfo.put("java.vendor", System.getProperty("java.vendor"));
            executionEnvInfo.put("java.arch", System.getProperty("sun.arch.data.model"));
            executionEnvInfo.put("user.name", System.getProperty("user.name"));
            executionEnvInfo.put("host", System.getProperty("host.name"));
        }
        testOverview.setEndTime(result.getEndtime());
        testOverview.setPass(testStatusCounter.getPass());
        testOverview.setFail(testStatusCounter.getFail());
        testOverview.setSkip(testStatusCounter.getSkip());
        testOverview.setTotal(testStatusCounter.getTotal());
        JSONUtil.writeJsonObjectToFile(file, testOverview);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getToolName().hashCode();
    }
}

