/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.step;

import com.qmetry.qaf.automation.core.ClassFinder;
import com.qmetry.qaf.automation.core.ClassFinderFactory;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.JavaStep;
import com.qmetry.qaf.automation.step.QAFTestStep;
import com.qmetry.qaf.automation.step.QAFTestStepProvider;
import com.qmetry.qaf.automation.step.StepFinder;
import com.qmetry.qaf.automation.step.TestStep;
import com.qmetry.qaf.automation.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

public final class JavaStepFinder {
    public static final Set<String> GLOBAL_STEPS_PACKAGES = new HashSet<String>(Arrays.asList("com.qmetry.qaf.automation.step"));
    private static final Log logger = LogFactoryImpl.getLog(JavaStepFinder.class);
    private static final ClassFinder CLASS_FINDER = ClassFinderFactory.getClassFinder();

    public static Map<String, TestStep> getAllJavaSteps() {
        HashMap<String, TestStep> stepMapping = new HashMap<String, TestStep>();
        LinkedHashSet<Method> steps = new LinkedHashSet<Method>();
        ArrayList<String> pkgs = new ArrayList<String>(GLOBAL_STEPS_PACKAGES);
        if (ConfigurationManager.getBundle().containsKey(ApplicationProperties.STEP_PROVIDER_PKG.key)) {
            pkgs.addAll(Arrays.asList(ConfigurationManager.getBundle().getStringArray(ApplicationProperties.STEP_PROVIDER_PKG.key)));
        }
        for (String pkg : pkgs) {
            logger.info((Object)("pkg: " + pkg));
            try {
                List<Class<?>> classes = CLASS_FINDER.getClasses(pkg);
                steps.addAll(JavaStepFinder.getAllMethodsWithAnnotation(classes, QAFTestStep.class));
            }
            catch (Throwable throwable) {
                System.err.println("Unable to load steps for package: " + pkg);
            }
        }
        for (Method step : steps) {
            if (Modifier.isPrivate(step.getModifiers())) continue;
            JavaStepFinder.add(stepMapping, new JavaStep(step));
        }
        ServiceLoader<StepFinder> stepFinderServicesLoader = ServiceLoader.load(StepFinder.class);
        Iterator<StepFinder> stepFinderServices = stepFinderServicesLoader.iterator();
        while (stepFinderServices.hasNext()) {
            Set<TestStep> osteps = stepFinderServices.next().getAllJavaSteps(pkgs);
            for (TestStep step : osteps) {
                JavaStepFinder.add(stepMapping, step);
            }
        }
        return stepMapping;
    }

    private static void add(Map<String, TestStep> stepMapping, TestStep step) {
        TestStep oldStep = stepMapping.put(step.getName().toUpperCase(), step);
        if (oldStep != null) {
            String[] pkgs = ConfigurationManager.getBundle().getStringArray(ApplicationProperties.STEP_PROVIDER_PKG.key);
            int oldStepPriority = JavaStepFinder.getStepPriority(oldStep, pkgs);
            int curStepPriority = JavaStepFinder.getStepPriority(step, pkgs);
            logger.debug((Object)String.format("Found duplicate step to load [%s] with [%s] prority then [%s]", oldStep.getSignature(), oldStepPriority > curStepPriority ? "higher" : "lower", step.getSignature()));
            if (oldStepPriority > curStepPriority) {
                step = oldStep;
                oldStep = stepMapping.put(step.getName().toUpperCase(), oldStep);
            }
        }
    }

    private static int getStepPriority(TestStep step, String[] pkgs) {
        String stepPackage = step.getFileName().replaceAll("/", ".");
        int i = 0;
        while (i < pkgs.length) {
            if (stepPackage.startsWith(pkgs[i])) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static Set<Method> getAllMethodsWithAnnotation(Collection<Class<?>> classes, Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> cls : classes) {
            if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) continue;
            boolean isStepProvider = cls.isAnnotationPresent(QAFTestStepProvider.class);
            Method[] methodArray = cls.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (isStepProvider || ClassUtil.hasAnnotation(method, annotation)) {
                    methods.add(method);
                }
                ++n2;
            }
        }
        return methods;
    }
}

