/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.tools;

import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.step.JavaStepReporter;
import com.qmetry.qaf.automation.step.QAFTestStep;
import com.qmetry.qaf.automation.tools.PostmanCollectionsImporter$AjcClosure1;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.text.StrBuilder;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class PostmanCollectionsImporter {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public static void main(String[] args) throws IOException {
        String file;
        if (args != null && args.length > 0) {
            ConfigurationManager.getBundle().clearProperty("postman.collection");
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (!arg.startsWith("-")) {
                    ConfigurationManager.getBundle().addProperty("postman.collection", arg);
                }
                ++n2;
            }
        }
        if (StringUtil.isNotBlank((String)(file = ConfigurationManager.getBundle().getString("postman.collection")))) {
            ArrayList<String> res = PostmanCollectionsImporter.importPostmanColletion(file, "");
            if (res != null && !res.isEmpty()) {
                System.out.println("Genereted files: " + res);
            }
        } else {
            System.err.println("provide postman collection file using \"postman.collection\" property");
        }
    }

    @QAFTestStep(description="import postman collection {collection-file} into {dest}")
    public static ArrayList<String> importPostmanColletion(String file, String dest) throws IOException {
        String string = file;
        String string2 = dest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{string, string2, joinPoint};
        PostmanCollectionsImporter$AjcClosure1 postmanCollectionsImporter$AjcClosure1 = new PostmanCollectionsImporter$AjcClosure1(objectArray);
        return (ArrayList)JavaStepReporter.aspectOf().javaTestStep(postmanCollectionsImporter$AjcClosure1.linkClosureAndJoinPoint(65536), ajc$tjp_0);
    }

    private static void recordRequests(Map<String, Object> item, Map<String, Object> wsc) {
        if (item.containsKey("request")) {
            String name = ((String)item.get("name")).replace('/', '.').replace(':', '_').replace(" ", "_");
            if (name.charAt(0) == '.') {
                name = name.substring(1);
            }
            LinkedHashMap<String, Object> reqcall = new LinkedHashMap<String, Object>();
            Object reqObj = item.get("request");
            if (reqObj instanceof Map) {
                Map req = (Map)reqObj;
                PostmanCollectionsImporter.parseUrl(reqcall, req.get("url"));
                reqcall.put("method", req.get("method"));
                reqcall.put("headers", PostmanCollectionsImporter.toMap((List)req.get("header")));
                PostmanCollectionsImporter.addAuthHeader(reqcall, (Map)req.get("auth"));
                PostmanCollectionsImporter.addBody(reqcall, req.get("body"));
                name = String.valueOf(name) + "." + req.get("method");
            } else {
                PostmanCollectionsImporter.parseUrl(reqcall, reqObj);
            }
            wsc.put(name.toLowerCase(), reqcall);
        } else {
            List items = (List)item.get("item");
            for (Map _item : items) {
                PostmanCollectionsImporter.recordRequests(_item, wsc);
            }
        }
    }

    private static void addBody(Map<String, Object> reqcall, Object body) {
        block14: {
            block15: {
                Map map;
                block16: {
                    if (body == null) break block14;
                    if (!(body instanceof Map)) break block15;
                    map = (Map)body;
                    if (!map.containsKey("mode")) break block16;
                    switch ((String)map.get("mode")) {
                        case "formdata": {
                            reqcall.put("form-parameters", PostmanCollectionsImporter.toMap((List)map.get("formdata")));
                            break;
                        }
                        case "urlencoded": {
                            reqcall.put("form-parameters", PostmanCollectionsImporter.toMap((List)map.get("urlencoded")));
                            break;
                        }
                        case "raw": {
                            reqcall.put("body", map.get("raw"));
                        }
                    }
                    break block14;
                }
                if (!map.isEmpty()) {
                    reqcall.put("body", JSONUtil.toString(map));
                }
                break block14;
            }
            reqcall.put("body", body);
        }
    }

    private static void addAuthHeader(Map<String, Object> reqcall, Map<String, Object> auth) {
        if (auth != null && "bearer".equalsIgnoreCase((String)auth.get("type"))) {
            ((Map)reqcall.get("headers")).put("Authorization", "Bearer <token>");
        }
    }

    private static void parseUrl(Map<String, Object> reqcall, Object urlObj) {
        if (urlObj instanceof Map) {
            Map url = (Map)urlObj;
            String baseUrl = ((String)((List)url.get("host")).get(0)).replace("{{", "${").replace("}}", "}");
            reqcall.put("baseurl", baseUrl);
            reqcall.put("endpoint", PostmanCollectionsImporter.getUrl(url.get("path")));
            reqcall.put("query-parameters", PostmanCollectionsImporter.toMap((List)url.get("query")));
        } else {
            reqcall.put("baseurl", PostmanCollectionsImporter.getUrl(urlObj));
        }
    }

    private static String getUrl(Object pathObj) {
        List<String> path;
        if (pathObj == null) {
            return null;
        }
        List<String> list = path = pathObj instanceof List ? (List<String>)pathObj : Arrays.asList(pathObj.toString().split("/"));
        if (path == null || path.size() < 1) {
            return null;
        }
        Iterator<String> iterator = path.iterator();
        if (!iterator.hasNext()) {
            return "";
        }
        String first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StrBuilder buf = new StrBuilder(first);
        while (iterator.hasNext()) {
            buf.append("/");
            String pathEntry = iterator.next();
            if (pathEntry == null) continue;
            if (pathEntry.length() > 0 && pathEntry.charAt(0) == ':') {
                buf.append("${");
                buf.append(pathEntry.substring(1));
                buf.append("}");
                continue;
            }
            buf.append(pathEntry.replace("{{", "${").replace("}}", "}"));
        }
        return buf.toString();
    }

    private static Map<String, Object> toMap(List<Map<String, Object>> listOfKvMap) {
        if (listOfKvMap == null) {
            return new HashMap<String, Object>();
        }
        return listOfKvMap.stream().collect(Collectors.toMap(s -> (String)s.get("key"), s -> s.getOrDefault("value", "").replace("{{", "${").replace("}}", "}")));
    }

    static {
        PostmanCollectionsImporter.ajc$preClinit();
    }

    static final /* synthetic */ ArrayList importPostmanColletion_aroundBody0(String file, String dest, JoinPoint joinPoint) {
        if (StringUtil.isBlank((String)dest)) {
            dest = ConfigurationManager.getBundle().getString("autogenerated.file.location", "resources/auto_generated/");
        }
        if (!dest.endsWith("/")) {
            dest = String.valueOf(dest) + "/";
        }
        if (dest.indexOf("auto_generated") < 0) {
            dest = String.valueOf(dest) + "auto_generated/";
        }
        ArrayList<String> genratedFiles = new ArrayList<String>();
        Map collection = JSONUtil.getJsonObjectFromFile(file, Map.class);
        List items = (List)collection.get("item");
        String name = (String)((Map)collection.get("info")).get("name");
        LinkedHashMap<String, Object> wsc = new LinkedHashMap<String, Object>();
        for (Map item : items) {
            PostmanCollectionsImporter.recordRequests(item, wsc);
        }
        List variables = (List)collection.get("variable");
        Map variablesByType = variables == null ? Collections.emptyMap() : variables.stream().collect(Collectors.groupingBy(v -> (String)v.get("type")));
        for (String type : variablesByType.keySet()) {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            ((List)variablesByType.get(type)).forEach(m -> propertiesConfiguration.setProperty((String)m.get("key"), m.get("value")));
            try {
                String propFile = String.valueOf(dest) + StringUtil.toCamelCaseIdentifier(type) + ".properties";
                propertiesConfiguration.save(propFile);
                genratedFiles.add(propFile);
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
        String wscjFile = String.valueOf(dest) + StringUtil.toCamelCaseIdentifier(name) + ".wscj";
        JSONUtil.writeJsonObjectToFile(wscjFile, wsc);
        genratedFiles.add(wscjFile);
        return genratedFiles;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PostmanCollectionsImporter.java", PostmanCollectionsImporter.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "importPostmanColletion", "com.qmetry.qaf.automation.tools.PostmanCollectionsImporter", "java.lang.String:java.lang.String", "file:dest", "java.io.IOException", "java.util.ArrayList"), 76);
    }
}

