/*
 * Decompiled with CFR 0.152.
 */
package com.qmetry.qaf.automation.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.qmetry.qaf.automation.core.ConfigurationManager;
import com.qmetry.qaf.automation.core.QAFTestBase;
import com.qmetry.qaf.automation.core.TestBaseProvider;
import com.qmetry.qaf.automation.keys.ApplicationProperties;
import com.qmetry.qaf.automation.step.JavaStepFinder;
import com.qmetry.qaf.automation.step.StepNotFoundException;
import com.qmetry.qaf.automation.step.StringTestStep;
import com.qmetry.qaf.automation.util.FileUtil;
import com.qmetry.qaf.automation.util.JSONUtil;
import com.qmetry.qaf.automation.util.PropertyUtil;
import com.qmetry.qaf.automation.util.StringMatcher;
import com.qmetry.qaf.automation.util.StringUtil;
import com.qmetry.qaf.automation.ws.Response;
import com.qmetry.qaf.automation.ws.rest.RestTestBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.json.JSONObject;

public class RepoEditor {
    private static final PropertyUtil QAF_CONTEXT = ConfigurationManager.getBundle();
    private static final QAFTestBase QAF_TESTBASE = (QAFTestBase)TestBaseProvider.instance().get();
    private static QAFRequestHandler handleExecuteRequest = (req, res, ctx) -> {
        try {
            String reqCall = IOUtils.toString((InputStream)req.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Object[] args = JSONUtil.toObject(reqCall, Object[].class);
            StringTestStep.execute("userRequestsWithData", args);
            Response result = new RestTestBase().getResponse();
            String resStr = new JSONObject((Object)result).toString();
            res.setEntity((HttpEntity)new StringEntity(resStr, ContentType.APPLICATION_JSON));
        }
        catch (StepNotFoundException stepNotFoundException) {
            res.setEntity((HttpEntity)new StringEntity("ERROR: Add qaf-support-ws library dependency!...", ContentType.TEXT_PLAIN));
        }
        catch (Throwable t) {
            t.printStackTrace();
            res.setEntity((HttpEntity)new StringEntity(t.getMessage(), ContentType.TEXT_PLAIN));
        }
    };
    private static QAFRequestHandler handleExecuteStep = (req, res, ctx) -> {
        HashMap<String, Object> responseToreturn = new HashMap<String, Object>();
        try {
            ((QAFTestBase)TestBaseProvider.instance().get()).claerAssertionsLog();
            String reqCall = IOUtils.toString((InputStream)req.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Map<String, Object> reqMap = JSONUtil.toMap(reqCall);
            Object result = StringTestStep.execute(reqMap.get("step").toString(), ((List)reqMap.get("args")).toArray(new Object[0]));
            try {
                responseToreturn.put("result", JSONUtil.toObject(JSONObject.valueToString((Object)result)));
            }
            catch (Exception e) {
                e.printStackTrace();
                responseToreturn.put("result", result.toString());
            }
            responseToreturn.put("checkPoints", ((QAFTestBase)TestBaseProvider.instance().get()).getCheckPointResults());
            responseToreturn.put("seleniumLog", ((QAFTestBase)TestBaseProvider.instance().get()).getLog());
        }
        catch (AssertionError assertionError) {
            responseToreturn.put("checkPoints", ((QAFTestBase)TestBaseProvider.instance().get()).getCheckPointResults());
            responseToreturn.put("seleniumLog", ((QAFTestBase)TestBaseProvider.instance().get()).getLog());
        }
        catch (Throwable t) {
            t.printStackTrace();
            responseToreturn.put("error", t.getMessage());
        }
        String resStr = "";
        try {
            resStr = JSONUtil.toString(responseToreturn);
        }
        catch (Throwable t) {
            t.printStackTrace();
            resStr = new JSONObject(responseToreturn).toString();
        }
        res.setEntity((HttpEntity)new StringEntity(resStr, ContentType.APPLICATION_JSON));
    };

    public static void main(String[] args) {
        System.setProperty(ApplicationProperties.DRY_RUN_MODE.key, "false");
        int port = QAF_CONTEXT.getInt("repoeditor.server.port", 2612);
        HttpServer server = RepoEditor.createServer(port);
        try {
            server.start();
            System.out.println("server started on port: " + port);
            System.out.println("type \"exit\" to stop server.");
            JavaStepFinder.GLOBAL_STEPS_PACKAGES.add("com.qmetry.qaf.automation.tools");
            Throwable throwable = null;
            Object var4_6 = null;
            try (Scanner s = new Scanner(System.in);){
                s.next("exit");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HttpServer createServer(int port) {
        HttpServer server = ServerBootstrap.bootstrap().setListenerPort(port).register("/", (req, res, c) -> res.setEntity((HttpEntity)new FileEntity(new File("dashboard.htm"), ContentType.TEXT_HTML))).register("/browse", (req, res, c) -> res.setEntity((HttpEntity)new StringEntity(RepoEditor.browse("."), ContentType.TEXT_HTML))).register("/executeRequest", (HttpRequestHandler)handleExecuteRequest).register("/executeStep", (HttpRequestHandler)handleExecuteStep).register("/repo-editor", (req, res, ctx) -> {
            block58: {
                try {
                    block59: {
                        Map<String, String> queryParams = RepoEditor.getQueryParams((HttpRequest)req);
                        System.out.println(queryParams);
                        if (queryParams.isEmpty()) break block59;
                        switch (queryParams.getOrDefault("operation", "")) {
                            case "get_prop": {
                                res.setEntity((HttpEntity)new StringEntity(QAF_CONTEXT.getString(queryParams.getOrDefault("name", ""), ""), ContentType.APPLICATION_JSON));
                            }
                            case "get_node": {
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(RepoEditor.getNodes(queryParams.get("id"))), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "get_wsc_content": {
                                Map<String, Object> wsc = RepoEditor.getWSCNodeContent(queryParams.get("path"), queryParams.get("name"));
                                if (wsc.containsKey("reference")) {
                                    wsc.put("refObj", JSONUtil.toObject(QAF_CONTEXT.getString(wsc.get("reference").toString(), "{}")));
                                }
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(wsc), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "get_grpc_content": {
                                try {
                                    Object result = StringTestStep.execute("getGRPCMethodDetails", queryParams.get("path"), queryParams.get("name"));
                                    res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(result), ContentType.APPLICATION_JSON));
                                }
                                catch (StepNotFoundException stepNotFoundException) {
                                    res.setEntity((HttpEntity)new StringEntity("ERROR: Add qaf-support-grpc library dependency!...", ContentType.TEXT_PLAIN));
                                }
                                catch (Throwable t2) {
                                    t2.printStackTrace();
                                    res.setEntity((HttpEntity)new StringEntity(t2.getMessage(), ContentType.TEXT_PLAIN));
                                }
                                break;
                            }
                            case "get_content": {
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(RepoEditor.getContent(queryParams.get("path"))), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "save_wsc": {
                                String message = "Saved " + queryParams.get("path");
                                String content = IOUtils.toString((InputStream)req.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                                RepoEditor.saveWsc(JSONUtil.toMap(content), queryParams);
                                res.setEntity((HttpEntity)new StringEntity(message, ContentType.TEXT_PLAIN));
                                break;
                            }
                            case "save_loc": {
                                String data = IOUtils.toString((InputStream)req.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                                RepoEditor.saveContent(JSONUtil.toObject(data, List.class), queryParams.get("path"));
                                break;
                            }
                            case "load_resource": {
                                QAF_CONTEXT.addBundle(queryParams.get("path"));
                                break;
                            }
                            case "save_file": {
                                String fileContent = IOUtils.toString((InputStream)req.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                                FileUtil.writeStringToFile((File)new File(queryParams.get("path")), (String)fileContent, (String)ApplicationProperties.LOCALE_CHAR_ENCODING.getStringVal("UTF-8"));
                                break;
                            }
                            case "move_node": {
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(RepoEditor.moveNode(queryParams)), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "copy_node": {
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(RepoEditor.copyNode(queryParams)), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "rename_node": {
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(RepoEditor.rename(queryParams)), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "create_node": {
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(RepoEditor.create(queryParams)), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "duplicate_node": {
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(RepoEditor.duplicate(queryParams)), ContentType.APPLICATION_JSON));
                                break;
                            }
                            case "delete_node": {
                                RepoEditor.delete(queryParams);
                                break;
                            }
                            case "step_list": {
                                List steps = ConfigurationManager.getStepMapping().values().stream().map(t -> t.getDescription()).collect(Collectors.toList());
                                res.setEntity((HttpEntity)new StringEntity(JSONUtil.toString(steps), ContentType.APPLICATION_JSON));
                                break;
                            }
                            default: {
                                res.setCode(404);
                                break;
                            }
                        }
                        break block58;
                    }
                    res.setEntity((HttpEntity)new FileEntity(new File("repo-editor.html"), ContentType.TEXT_HTML));
                }
                catch (Exception e) {
                    res.setCode(400);
                    res.setEntity((HttpEntity)new StringEntity(e.getMessage(), ContentType.TEXT_PLAIN));
                }
            }
        }).register("*", (req, res, ctx) -> {
            String endpoint;
            try {
                endpoint = req.getPath().substring(1).split("\\?", 2)[0];
                endpoint = req.getUri().getPath().substring(1);
            }
            catch (URISyntaxException uRISyntaxException) {
                endpoint = req.getPath().substring(1).split("\\?", 2)[0];
            }
            File file = new File(endpoint);
            boolean exist = file.exists();
            switch (req.getMethod().toUpperCase()) {
                case "GET": {
                    if (exist) {
                        if (file.isDirectory()) {
                            res.setEntity((HttpEntity)new StringEntity(RepoEditor.browse(endpoint), ContentType.TEXT_HTML));
                            break;
                        }
                        res.setEntity((HttpEntity)new FileEntity(file, RepoEditor.getContentType(endpoint)));
                        break;
                    }
                    res.setCode(404);
                    res.setReasonPhrase("Not avialable");
                    res.setEntity((HttpEntity)new StringEntity(String.valueOf(req.getPath()) + " not avialable."));
                    break;
                }
            }
        }).create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("stoping server!....");
            server.stop();
        }));
        return server;
    }

    private static String browse(String dir) {
        try {
            return Files.list(new File(dir).toPath()).map(p -> String.format("<a href=\"/%s\">%s</a>", p, p.toString().replace(dir, ""))).collect(Collectors.joining("<br>"));
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private static ContentType getContentType(String filename) {
        try {
            if (filename.endsWith(".js")) {
                return ContentType.create((String)"text/javascript", (String)"UTF-8");
            }
            if (filename.endsWith(".css")) {
                return ContentType.create((String)"text/css", (String)"UTF-8");
            }
            if (filename.endsWith(".wsc")) {
                return ContentType.APPLICATION_JSON;
            }
            if (filename.endsWith(".loc")) {
                return ContentType.APPLICATION_JSON;
            }
            if (filename.endsWith(".png")) {
                return ContentType.IMAGE_PNG;
            }
            if (filename.endsWith(".svg")) {
                return ContentType.IMAGE_SVG;
            }
            return ContentType.create((String)Files.probeContentType(new File(filename).toPath()));
        }
        catch (Exception exception) {
            return ContentType.TEXT_PLAIN;
        }
    }

    private static Map<String, String> getQueryParams(HttpRequest request) {
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        try {
            String[] pairs;
            String query = request.getUri().getQuery();
            String[] stringArray = pairs = query.split("&");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                try {
                    String[] kv = pair.split("=", 2);
                    query_pairs.put(URLDecoder.decode(kv[0], "UTF-8"), URLDecoder.decode(kv[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException | ArrayIndexOutOfBoundsException exception) {}
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        return query_pairs;
    }

    private static Map<String, Object> getWSCNodeContent(String path, String name) {
        Map<String, Object> fileContent = RepoEditor.getWSCFile(path);
        return fileContent.getOrDefault(name, Collections.emptyMap());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> copyNode(Map<String, String> queryParams) throws IOException {
        File parent = new File(queryParams.get("parent"));
        String id = queryParams.get("id");
        if (id.indexOf("#") > 0) {
            if (!parent.getName().endsWith(".wsc")) throw new IOException("Can't cop request call to" + parent.getName());
            String[] parts = id.split("#", 2);
            Map<String, Object> fileContent = RepoEditor.getWSCFile(parts[0]);
            Object wsc = fileContent.remove(parts[1]);
            fileContent = RepoEditor.getWSCFile(parent.getPath());
            fileContent.put(parts[1], wsc);
            RepoEditor.saveWSCFile(fileContent, parent.getPath());
            id = String.valueOf(queryParams.get("parent")) + "#" + parts[1];
        } else {
            File src = new File(id);
            File dest = new File(parent, src.getName());
            Files.copy(src.toPath(), dest.toPath(), new CopyOption[0]);
            id = dest.getPath();
        }
        queryParams.clear();
        queryParams.put("id", id);
        return queryParams;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> moveNode(Map<String, String> queryParams) throws IOException {
        String nodeName = queryParams.get("name");
        File parent = new File(queryParams.get("parent"));
        File oldParent = new File(queryParams.get("oldParent"));
        String id = String.valueOf(queryParams.get("parent")) + "/" + nodeName;
        if (oldParent.isFile()) {
            if (!RepoEditor.isWSC(parent.getName()) && !RepoEditor.isWSC(parent.getParent())) throw new IOException("Can't move request call to" + parent.getName());
            if (RepoEditor.isWSC(parent.getParent())) {
                parent = parent.getParentFile();
            }
            Map<String, Object> fileContent = RepoEditor.getWSCFile(oldParent.getPath());
            Object wsc = fileContent.remove(nodeName);
            RepoEditor.saveWSCFile(fileContent, oldParent.getPath());
            fileContent = RepoEditor.getWSCFile(parent.getPath());
            fileContent.put(nodeName, wsc);
            RepoEditor.saveWSCFile(fileContent, parent.getPath());
            id = String.valueOf(parent.getPath()) + "#" + nodeName;
        } else {
            System.out.println("moving file!....");
            Files.move(new File(oldParent, nodeName).toPath(), new File(parent, nodeName).toPath(), new CopyOption[0]);
        }
        queryParams.clear();
        queryParams.put("id", id);
        return queryParams;
    }

    private static boolean isWSC(String fileName) {
        if (fileName == null) {
            return false;
        }
        return StringMatcher.like(".*\\.wsc(j)?$").match(fileName);
    }

    private static boolean isLOC(String fileName) {
        if (fileName == null) {
            return false;
        }
        return StringMatcher.like(".*\\.loc(j)?$").match(fileName);
    }

    private static void delete(Map<String, String> queryParams) throws IOException {
        String id = queryParams.get("id").replace('#', '/');
        File target = new File(id);
        if (target.exists()) {
            FileUtil.deleteQuietly((File)target);
        } else if (RepoEditor.isWSC(target.getParent())) {
            Map<String, Object> fileContent = RepoEditor.getWSCFile(target.getParent());
            fileContent.remove(target.getName());
            RepoEditor.saveWSCFile(fileContent, target.getParent());
        }
    }

    private static Map<String, String> duplicate(Map<String, String> queryParams) throws IOException {
        String id = queryParams.get("path").replace('#', '/');
        File target = new File(id);
        if (target.exists()) {
            File dest = new File(target.getParentFile(), RepoEditor.generateFileName(target.getParentFile(), target.getName()));
            FileUtil.copyFile((File)target, (File)dest);
            id = dest.getPath();
        } else if (RepoEditor.isWSC(target.getParent())) {
            Map<String, Object> fileContent = RepoEditor.getWSCFile(target.getParent());
            String key = RepoEditor.generateKeyName(target.getName());
            Object val = fileContent.get(target.getName());
            fileContent.put(key, val);
            RepoEditor.saveWSCFile(fileContent, target.getParent());
            id = String.valueOf(target.getParent()) + "#" + key;
        }
        queryParams.clear();
        queryParams.put("id", id);
        return queryParams;
    }

    private static void saveWsc(Map<String, Object> content, Map<String, String> queryParams) throws IOException {
        String path = queryParams.get("path");
        if (StringUtil.isNotBlank((String)queryParams.get("name"))) {
            Map<String, Object> fileContent = RepoEditor.getWSCFile(path);
            fileContent.put(queryParams.get("name"), content);
            RepoEditor.saveWSCFile(fileContent, path);
        }
    }

    private static Map<String, String> rename(Map<String, String> queryParams) throws IOException {
        String old = queryParams.get("old");
        String id = queryParams.get("id").replace('#', '/');
        String newName = queryParams.get("text");
        File file = new File(id);
        File parent = file.getParentFile();
        if (RepoEditor.isWSC(parent.getName())) {
            file = parent;
            if (!file.exists()) {
                FileUtil.checkCreateDir(file.getParent());
            }
            Map<String, Object> fileContent = RepoEditor.getWSCFile(file.getPath());
            if (StringUtil.isNotBlank((String)newName)) {
                Object val = fileContent.remove(queryParams.getOrDefault("old", ""));
                if (val == null) {
                    val = JSONUtil.toObject("{}");
                }
                fileContent.put(newName, val);
            }
            RepoEditor.saveWSCFile(fileContent, file.getPath());
            id = String.valueOf(file.getPath()) + "#" + newName;
        } else if (StringUtil.isNotBlank((String)old)) {
            File oldFile = new File(parent, old);
            File newFile = new File(parent, newName);
            if (!FileUtil.getExtention(newName).equalsIgnoreCase(FileUtil.getExtention(old)) && (RepoEditor.isWSC(newName) || RepoEditor.isLOC(newName))) {
                try {
                    List<Map<String, Object>> content = RepoEditor.getContent(oldFile.getPath());
                    RepoEditor.saveContent(content, newFile.getPath());
                    oldFile.delete();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to change file type: " + e.getMessage());
                }
            } else if (oldFile.exists()) {
                oldFile.renameTo(newFile);
            } else {
                FileUtil.checkCreateDir(parent.getParent());
            }
            id = newFile.getPath();
        }
        queryParams.clear();
        queryParams.put("id", id);
        return queryParams;
    }

    private static Map<String, String> create(Map<String, String> queryParams) throws IOException {
        String type = queryParams.get("type");
        String id = queryParams.get("id");
        String name = queryParams.get("text");
        File parent = new File(queryParams.get("id"));
        if (RepoEditor.isWSC(parent.getName())) {
            if (!parent.exists()) {
                FileUtil.checkCreateDir(parent.getParent());
            }
            Map<String, Object> fileContent = RepoEditor.getWSCFile(parent.getPath());
            if (StringUtil.isNotBlank((String)name)) {
                name = RepoEditor.generateKeyName(name);
                fileContent.put(name, JSONUtil.toObject("{}"));
                RepoEditor.saveWSCFile(fileContent, parent.getPath());
            }
            id = String.valueOf(id) + "#" + name;
        } else {
            File file = new File(parent, RepoEditor.generateFolderName(parent, name));
            if (type.equalsIgnoreCase("folder")) {
                if (file.exists()) {
                    int cnt = 2;
                    while (new File(parent, String.valueOf(name) + cnt).exists()) {
                        ++cnt;
                    }
                    name = String.valueOf(name) + cnt;
                }
                file = new File(parent, name);
                FileUtil.checkCreateDir(file.getPath());
            } else {
                file.createNewFile();
            }
            id = file.getPath();
        }
        queryParams.clear();
        queryParams.put("id", id);
        queryParams.put("text", name);
        return queryParams;
    }

    private static String generateKeyName(String name) {
        if (StringUtil.isNotBlank((String)name)) {
            name = name.replace(' ', '.');
            int cnt = 2;
            if (QAF_CONTEXT.containsKey(name)) {
                while (QAF_CONTEXT.containsKey(String.valueOf(name) + cnt)) {
                    ++cnt;
                }
                name = String.valueOf(name) + cnt;
            }
        }
        return name;
    }

    private static String generateFolderName(File parent, String name) {
        File file;
        if (StringUtil.isNotBlank((String)name) && (file = new File(parent, name)).exists()) {
            int cnt = 2;
            while (new File(parent, String.valueOf(name) + cnt).exists()) {
                ++cnt;
            }
            name = String.valueOf(name) + cnt;
        }
        return name;
    }

    private static String generateFileName(File parent, String fileName) {
        File file;
        int i = fileName.lastIndexOf(46);
        String extension = "";
        String name = fileName;
        if (i >= 0) {
            name = fileName.substring(0, i);
            extension = "." + fileName.substring(i + 1);
        }
        if ((file = new File(parent, fileName)).exists()) {
            int cnt = 2;
            while (new File(parent, String.valueOf(name) + cnt + extension).exists()) {
                ++cnt;
            }
            name = String.valueOf(name) + cnt;
        }
        return String.valueOf(name) + extension;
    }

    private static Object[] getNodes(String id) {
        try {
            if (id.equalsIgnoreCase("#")) {
                File tdir = new File("resources");
                boolean dirExists = tdir.exists();
                if (!dirExists) {
                    dirExists = tdir.mkdirs();
                }
                HashMap<String, Object> rootNode = new HashMap<String, Object>();
                rootNode.put("text", "resources");
                rootNode.put("id", "resources");
                rootNode.put("type", "folder");
                rootNode.put("children", RepoEditor.getNodes("resources"));
                return new Object[]{rootNode};
            }
            File parent = new File(id);
            if (RepoEditor.isWSC(parent.getName())) {
                Map<Object, Object> fileContent = new LinkedHashMap();
                if (parent.exists()) {
                    fileContent = RepoEditor.getWSCFile(parent.getPath());
                }
                return fileContent.keySet().stream().map(k -> {
                    HashMap<String, String> node = new HashMap<String, String>();
                    node.put("text", (String)k);
                    node.put("id", String.valueOf(id) + "#" + k);
                    node.put("type", "node");
                    return node;
                }).toArray();
            }
            if (parent.getName().endsWith(".proto")) {
                List result = (List)StringTestStep.execute("getGRPCMethodNames", parent.getPath());
                System.err.println(result);
                System.out.println(parent);
                return result.stream().map(k -> {
                    HashMap<String, String> node = new HashMap<String, String>();
                    node.put("text", (String)k);
                    node.put("id", String.valueOf(id) + "#" + k);
                    node.put("type", "node-grpc");
                    return node;
                }).toArray();
            }
            String[] allowedTypes = QAF_CONTEXT.getStringArray("repoeditor.filetypes", ".wsc", ".loc", ".proto", "properties", ".locj", ".wscj");
            Object[] nodes = Files.list(parent.toPath()).filter(p -> p.toFile().isDirectory() || StringUtil.endsWithAny((String)p.toString(), (String[])allowedTypes)).map(p -> {
                HashMap<String, Object> node = new HashMap<String, Object>();
                node.put("text", p.toFile().getName());
                node.put("id", p.toString());
                if (p.toFile().isDirectory()) {
                    node.put("children", true);
                    node.put("type", "folder");
                } else {
                    String type = FileUtil.getExtention(p.toString());
                    node.put("type", "file-" + type);
                    node.put("children", "wscjproto".indexOf(type) >= 0);
                }
                return node;
            }).toArray();
            return nodes;
        }
        catch (IOException iOException) {
            return new Object[0];
        }
    }

    private static List<Map<String, Object>> getContent(String file) {
        LinkedList<Map<String, Object>> fileContent = new LinkedList<Map<String, Object>>();
        if (file.endsWith(".wscj")) {
            LinkedHashMap content = JSONUtil.getJsonObjectFromFile(file, Map.class);
            if (content == null) {
                content = new LinkedHashMap();
            }
            fileContent.add(content);
            return fileContent;
        }
        if (file.endsWith(".locj")) {
            LinkedHashMap content = JSONUtil.getJsonObjectFromFile(file, Map.class);
            if (content == null) {
                content = new LinkedHashMap();
            }
            for (Map.Entry entry : content.entrySet()) {
                LinkedHashMap loc = new LinkedHashMap();
                loc.put("key", entry.getKey());
                loc.putAll((Map)entry.getValue());
                fileContent.add(loc);
            }
            return fileContent;
        }
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            propertiesConfiguration.setEncoding(ApplicationProperties.LOCALE_CHAR_ENCODING.getStringVal("UTF-8"));
            propertiesConfiguration.setDelimiterParsingDisabled(true);
            propertiesConfiguration.load((InputStream)new FileInputStream(file));
            Iterator iter = propertiesConfiguration.getKeys();
            if (file.endsWith(".wsc")) {
                LinkedHashMap<String, Object> content = new LinkedHashMap<String, Object>();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = propertiesConfiguration.getString(key);
                    content.put(key, JSONUtil.toObject(value));
                }
                fileContent.add(content);
            }
            if (file.endsWith(".loc")) {
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = propertiesConfiguration.getString(key);
                    Object obj = JSONUtil.toObject(value);
                    LinkedHashMap<String, String> entry = new LinkedHashMap<String, String>();
                    entry.put("key", key);
                    if (obj instanceof Map) {
                        entry.putAll((Map)obj);
                    } else {
                        entry.put("locator", value);
                    }
                    fileContent.add(entry);
                }
            }
        }
        catch (ConfigurationException configurationException) {
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return fileContent;
    }

    private static Map<String, Object> getWSCFile(String file) {
        List<Map<String, Object>> content = RepoEditor.getContent(file);
        return content.isEmpty() ? JSONUtil.toMap("{}") : content.get(0);
    }

    private static void saveContent(List<Map<String, Object>> data, String file) throws IOException {
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        String fileContent = null;
        if (file.endsWith(".wscj")) {
            JSONUtil.writeJsonObjectToFile(file, data.get(0));
        } else if (file.endsWith(".wsc")) {
            fileContent = data.get(0).entrySet().stream().map(e -> String.valueOf((String)e.getKey()) + "=" + gson.toJson(e.getValue()).replace("\\", "\\\\")).collect(Collectors.joining("\n"));
        } else if (file.endsWith(".loc")) {
            fileContent = data.stream().map(e -> String.valueOf(e.remove("key").toString()) + "=" + gson.toJson(e).replace("\\", "\\\\")).collect(Collectors.joining("\n"));
        } else if (file.endsWith(".locj")) {
            JSONUtil.writeJsonObjectToFile(file, data.stream().filter(s -> s.get("key") != null).collect(Collectors.toMap(s -> s.remove("key"), s -> s)));
        } else {
            fileContent = gson.toJson(data);
        }
        if (fileContent != null) {
            FileUtil.writeStringToFile((File)new File(file), (String)fileContent, (String)ApplicationProperties.LOCALE_CHAR_ENCODING.getStringVal("UTF-8"));
        }
        QAF_CONTEXT.load(file);
    }

    private static void saveWSCFile(Map<String, Object> data, String file) throws IOException {
        LinkedList<Map<String, Object>> fileContent = new LinkedList<Map<String, Object>>();
        fileContent.add(data);
        RepoEditor.saveContent(fileContent, file);
    }

    static interface QAFRequestHandler
    extends HttpRequestHandler {
        default public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
            ConfigurationManager.setBundle(QAF_CONTEXT);
            TestBaseProvider.instance().set(QAF_TESTBASE);
            this.execute(request, response, context);
        }

        public void execute(ClassicHttpRequest var1, ClassicHttpResponse var2, HttpContext var3) throws HttpException, IOException;
    }
}

